/*
 * Decompiled with CFR 0.152.
 */
package jadeSocket;

import jadeSocket.MD5Test;
import jadeSocket.UnknownUserException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.Socket;

public class JSAceClient {
    private Socket s = null;
    private DataInputStream dis = null;
    private PrintStream ps = null;
    private String random = null;
    private boolean first = true;
    private int clientID = 0;
    private int port;
    private String host;
    private String msgtype;
    private String message;
    private boolean debug = false;
    private boolean debug1 = false;
    public static final int MAGIC = 305419896;
    public static final int VERSION = 1;
    public static final String ACESERV_MSGREQ = new String("ACESERV_MSGREQ");
    public static final String ACESERV_MSGOK = new String("ACESERV_MSGOK");
    public static final String ACESERV_MSGDATA = new String("ACESERV_MSGDATA");
    public static final String ACESERV_MSGENCORE = new String("ACESERV_MSGENCORE");
    public static final String ACESERV_MSGKILL = new String("ACESERV_MSGKILL");
    public static final String ACESERV_MSGFAIL = new String("ACESERV_MSGFAIL");
    public static final String HELLO = new String("bonjour");
    public static final String ENCORE = new String("encore");
    private final int HEAD_LENGTH = 50;

    public JSAceClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public JSAceClient(String host, int port, boolean debug1) {
        this(host, port);
        this.debug1 = debug1;
    }

    private void setMsgType(String mst) {
        this.msgtype = mst;
    }

    public String getMsgType() {
        return this.msgtype;
    }

    private void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    private void setRandom(String rs) {
        this.random = rs;
    }

    protected String getRandom() {
        return this.random;
    }

    private synchronized void initialize() {
        if (this.s != null) {
            if (this.debug) {
                System.out.println("Same socket");
            }
            return;
        }
        try {
            this.s = new Socket(this.host, this.port);
            if (this.debug) {
                System.out.println("Host connected...");
            }
            this.ps = new PrintStream(this.s.getOutputStream(), true);
            this.dis = new DataInputStream(this.s.getInputStream());
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public synchronized void startCommunication() {
        try {
            this.talk(HELLO);
            if (this.msgtype.equalsIgnoreCase(ACESERV_MSGOK)) {
                if (!this.verify()) {
                    System.out.println("You cannot be authorized. Sorry!");
                    this.quit();
                }
                while (true) {
                    System.out.print("AceDB_Socket> ");
                    LineNumberReader query = new LineNumberReader(new InputStreamReader(System.in));
                    String queryS = query.readLine();
                    if (queryS.length() == 4) {
                        queryS = queryS + " ";
                    }
                    if (this.debug) {
                        System.out.println(queryS);
                    }
                    this.talk(queryS);
                    if (queryS.trim().equalsIgnoreCase("quit")) {
                        this.quit();
                    }
                    if (!this.msgtype.equalsIgnoreCase(ACESERV_MSGKILL)) continue;
                    System.out.println("Connection is closed by the server. Try again later");
                    this.quit();
                }
            }
            System.out.println("Server cannot talk...");
            this.quit();
        }
        catch (IOException e) {
            System.out.println(e);
            this.quit();
        }
    }

    public synchronized void talk(String message) throws IOException {
        this.initialize();
        this.send(message);
        this.parseMessage();
    }

    public boolean verify() throws IOException {
        String user1 = null;
        String pwd1 = null;
        try {
            LineNumberReader input = new LineNumberReader(new BufferedReader(new InputStreamReader(System.in)));
            System.out.print("Plase input user name: ");
            user1 = input.readLine();
            System.out.println("User: " + user1);
            System.out.print("Please input password (It seems that there is not a simple way to turn the echo off in java): ");
            pwd1 = input.readLine();
            System.out.println("Password: " + pwd1);
        }
        catch (IOException e) {
            System.out.println("verify: " + e);
        }
        return this.verify(user1, pwd1);
    }

    public boolean verify(String user, String pwd) throws IOException {
        String hash = this.getHash(user, pwd);
        StringBuffer msgB = new StringBuffer();
        msgB.append(user);
        msgB.append(" ");
        msgB.append(hash);
        String msg = msgB.toString();
        if (this.debug) {
            System.out.println("The sending message: " + msg);
        }
        this.talk(msg);
        return this.msgtype.equalsIgnoreCase(ACESERV_MSGOK);
    }

    protected synchronized void send(String msg) {
        int length = msg.length();
        if (this.debug) {
            System.out.println("ClientID: " + this.clientID);
        }
        String request = msg.equalsIgnoreCase("encore") ? ACESERV_MSGENCORE : ACESERV_MSGREQ;
        byte[] message = this.encodeMessage(305419896, length, 1, this.clientID, 0, request, msg);
        if (this.debug) {
            System.out.println(new String(message));
        }
        try {
            this.ps.write(message, 0, message.length);
            this.ps.flush();
        }
        catch (Exception e) {
            System.out.println("Send method: " + e);
            this.quit();
        }
    }

    private String getHash(String user, String pwd) {
        MD5Test md = new MD5Test();
        String[] message1 = new String[]{user, pwd};
        String hash1 = md.getMD5(message1);
        if (this.debug) {
            System.out.println(hash1);
        }
        String[] message2 = new String[]{hash1, this.random};
        String hash2 = md.getMD5(message2);
        if (this.debug) {
            System.out.println(hash2);
        }
        return hash2;
    }

    private void quit() {
        this.close();
        System.out.println("Closing the connection to the server. Bye");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java host port");
            System.exit(0);
        }
        int port = Integer.parseInt(args[1]);
        String host = args[0];
        JSAceClient test = new JSAceClient(host, port, true);
        test.startCommunication();
    }

    protected synchronized void parseMessage() throws IOException {
        byte[] msg = null;
        int total = 0;
        if (this.debug) {
            System.out.println("Start parsing...");
        }
        int in = this.dis.readInt();
        if (this.debug) {
            System.out.println("Magic: 0x" + Integer.toHexString(in));
        }
        int length = this.dis.readInt();
        if (this.debug) {
            System.out.println("Length: " + length);
        }
        in = this.dis.readInt();
        if (this.debug) {
            System.out.println("Version: " + in);
        }
        this.clientID = this.dis.readInt();
        if (this.debug) {
            System.out.println("ClientID: " + this.clientID);
        }
        in = this.dis.readInt();
        if (this.debug) {
            System.out.println("MaxBytes: " + in);
        }
        byte[] msgtypeB = new byte[30];
        int msgtypeLength = this.dis.read(msgtypeB, 0, 30);
        this.msgtype = new String(msgtypeB).trim();
        if (this.debug) {
            System.out.print("MsgType: " + this.msgtype);
            System.out.println(" ---- length: " + msgtypeLength);
        }
        this.setMsgType(this.msgtype);
        msg = new byte[length - 1];
        total = 0;
        this.dis.readFully(msg);
        this.dis.skipBytes(1);
        String ss = new String(msg).trim();
        if (ss.indexOf("you are an unknown client") > 0) {
            throw new UnknownUserException();
        }
        if (this.first) {
            this.setRandom(ss);
            this.first = false;
        } else {
            this.setMessage(ss);
        }
        if (this.debug1) {
            System.out.println("Message: " + ss);
        }
        if (this.debug) {
            System.out.println("Message length: " + total);
        }
    }

    private void close() {
        try {
            this.dis.close();
            this.dis = null;
            this.ps.close();
            this.ps = null;
            this.s.close();
            this.s = null;
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    protected synchronized byte[] encodeMessage(int magic, int length, int version, int clientID, int maxBytes, String request, String message) {
        byte[] rtn = null;
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bao);
            dos.writeInt(magic);
            dos.writeInt(length + 1);
            dos.writeInt(version);
            dos.writeInt(clientID);
            dos.writeInt(maxBytes);
            dos.writeBytes(request);
            int pad = 0;
            while (bao.size() < 50) {
                dos.writeByte(pad);
            }
            dos.writeBytes(message);
            byte[] nu = new byte[]{0};
            dos.write(nu, 0, 1);
            rtn = bao.toByteArray();
            bao.close();
            dos.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return rtn;
    }
}

