/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.AceAccessor;
import jade.db.AceObject;
import jade.db.AceString;
import jade.db.PushBackStream;
import java.io.DataInputStream;
import java.io.IOException;

public class AceTable
extends AceObject {
    protected String[] theQuery;
    protected int rows;
    protected int columns;
    protected boolean runtime = false;
    protected String[] params = new String[0];
    protected static String runTimeName = "Runtime table";
    protected static String runTimeClass = "Table";

    public AceTable() {
        this.theQuery = null;
        this.database = null;
        this.runtime = true;
        this.name = runTimeName;
        this.classe = runTimeClass;
    }

    protected AceTable(String[] query, AceAccessor theDatabase) {
        this.theQuery = query;
        this.database = theDatabase;
        this.runtime = true;
        this.name = runTimeName;
        this.classe = runTimeClass;
        this.register();
    }

    protected AceTable(AceAccessor theDatabase) {
        super(theDatabase);
        this.runtime = true;
    }

    protected AceTable(AceObject tableObject, String[] parameters) {
        this.database = tableObject.database;
        if (tableObject.classe.equals("Table")) {
            this.name = tableObject.name;
            this.params = parameters;
        } else {
            System.err.println("Attempt to pass a non-Table object to the AceTable constructor.  Object's class was " + tableObject.classe);
        }
        this.classe = runTimeClass;
    }

    protected AceTable(DataInputStream in) {
        super(in);
        this.runtime = true;
    }

    protected AceTable(String ID, String[] parameters, AceAccessor theDatabase) {
        this.database = theDatabase;
        this.params = parameters;
        this.name = ID;
        this.classe = runTimeClass;
    }

    public AceTable(String ID, AceAccessor theDatabase) {
        this.database = theDatabase;
        this.name = ID;
        this.classe = runTimeClass;
    }

    protected AceTable(String theType, String theID, AceAccessor theDatabase) {
        this.classe = theType;
        this.name = theID;
        this.database = theDatabase;
        this.register();
    }

    public int colCount() {
        this.fill();
        return this.columns;
    }

    protected synchronized boolean initializeFromStream(PushBackStream in, AceAccessor db) {
        AceObject rowhead = null;
        AceObject previous = null;
        this.rows = 0;
        while (true) {
            String[] elements;
            String input;
            try {
                input = in.readLine();
                input = input.trim();
            }
            catch (IOException e) {
                input = null;
            }
            if (input == null || input.length() == 0 || (elements = new AceString(input).split('\t')).length <= 0) break;
            this.columns = elements.length;
            ++this.rows;
            AceObject[] thisRow = new AceObject[elements.length];
            previous = null;
            int i = elements.length - 1;
            while (i >= 0) {
                AceString aS = new AceString(elements[i]);
                thisRow[i] = new AceObject();
                thisRow[i].classe = aS.aceClass();
                thisRow[i].name = aS.aceID();
                thisRow[i].database = db;
                thisRow[i].tried2fill = true;
                thisRow[i].filled = true;
                thisRow[i].right = previous;
                previous = thisRow[i];
                --i;
            }
            if (rowhead == null) {
                this.right = thisRow[0];
                if (this.name.equals("")) {
                    this.name = runTimeName;
                }
                if (this.classe.equals("")) {
                    this.classe = runTimeClass;
                }
            } else {
                rowhead.down = thisRow[0];
            }
            rowhead = thisRow[0];
        }
        return true;
    }

    protected AceObject low_fill() throws IOException {
        return this.database.table_fill(this);
    }

    protected static String paramToString(String name, String[] parameters) {
        StringBuffer concat = new StringBuffer(name + ":");
        int i = 0;
        while (i < parameters.length) {
            concat.append(parameters[i]);
            if (i < parameters.length - 1) {
                concat.append(",");
            }
            ++i;
        }
        return concat.toString();
    }

    protected String registration_id() {
        if (this.params != null) {
            return AceTable.paramToString(this.name(), this.params);
        }
        return AceTable.paramToString(this.name(), this.theQuery);
    }

    public int rowCount() {
        this.fill();
        return this.rows;
    }

    public AceObject[][] toTable() {
        this.fill();
        AceObject[][] result = new AceObject[this.rows][this.columns];
        AceObject rowHeader = this.right;
        int r = 0;
        while (rowHeader != null) {
            int c = 0;
            AceObject current = rowHeader;
            while (current != null) {
                result[r][c] = current;
                current = current.right;
                ++c;
            }
            rowHeader = rowHeader.down;
            ++r;
        }
        return result;
    }
}

