/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.Accessor;
import jade.db.AceAccessor;
import jade.db.AceString;
import jade.db.PushBackStream;
import jade.util.Key;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

public class AceObject
extends Key {
    public String classe = null;
    protected AceObject right = null;
    protected AceObject down = null;
    protected AceAccessor database = null;
    protected boolean filled = false;
    protected boolean tried2fill = false;
    protected boolean tried2pick = false;
    protected boolean pickedOK = false;
    protected static DateFormat df = DateFormat.getDateInstance();
    protected static boolean debug = false;
    protected static boolean debug2 = false;

    public AceObject() {
    }

    protected AceObject(String[] elements, PushBackStream in, int level, AceAccessor db) {
        this.database = db;
        this.tried2fill = true;
        try {
            this.parseInputStream(elements, in, level, db);
            this.filled = true;
        }
        catch (IOException e) {
            this.filled = false;
        }
    }

    protected AceObject(AceAccessor theDatabase) {
        if (this.initializeFromStream(theDatabase.in, theDatabase)) {
            this.database = theDatabase;
        }
        this.register();
    }

    protected AceObject(DataInputStream in) {
        if (this.initializeFromStream(new PushBackStream(new BufferedReader(new InputStreamReader(in))), null)) {
            this.database = null;
        }
    }

    protected AceObject(String theType, String theID, AceAccessor theDatabase) {
        this.classe = theType;
        this.name = theID;
        this.database = theDatabase;
        this.register();
    }

    protected static boolean _isClass(String classe) {
        if (classe.equals("float")) {
            return false;
        }
        if (classe.equals("int")) {
            return false;
        }
        if (classe.equals("date")) {
            return false;
        }
        if (classe.equals("tag")) {
            return false;
        }
        if (classe.equals("txt")) {
            return false;
        }
        if (classe.equals("dna")) {
            return false;
        }
        return !classe.equals("peptide");
    }

    public Accessor accessor() {
        return this.database;
    }

    protected int appendToString(StringBuffer out, int position, int level) {
        int i = position;
        while (i < level) {
            out.append('\t');
            ++i;
        }
        out.append(this.name);
        if (this.right != null) {
            level = this.right.appendToString(out, level, level + 1);
        }
        if (this.down != null) {
            out.append('\n');
            level = this.down.appendToString(out, 0, level);
        } else {
            --level;
        }
        return level;
    }

    public AceObject at(String key) {
        this.fill();
        AceObject next = this.right;
        while (next != null) {
            if (next.name.equalsIgnoreCase(key)) {
                return next;
            }
            next = next.down;
        }
        return null;
    }

    public Object bestType() {
        if (this.isClass()) {
            return new AceObject(this.classe, this.name, this.database.dup());
        }
        if (this.classe.equals("float")) {
            return Float.valueOf(this.name);
        }
        if (this.classe.equals("int")) {
            return Integer.valueOf(this.name);
        }
        if (this.classe.equals("date")) {
            try {
                return df.parse(this.name);
            }
            catch (ParseException e) {
                return new Date(0L);
            }
        }
        return this.name;
    }

    public String classe() {
        return this.classe;
    }

    public Object[] col() {
        this.fill();
        AceObject next = this.right;
        Vector<Object> objects = new Vector<Object>(10);
        while (next != null) {
            objects.addElement(next.bestType());
            next = next.down;
        }
        Object[] result = new Object[objects.size()];
        int i = 0;
        while (i < objects.size()) {
            result[i] = objects.elementAt(i);
            ++i;
        }
        return result;
    }

    public int countKeys() {
        this.fill();
        int result = 0;
        AceObject current = this.right;
        while (current != null) {
            ++result;
            current = current.down;
        }
        return result;
    }

    public Date dateOf() {
        Date result;
        try {
            result = df.parse(this.name);
        }
        catch (ParseException e) {
            result = new Date(0L);
        }
        return result;
    }

    public double doubleOf() {
        double result;
        try {
            result = Double.valueOf(this.name);
        }
        catch (NumberFormatException e) {
            result = 0.0;
        }
        return result;
    }

    public AceObject down() {
        this.fill();
        return this.down;
    }

    public String dump() {
        this.fill();
        StringBuffer newString = new StringBuffer(1024);
        newString.append(this.name);
        if (this.right != null) {
            newString.append("\t");
            this.right.appendToString(newString, 1, 1);
        }
        return newString.toString();
    }

    public boolean equals(Object obj) {
        try {
            AceObject k = (AceObject)obj;
            return k.name != null && k.name.equals(this.name) && k.classe != null && k.classe.equals(this.classe);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected synchronized void fill() {
        if (this.tried2fill) {
            return;
        }
        if (this.right != null || this.down != null || this.database == null || this.name == null || this.name.length() == 0 || this.classe == null || this.classe.length() == 0 || !this.isClass()) {
            return;
        }
        this.register();
        if (debug2) {
            System.err.println("Filling " + this);
        }
        try {
            this.right = this.low_fill();
        }
        catch (IOException e) {
            this.tried2fill = true;
            return;
        }
    }

    public boolean filled() {
        return this.filled;
    }

    public Object[] flatten() {
        return this.row();
    }

    public float floatOf() {
        float result;
        try {
            result = Float.valueOf(this.name).floatValue();
        }
        catch (NumberFormatException e) {
            result = 0.0f;
        }
        return result;
    }

    public AceObject[] follow(String key) {
        return this.follow(key, -1);
    }

    public AceObject[] follow(String key, int maxObjects) {
        AceObject found = this.get(key);
        if (debug2) {
            System.err.println("found " + found);
            System.err.println("found.right() " + found.right());
        }
        if (this.database == null) {
            return null;
        }
        return this.database.follow(this.classe, this.name, key, maxObjects);
    }

    public AceObject followOne(String key) {
        AceObject[] o = this.follow(key, 1);
        if (o == null) {
            return null;
        }
        return o[0];
    }

    public AceObject get(String key) {
        this.fill();
        AceObject next = this.right;
        while (next != null) {
            if (next.classe.equalsIgnoreCase("tag") && next.name.equalsIgnoreCase(key)) {
                return next;
            }
            AceObject found = null;
            found = next.get(key);
            if (found != null) {
                return found;
            }
            next = next.down;
        }
        return null;
    }

    public Class[] getDisplays() {
        return this.database.getClassDisplays(this.classe);
    }

    public Object[][] getTable(String displayName, String tableName, String[] params, String ccc) {
        return this.database.getTable(this.database.getTableName(this.classe, displayName, tableName), params, ccc);
    }

    protected boolean initializeFromStream(PushBackStream in, AceAccessor db) {
        if (debug2) {
            System.err.println(this + " AceObject.initializeFromStream()");
        }
        try {
            String[] elements = new AceString(in.readLine()).split('\t');
            if (elements.length <= 0) {
                return false;
            }
            AceString aS = new AceString(elements[0]);
            this.name = aS.aceID();
            this.classe = aS.aceClass();
            this.right = new AceObject(elements, in, 1, db);
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    public int intOf() {
        int result;
        try {
            result = Integer.parseInt(this.name);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        return result;
    }

    public boolean isClass() {
        return AceObject._isClass(this.classe);
    }

    public boolean isTag() {
        return this.classe.equals("tag");
    }

    public AceObject[] keys() {
        int length = this.countKeys();
        AceObject[] result = new AceObject[length];
        AceObject current = this.right;
        int i = 0;
        while (i < length) {
            result[i] = current;
            current = current.down;
            ++i;
        }
        return result;
    }

    protected AceObject low_fill() throws IOException {
        return this.database.low_fill(this);
    }

    public Object node(String key) {
        this.fill();
        AceObject tree = this.get(key);
        if (tree == null) {
            return null;
        }
        return tree.bestType();
    }

    protected void parseInputStream(String[] elements, PushBackStream in, int level, AceAccessor db) throws IOException {
        String input;
        Thread.yield();
        AceString aS = new AceString(elements[level]);
        this.name = aS.aceID();
        this.classe = aS.aceClass();
        if (debug) {
            System.err.println("\tClass=" + this.classe + " Name=" + this.name + " Level=" + level);
        }
        if (elements.length > level + 1) {
            if (debug) {
                System.err.println(this.name + ": Adding an object to the right");
            }
            this.right = new AceObject(elements, in, level + 1, db);
        }
        if ((input = in.readLine()) == null) {
            return;
        }
        int newLevel = new AceString(input).countTabs();
        if (newLevel == level) {
            if (debug) {
                System.err.println(this.name + ": Adding an object to the bottom");
            }
            this.down = new AceObject(new AceString(input).split('\t'), in, level, db);
        } else if (newLevel < level) {
            in.pushBack(input);
        }
    }

    public AceObject pick() {
        if (this.status() <= 1) {
            return null;
        }
        this.tried2pick = true;
        AceObject result = this.database.dup().fetch(this.classe, this.name);
        this.pickedOK = result != null;
        return result;
    }

    public AceObject pick(String key) {
        AceObject subtree = this.get(key);
        if (subtree == null) {
            return null;
        }
        return subtree.right().pick();
    }

    protected void register() {
        if (debug2) {
            System.err.println("Registering " + this + " == " + this.registration_id());
        }
        if (AceObject._isClass(this.classe) && this.database != null) {
            this.database.touch(this);
        }
    }

    protected String registration_id() {
        return this.name();
    }

    public AceObject right() {
        this.fill();
        return this.right;
    }

    public Object[] row() {
        this.fill();
        AceObject next = this.right;
        Vector<Object> objects = new Vector<Object>(10);
        while (next != null) {
            objects.addElement(next.bestType());
            next = next.right;
        }
        Object[] result = new Object[objects.size()];
        int i = 0;
        while (i < objects.size()) {
            result[i] = objects.elementAt(i);
            ++i;
        }
        return result;
    }

    public int status() {
        if (!this.isClass()) {
            return 0;
        }
        if (this.tried2pick) {
            return this.pickedOK ? 3 : 1;
        }
        AceObject peer = this.database.fetch(this.classe, this.name, true);
        if (peer != null && peer != this) {
            this.pickedOK = true;
            this.tried2pick = true;
            return 3;
        }
        return 2;
    }

    public String stringOf() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.classe + ")";
    }

    protected synchronized void unfill() {
        if (debug2) {
            System.err.println("Unfilling " + this);
        }
        this.right = null;
        this.down = null;
        this.filled = false;
        this.tried2fill = false;
    }
}

