/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.Accessor;
import jade.db.AccessorPool;
import jade.db.AceCache;
import jade.db.AceEnumerator;
import jade.db.AceObject;
import jade.db.AceString;
import jade.db.AceTable;
import jade.db.PushBackStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AceAccessor
extends Accessor {
    public boolean good = false;
    public boolean echoMode = false;
    public int totalCount = 0;
    public static int OK = 200;
    public static int GOODBYE = 201;
    public static int DEBUG = 301;
    public static int COMMENT = 302;
    public static int REDIRECT = 303;
    public static int PARAMERROR = 401;
    public static int SYNTAXERROR = 402;
    public static int UNIMPLEMENTED = 403;
    public static int TIMEOUTERROR = 501;
    public static int COMMERROR = 502;
    public static int MEMERROR = 503;
    public static int FILEERROR = 504;
    public static int MAX_CONN = 3;
    public static int CACHE_MIN = 1000;
    public static int CACHE_MAX = 1500;
    private File fil;
    protected PushBackStream in;
    protected PrintWriter out;
    private String aceHost;
    private int acePort;
    private Socket aceH;
    protected AceCache cache;
    private static boolean debug = false;
    private static Hashtable pool = null;
    private Class[] mainDisplays = null;
    private AceObject jadeChoice = null;

    protected AceAccessor() {
    }

    public AceAccessor(File fil) throws IOException {
        this.in = new PushBackStream(new BufferedReader(new FileReader(fil)));
        this.out = null;
        this.cache = new AceCache(CACHE_MIN, CACHE_MAX);
        this.echoMode = true;
        this.good = true;
    }

    public AceAccessor(String host, int port) throws IOException {
        this(host, port, false, true);
    }

    public AceAccessor(String host, int port, boolean debugMode, boolean makeCache) throws IOException {
        this.aceHost = host;
        this.acePort = port;
        InetAddress address = InetAddress.getByName(this.aceHost);
        this.aceH = new Socket(address, this.acePort);
        if (this.aceH == null) {
            return;
        }
        this.in = new PushBackStream(new BufferedReader(new InputStreamReader(this.aceH.getInputStream())));
        this.out = new PrintWriter(this.aceH.getOutputStream(), true);
        String line = this.read();
        if (this.resultCode(line) != OK) {
            this.aceH.close();
            this.in = null;
            this.out = null;
            throw new IOException(this.resultMessage(line));
        }
        if (makeCache) {
            this.cache = new AceCache(CACHE_MIN, CACHE_MAX);
        }
        this.echoMode = debugMode;
        this.good = true;
    }

    public void cacheStats() {
        this.cache.dumpStats();
    }

    public int count(String classe, String name) {
        return this.countRequest("find " + classe + " " + name);
    }

    protected synchronized int countRequest(String query) {
        try {
            int resultCode;
            String result;
            try {
                this.write(query);
                result = this.read();
                resultCode = this.resultCode(result);
            }
            catch (IOException e) {
                this.rebuildConnection();
                this.write(query);
                result = this.read();
                resultCode = this.resultCode(result);
            }
            if (resultCode != OK) {
                return -1;
            }
            return this.foundCount(result);
        }
        catch (IOException e) {
            return -1;
        }
    }

    public AceAccessor dup() {
        AceAccessor returnval = this;
        try {
            returnval = AceAccessor.open(this.aceHost, this.acePort, false);
        }
        catch (IOException e) {
            returnval = this;
        }
        returnval.cache = this.cache;
        return returnval;
    }

    public AceObject fetch(String classe, String name) {
        return this.fetch(classe, name, false);
    }

    public AceObject fetch(String classe, String name, boolean cacheOnly) {
        boolean reserve;
        AceObject ace = null;
        boolean bl = reserve = !cacheOnly;
        if (this.cache != null) {
            ace = this.cache.fetch(classe, name, reserve);
            if (ace != null) {
                return ace;
            }
            if (cacheOnly) {
                return null;
            }
        }
        if ((ace = this.low_fetch(classe, name, false)) != null) {
            return ace;
        }
        if (reserve) {
            this.cache.unreserve(classe, name);
        }
        return null;
    }

    public AceObject fetch(String classe, String name, boolean cacheOnly, boolean fill) {
        return this.low_fetch(classe, name, fill);
    }

    protected void finalize() throws IOException {
        this.write("quit");
    }

    public AceObject[] find(String classe, String name) {
        return this.requestObjects("find " + classe + " " + name, 0, -1);
    }

    public AceObject[] find(String classe, String name, int length) {
        return this.requestObjects("find " + classe + " " + name, 0, length);
    }

    public Enumeration find_many(String classe, String name) {
        return new AceEnumerator("find " + classe + " " + name, this);
    }

    public AceObject find_one(String classe, String name) {
        AceObject[] result = this.requestObjects("find " + classe + " " + name, 0, 1);
        if (result == null || result.length <= 0) {
            System.out.println("find_one failed on " + classe + ":" + name);
            return null;
        }
        return result[0];
    }

    public AceObject[] follow(String classe, String name, String tag) {
        return this.follow(classe, name, tag, -1);
    }

    public synchronized AceObject[] follow(String classe, String name, String tag, int length) {
        int objects = this.count(classe, name);
        if (objects != 1) {
            return null;
        }
        if (this.request("follow " + tag) != OK) {
            return null;
        }
        return this.list(0, length);
    }

    protected int foundCount(String a) throws IOException {
        return this.resultCode(this.resultMessage(a));
    }

    public Class[] getClassDisplays(String klasse) {
        AceObject next;
        Vector<Class> objects = new Vector<Class>(10);
        if (this.jadeChoice == null) {
            this.jadeChoice = this.find_one("Jade", "default");
        }
        Class dd = null;
        if (this.jadeChoice != null && (next = this.jadeChoice.at("Display")) != null && (next = next.at(klasse)) != null) {
            next = next.right();
            while (next != null) {
                dd = this.name2dd(next.name);
                if (dd != null) {
                    objects.addElement(dd);
                }
                next = next.down();
            }
        }
        if ((dd = this.name2dd("jade.maps.TreeDisplay")) != null) {
            objects.addElement(dd);
        }
        Class[] result = new Class[objects.size()];
        int i = 0;
        while (i < objects.size()) {
            result[i] = (Class)objects.elementAt(i);
            ++i;
        }
        return result;
    }

    public Class[] getMainDisplays() {
        AceObject next;
        Class dd = null;
        if (this.mainDisplays != null) {
            return this.mainDisplays;
        }
        Vector<Class> objects = new Vector<Class>(10);
        if (this.jadeChoice == null) {
            this.jadeChoice = this.find_one("Jade", "default");
        }
        if (this.jadeChoice != null && (next = this.jadeChoice.at("StandAloneDisplay")) != null) {
            next = next.right();
            while (next != null) {
                dd = this.name2dd(next.name);
                if (dd != null) {
                    objects.addElement(dd);
                }
                next = next.down();
            }
        }
        this.mainDisplays = new Class[objects.size()];
        int i = 0;
        while (i < objects.size()) {
            this.mainDisplays[i] = (Class)objects.elementAt(i);
            ++i;
        }
        return this.mainDisplays;
    }

    public String getRawData(String query) {
        if (debug) {
            System.out.println("AceAcessor.getRawData" + query);
        }
        return this.rawDataRequest(query);
    }

    public Object[][] getTable(String name, String[] params, String ccc) {
        String[] parameters = params == null ? new String[]{} : params;
        if (debug) {
            System.out.println("AceAccessor.getTable " + name + " parameter[0] " + parameters[0]);
        }
        AceTable tab = this.low_tableQuery(name, parameters);
        AceObject[][] t = tab.toTable();
        char[] classes = ccc.toCharArray();
        int ncol = classes.length;
        int nline = t.length;
        Object[][] u = new Object[nline][ncol];
        if (debug) {
            System.out.println("AceAccessor.getTable found " + nline + " lines");
        }
        int j = 0;
        while (j < nline) {
            int i = 0;
            while (i < ncol && i < t[j].length) {
                char cc = classes[i];
                AceObject x = t[j][i];
                if (x != null) {
                    switch (cc) {
                        case 'k': {
                            u[j][i] = x;
                            break;
                        }
                        case 'i': {
                            int ii = x.intOf();
                            Integer I = new Integer(ii);
                            u[j][i] = I;
                            break;
                        }
                        case 's': {
                            String S = x.name;
                            u[j][i] = S;
                            break;
                        }
                        case 'f': {
                            float f = x.floatOf();
                            Float F = new Float(f);
                            u[j][i] = F;
                            break;
                        }
                        default: {
                            u[j][i] = null;
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        return u;
    }

    public String getTableName(String klasse, String displayName, String tab) {
        AceObject next;
        if (this.jadeChoice == null) {
            this.jadeChoice = this.find_one("Jade", "default");
        }
        if ((next = this.jadeChoice.at("Display")) != null && (next = next.at(klasse)) != null && (next = next.at(displayName)) != null && (next = next.at(tab)) != null) {
            next = next.right();
        }
        if (next != null) {
            return next.name();
        }
        return tab;
    }

    public AceObject[] list() {
        return this.list(0, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized AceObject[] list(int start, int length) {
        int cnt = 0;
        Vector<AceObject> objects = new Vector<AceObject>(10);
        int max = length >= 0 ? length : Integer.MAX_VALUE;
        String command = "list -b " + start + " -c " + length;
        try {
            String nextline;
            if (this.request(command) != OK) {
                return null;
            }
            while (cnt < max && (nextline = this.read()) != null && nextline.length() != 0) {
                AceString a = new AceString(nextline);
                AceObject ao = this.cache.fetch(a.aceClass(), a.aceID(), true);
                if (ao == null) {
                    ao = new AceObject(a.aceClass(), a.aceID(), this);
                }
                objects.addElement(ao);
                ++cnt;
            }
            AceObject[] result = new AceObject[cnt];
            int i = 0;
            while (true) {
                if (i >= cnt) {
                    this.sync();
                    return result;
                }
                result[i] = (AceObject)objects.elementAt(i);
                ++i;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    protected synchronized AceObject low_fetch(String classe, String name, boolean fill) {
        int count = this.count(classe, name);
        if (count < 0) {
            return null;
        }
        if (count > 1) {
            return null;
        }
        AceObject ace = null;
        if (fill) {
            StringBuffer message = new StringBuffer(20);
            int result = this.request("show", message);
            if (result == OK) {
                ace = new AceObject(this);
                this.sync();
            }
        } else {
            ace = new AceObject(classe, name, this);
        }
        return ace;
    }

    protected synchronized AceObject low_fill(AceObject a) throws IOException {
        AceObject result = null;
        if (this.count(a.classe, a.name) == 1 && this.request("show") == OK) {
            String inputLine = this.in.readLine();
            String[] elements = new AceString(inputLine).split('\t');
            if (AceObject.debug2) {
                System.err.println("AceAccessor: low_fill() of AceObject " + a);
            }
            result = new AceObject(elements, this.in, 1, this);
            this.sync();
        }
        return result;
    }

    protected AceTable low_tableQuery(String name, String[] parameters) {
        AceTable ace;
        String ID = AceTable.paramToString(name, parameters);
        if (debug) {
            System.out.println("low_tableQuery 1");
        }
        if ((ace = (AceTable)this.cache.fetch(AceTable.runTimeClass, ID, true)) != null) {
            if (debug) {
                System.out.println("low_tableQuery 2");
            }
            return ace;
        }
        if (debug) {
            System.out.println("low_tableQuery 2bis");
        }
        if (name.equals(AceTable.runTimeName)) {
            ace = new AceTable(parameters, this);
            if (debug) {
                System.out.println("low_tableQuery 3");
            }
        } else {
            ace = new AceTable(name, parameters, this);
            if (debug) {
                System.out.println("low_tableQuery 4");
            }
        }
        if (ace != null) {
            return ace;
        }
        if (debug) {
            System.out.println("low_tableQuery 5");
        }
        this.cache.unreserve(AceTable.runTimeClass, ID);
        return null;
    }

    public static void main(String[] args) {
        AceAccessor worm = null;
        try {
            worm = new AceAccessor("alpha.crbm.cnrs-mop.fr", 20100);
            System.out.println("Connect to the server successfully.");
        }
        catch (IOException e) {
            System.out.println(e);
        }
        Class[] classes = worm.getMainDisplays();
        int i = 0;
        while (i < classes.length) {
            System.out.println(classes[i]);
            ++i;
        }
    }

    private Class name2dd(String s) {
        try {
            Class<?>[] ff;
            Class<?> c;
            if (debug) {
                System.out.println("Invoker looks for " + s);
            }
            if ((c = Class.forName(s)) == null) {
                return null;
            }
            if (debug) {
                System.out.println("Invoker found class " + s);
            }
            if ((ff = c.getInterfaces()) != null) {
                if (debug) {
                    System.out.println("Invoker found some interface");
                }
                int j = ff.length - 1;
                while (j >= 0 && !ff[j].getName().equals("jade.graphics.Displayable")) {
                    --j;
                }
                if (j >= 0) {
                    if (debug) {
                        System.out.println("Invoker found Displayable interface");
                    }
                    return c;
                }
            }
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("Invoking exception" + e);
            }
            return null;
        }
        return null;
    }

    public static synchronized AceAccessor open(String host, int port) throws IOException {
        return AceAccessor.open(host, port, true);
    }

    public static synchronized AceAccessor open(String host, int port, boolean cache) throws IOException {
        AccessorPool a;
        if (pool == null) {
            pool = new Hashtable();
        }
        if ((a = (AccessorPool)pool.get(host + ":" + port)) == null) {
            a = new AccessorPool(host, port, MAX_CONN);
            pool.put(host + ":" + port, a);
        }
        return a.createOrPick(cache);
    }

    public AceObject[] query(String queryStr) {
        return this.requestObjects("query " + queryStr, 0, -1);
    }

    public AceObject[] query(String queryStr, int length) {
        return this.requestObjects("query " + queryStr, 0, length);
    }

    public Enumeration query_many(String queryStr) {
        return new AceEnumerator(queryStr, this);
    }

    protected synchronized String rawDataRequest(String query) {
        try {
            int resultCode;
            String line;
            try {
                this.write(query);
                line = this.read();
                resultCode = this.resultCode(line);
            }
            catch (IOException e) {
                this.rebuildConnection();
                this.write(query);
                line = this.read();
                resultCode = this.resultCode(line);
            }
            if (resultCode != OK) {
                return null;
            }
            String result = new String();
            while ((line = this.read()) != null && !line.equals(".")) {
                result = result.concat("\n" + line);
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String read() throws IOException {
        String result = this.in.readLine();
        if (this.echoMode) {
            System.err.println("AceAccessor read< " + result);
        }
        Thread.yield();
        return result;
    }

    protected synchronized void readToDot() {
        boolean found = false;
        try {
            while (!found) {
                String line = this.read();
                found = line.equals(".");
            }
        }
        catch (IOException e) {
            boolean bl = true;
        }
    }

    protected void rebuildConnection() throws IOException {
        InetAddress address = InetAddress.getByName(this.aceHost);
        this.aceH = new Socket(address, this.acePort);
        if (this.aceH == null) {
            throw new IOException("Couldn't reallocate database handle");
        }
        this.in = new PushBackStream(new BufferedReader(new InputStreamReader(this.aceH.getInputStream())));
        this.out = new PrintWriter(this.aceH.getOutputStream(), true);
        String line = this.read();
        if (this.resultCode(line) != OK) {
            this.aceH.close();
            this.in = null;
            this.out = null;
            throw new IOException(this.resultMessage(line));
        }
        this.good = true;
    }

    protected synchronized int request(String query) {
        int resultCode = -1;
        try {
            try {
                this.write(query);
                String result = this.read();
                resultCode = this.resultCode(result);
            }
            catch (IOException e) {
                this.rebuildConnection();
                this.write(query);
                String result = this.read();
                resultCode = this.resultCode(result);
            }
            return resultCode;
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected synchronized int request(String query, StringBuffer message) {
        try {
            int resultCode;
            String result;
            try {
                this.write(query);
                result = this.read();
                resultCode = this.resultCode(result);
            }
            catch (IOException e) {
                this.rebuildConnection();
                this.write(query);
                result = this.read();
                resultCode = this.resultCode(result);
            }
            message.setLength(0);
            message.append(this.resultMessage(result));
            return resultCode;
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected synchronized AceObject[] requestObjects(String query, int start, int length) {
        int found;
        this.totalCount = found = this.countRequest(query);
        if (found <= 0) {
            return null;
        }
        return this.list(start, length);
    }

    protected int resultCode(String a) throws IOException {
        int index = a.indexOf(32);
        if (index < 0) {
            return -1;
        }
        try {
            int r = Integer.parseInt(a.substring(0, index));
            if (r == TIMEOUTERROR) {
                this.good = false;
                throw new IOException("Ace connection timed out.  Rebuild connection.");
            }
            return Integer.parseInt(a.substring(0, index));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected String resultMessage(String a) {
        int index = a.indexOf(32);
        if (index < 0) {
            return "";
        }
        return a.substring(index + 1, a.length());
    }

    protected void sync() {
        this.readToDot();
    }

    protected synchronized int table(String[] query) {
        int result = -1;
        try {
            result = this.request("table");
            if (result != OK) {
                return result;
            }
            int i = 0;
            while (i < query.length) {
                this.write(query[i]);
                ++i;
            }
            this.write(".");
            String input = this.read();
            return this.resultCode(input);
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected int table(String tName, String[] parameters) {
        int result = -1;
        StringBuffer p = new StringBuffer("ntable");
        p.append(" " + tName);
        int i = 0;
        while (i < parameters.length) {
            p.append(" " + parameters[i]);
            ++i;
        }
        result = this.request(p.toString());
        return result;
    }

    protected synchronized AceObject table_fill(AceTable a) throws IOException {
        if (a.runtime) {
            if (a.theQuery == null) {
                return null;
            }
            if (this.table(a.theQuery) == OK) {
                a.initializeFromStream(this.in, this);
                this.sync();
            }
        } else if (this.table(a.name, a.params) == OK) {
            a.initializeFromStream(this.in, this);
            this.sync();
        }
        return a.right;
    }

    public AceTable tableQuery(String[] query) {
        return this.low_tableQuery(AceTable.runTimeName, query);
    }

    public AceTable tableQuery(AceObject theTable, String[] parameters) {
        return this.low_tableQuery(theTable.name, parameters);
    }

    public AceTable tableQuery(String name, String[] parameters) {
        return this.low_tableQuery(name, parameters);
    }

    protected void touch(AceObject a) {
        this.cache.touch(a);
    }

    protected void write(String text) throws IOException {
        if (this.echoMode) {
            System.err.println("AceAccessor write> " + text + " out=" + this.out);
        }
        if (text != null && this.out != null) {
            this.out.println(text);
        }
        Thread.yield();
    }
}

