/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.AceAccessor;
import java.io.IOException;

final class AccessorPool {
    private String theHost;
    private int thePort;
    private int lastUsed;
    private int numberActive;
    private AceAccessor[] theList;

    AccessorPool(String string, int n, int n2) {
        this.theHost = string;
        this.thePort = n;
        this.theList = new AceAccessor[n2];
        this.lastUsed = 0;
        this.numberActive = 0;
    }

    synchronized AceAccessor createOrPick(boolean bl) throws IOException {
        AceAccessor aceAccessor;
        if (this.numberActive < this.theList.length) {
            aceAccessor = new AceAccessor(this.theHost, this.thePort, false, bl);
            if (aceAccessor.good) {
                this.theList[this.numberActive] = aceAccessor;
                this.lastUsed = this.numberActive++;
                return aceAccessor;
            }
        }
        if (this.numberActive <= 0) {
            return null;
        }
        ++this.lastUsed;
        if (this.lastUsed >= this.numberActive) {
            this.lastUsed = 0;
        }
        aceAccessor = this.theList[this.lastUsed];
        if (!aceAccessor.good) {
            try {
                aceAccessor.rebuildConnection();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return aceAccessor;
    }
}

