package Bio::GMOD::CMap::Apache::HelpViewer;
# vim: set ft=perl:

# $Id: HelpViewer.pm,v 1.16 2006/06/05 21:21:38 mwz444 Exp $

use strict;
use vars qw( $VERSION );
$VERSION = (qw$Revision: 1.16 $)[-1];

use Bio::GMOD::CMap::Apache;
use base 'Bio::GMOD::CMap::Apache';

use constant TEMPLATES     => {
    default                => 'help_map_viewer.tmpl',
    correspondence_details => 'help_correspondence.tmpl',
    evidence_type_info     => 'help_evidence_type_info.tmpl',
    feature_alias_details  => 'help_feature_alias_details.tmpl',
    feature_details        => 'help_feature_details.tmpl',
    feature_search         => 'help_feature_search.tmpl',
    feature_type_info      => 'help_feature_type_info.tmpl',
    saved_links            => 'help_saved_links.tmpl',
    matrix                 => 'help_matrix.tmpl',
    map_search             => 'help_map_search.tmpl',
    map_set_info           => 'help_map_set_info.tmpl',
    map_type_info          => 'help_map_type_info.tmpl',
    map_details            => 'help_map_details.tmpl',
    map_viewer             => 'help_map_viewer.tmpl',
    species_info           => 'help_species_info.tmpl',
};

sub handler {
    #
    # Make a jazz noise here...
    #
    my ( $self, $apr ) = @_;

    my $section  = $apr->param('section') || '';
    $section     = 'default' unless defined TEMPLATES->{ $section };
    my $template = TEMPLATES->{ $section };

    my $html;
    my $t = $self->template;
    $t->process(
        $template,
        {   apr                 => $self->apr,
            page                => $self->page,
            stylesheet          => $self->stylesheet,
            web_image_cache_dir => $self->web_image_cache_dir(),
            web_cmap_htdocs_dir => $self->web_cmap_htdocs_dir(),
        },
        \$html
        )
        or $html = $t->error;

    print $apr->header( -type => 'text/html', -cookie => $self->cookie ), $html;
    return 1;
}

1;

# ----------------------------------------------------
# A burnt child loves the fire.
# Oscar Wilde
# ----------------------------------------------------

=head1 NAME

Bio::GMOD::CMap::Apache::HelpViewer - show help

=head1 SYNOPSIS

In httpd.conf:

  <Location /cmap/help>
      SetHandler  perl-script
      PerlHandler Bio::GMOD::CMap::Apache::HelpViewer->super
  </Location>

=head1 DESCRIPTION

Displays the user help document for the maps. It's actually a minimal handler
that does little more than display an static HTML page. The reason the user
help isn't just static HTML is because it was deemed necessary to include the
help in other pages generated by Template Toolkit; therefore, the HTML was
moved into a template file in the "templates" directory so that Template
Toolkit could find and use it easily.

=head1 SEE ALSO

L<perl>.

=head1 AUTHOR

Ken Y. Clark E<lt>kclark@cshl.orgE<gt>.

=head1 COPYRIGHT

Copyright (c) 2002-4 Cold Spring Harbor Laboratory

This library is free software;  you can redistribute it and/or modify 
it under the same terms as Perl itself.

=cut
