#!perl

use strict;
use Test::More tests => 5;

use_ok( 'GDPDM::Utils', qw( table_name_to_class ) );

can_ok( __PACKAGE__, 'table_name_to_class' );

my %tests = (
    'div_passport'        => 'GDPDM::CDBI::DivPassport',
    'cdv_curated_allele'  => 'GDPDM::CDBI::CdvCuratedAllele',
);

while ( my ( $table_name, $expected_class ) = each %tests ) {
    my $class = table_name_to_class( $table_name );
    is( $class, $expected_class, "$table_name => $expected_class" );
}

eval { table_name_to_class() };
like( $@, qr/^No table name/, 'table_name_to_class() dies with no arg' );
