#!perl

use strict;
use FindBin '$Bin';
use File::Spec::Functions;
use GDPDM::Config qw( get_config );
use Test::More;
use Test::Exception;

use lib "$Bin/lib";
use TestDB qw( truncate_all_tables );

my $config       = get_config();
my $test_db_name = 'test_database';
my $test_config  = $config->{ $test_db_name };

if ( !$test_config ) {
    plan skip_all => "No '$test_db_name' config defined", 9;
}
else {
    plan tests => 9;
}

use_ok( 'GDPDM::Import' );

eval { GDPDM::Import->import_data() };

like( $@, qr/No input file/, 'Import dies with no data file' );

my $db = GDPDM::CDBI->db_Main( $test_db_name );

truncate_all_tables( $db );

my $bad_file = catfile( $Bin, 'data', 'gdpdm-test-bad.sxp' );

ok( -e $bad_file, "Bad file $bad_file exists" );

throws_ok
    { GDPDM::Import->import_data( $bad_file ) }
    qr/Error/, 
    'Bad file import throws errors' 
;

my $import_file = catfile( $Bin, 'data', 'gdpdm-test.sxp' );

ok( -e $import_file, "$import_file exists" );

ok( GDPDM::Import->import_data( $import_file ), 'Import throws no errors' );

my @all_tax = GDPDM::CDBI::DivTaxonomy->retrieve_all;

is( scalar @all_tax, 3, 'Found 3 taxonomies' );

my @passport = GDPDM::CDBI::DivPassport->search( accename => 'Agostano' );

is( scalar @passport, 1, 'Found 1 accession named "Agostano"' );

my $p1 = shift @passport;

is( $p1->{'accenumb'}, 'RA5360', 'Acce. Number is "RA5360"' );
