#!perl

use strict;
use Config;
use Data::Stag;
use File::Path;
use File::Spec::Functions;
use File::Temp qw( tempdir );
use FindBin qw( $Bin );
use Test::More tests => 10;

my $excel2sexp = catfile( $Bin, '..', 'scripts', 'excel2sexp' );

ok( -e $excel2sexp, 'excel2sexp script exists' );

my $excel_file = catfile( $Bin, 'data', 'Div_passport.xls' );

ok( -e $excel_file, 'Excel file exists' );

my $perl = $Config{'perlpath'};

ok( $perl, "Perl = '$perl'" );

my $tempdir = tempdir();

ok( $tempdir, "Tempdir = '$tempdir'" );

ok( chdir( $tempdir ), 'chdir' );

my $res = `$perl $excel2sexp $Bin/data/Div_passport.xls`;

like( $res, qr/Done/, 'Run OK' );

my $output = catfile( $tempdir, 'div_passport.sxp' );

ok( -e $output, "$output file exists" );

ok( -s $output, '... and is non-zero' );

my $stag;
eval { $stag = Data::Stag->parse( $output ) };

ok( $stag && !$@, 
    'No errors parsing resulting S-expression file with Data::Stag' );

ok( rmtree( $tempdir ), "Removed $tempdir" );
