#!perl

use strict;
use File::Spec::Functions;
use FindBin '$Bin';
use Test::More;
use GDPDM::Config qw( get_config );

my $config      = get_config();
my $test_config = $config->{'test_database'};

if ( !$test_config ) {
    plan skip_all => "No 'test_database' config defined", 10;
}
else {
    plan tests => 11;
}

use_ok( 'GDPDM::CDBI' );

SKIP: {
    my $db = GDPDM::CDBI->db_Main('test_database');

    ok( $db, 'Set db_Main to test' );

    isa_ok( $db, 'DBIx::ContextualFetch::db' );

    my @sql = (
    q[
        INSERT INTO div_taxonomy (div_taxonomy_id, genus, species, subspecies)
        VALUES (1, 'Oryza', 'sativa', 'japonica')
    ],
    q[
        INSERT INTO div_passport (div_passport_id, div_taxonomy_id, accename, accenumb) 
        VALUES (1,1,'Koshihikari','RA5337')
    ],
    q[
        INSERT INTO div_passport (div_passport_id, div_taxonomy_id, accename, accenumb) 
        VALUES (2,1,'Champa Tong 54','RA4936')
    ],
    q[
        INSERT INTO div_passport (div_passport_id, div_taxonomy_id, accename, accenumb) 
        VALUES (3,1,'Il Is Air','RA5025')
    ],
    );

    for my $table ( GDPDM::CDBI->represented_tables ) {
        $db->do("truncate $table");
    }

    for my $sql ( @sql ) {
        $db->do( $sql );
    }

    my @all_tax = GDPDM::CDBI::DivTaxonomy->retrieve_all;

    cmp_ok( scalar @all_tax, '==', 1, '1 taxonomy records total' );

    my $tax = GDPDM::CDBI::DivTaxonomy->retrieve( 1 );

    isa_ok( $tax, 'GDPDM::CDBI::DivTaxonomy' );

    isa_ok( $tax, 'Class::DBI' );

    cmp_ok( $tax, 'eq', 'Oryza sativa japonica', 'Stringifies OK' );

    cmp_ok( $tax->genus, 'eq', 'Oryza', 'Genus OK' );

    cmp_ok( $tax->species, 'eq', 'sativa', 'Species OK' );

    cmp_ok( $tax->subspecies, 'eq', 'japonica', 'Subspecies OK' );

    my @passport = $tax->div_passport;

    cmp_ok( scalar @passport, '==', 3, "$tax has 3 passports" );
};
