#!perl

use strict;
use FindBin qw( $Bin );
use Test::More tests => 11;

use_ok( 'GDPDM::Config', 'get_config' );

can_ok( __PACKAGE__, 'get_config' );

my $config = get_config();

isa_ok( $config, 'HASH' );

eval { my $bad = get_config("$Bin/data/bad-file.conf") };
like( $@, qr/does not exist/, 'Dies on bad file' ) ;

my %config = get_config("$Bin/data/test.conf");

ok( %config, 'Read an alternate file, returned as hash' );

ok( defined $config{'database'}, 'Database section present' );

cmp_ok( $config{'database'}{'dsn'}, 'eq', 'dbi:mysql:test', 'DB DSN OK' );

cmp_ok( $config{'database'}{'user'}, 'eq', 'guest', 'DB user OK' );

cmp_ok( $config{'database'}{'password'}, 'eq', '', 'DB password missing' );

ok( defined $config{'log'}, 'Log section present' );

cmp_ok( $config{'log'}{'file'}, 'eq', '/tmp/gdpdm.log', 'Log file OK' );
