#!/usr/local/bin/perl

# $Id: gdpdm-mk-xls-template.pl,v 1.2 2006/01/25 15:50:31 kycl4rk Exp $

=head1 NAME

gdpdm-mk-xls-template.pl - generate an Excel template for a GPDMD schema

=head1 SYNOPSIS

  gdpdm-mk-xls-template.pl [options] [excel-template.xml]

Options:

  -o|--outfile  Where to write the generated Excel template

  -h|--help     Show brief help and exit
  -v|--version  Show version and exit

=head1 DESCRIPTION

This script will create an Excel spreadsheet with a worksheet for each
table and columns for each table's fields.  First you must use
SQL::Translator with "templates/excel.tmpl" to generate an XML file
that the module Excel::Template can use.

  $ sqlt -f MySQL -t TTSchema --template templates/excel.tmpl \
    gdpdm.sql > templates/excel.xml
  $ gdpdm-mk-xls-template.pl

If provided no "outfile" argument, the script will write the file
"gdpdm.xls".  If provided to input argument, it will assume
"../templates/excel.xml".

=head1 SEE ALSO

SQL::Translator, Excel::Template.

=head1 AUTHOR

Ken Youens-Clark E<lt>kclark@cshl.eduE<gt>.

=head1 COPYRIGHT

Copyright (c) 2006 Cold Spring Harbor Laboratory

This library is free software;  you can redistribute it and/or modify 
it under the same terms as Perl itself.

=cut

# ----------------------------------------------------

use strict;
use Excel::Template;
use Getopt::Long;
use File::Basename;
use Pod::Usage;

use vars qw[ $VERSION ];
$VERSION = sprintf "%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/;

my ( $help, $show_version, $outfile );
GetOptions(
    'h|help'    => \$help,
    'v|version' => \$show_version,
    'o|outfile' => \$outfile,
);
pod2usage(2) if $help;

my $xml = shift || '../templates/excel.xml';

if ( $show_version ) {
    my $prog = basename( $0 );
    print "$prog v$VERSION\n";
    exit(0);
}

$outfile ||= 'gdpdm.xls';

my $template = Excel::Template->new( filename => $xml );

$template->write_file( $outfile );
