-- MySQL dump 10.8
--
-- Host: localhost    Database: diversity_rice21
-- ------------------------------------------------------
-- Server version	4.1.7-standard-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE="NO_AUTO_VALUE_ON_ZERO" */;

--
-- Table structure for table `qtl_analysis_method`
--

DROP TABLE IF EXISTS `qtl_analysis_method`;
CREATE TABLE `qtl_analysis_method` (
  `qtl_analysis_method_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_study_id` int(10) unsigned NOT NULL default '0',
  `threshold_method` varchar(255) default NULL,
  `permutation_number` int(10) unsigned default NULL,
  `statistical_model` varchar(255) default NULL,
  `positive_parent_stock_id` int(10) unsigned default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_analysis_method_id`),
  KEY `qtl_study_id` (`qtl_study_id`),
  KEY `positive_parent_stock_id` (`positive_parent_stock_id`),
  CONSTRAINT `qtl_analysis_method_ibfk_1` FOREIGN KEY (`qtl_study_id`) REFERENCES `qtl_study` (`qtl_study_id`),
  CONSTRAINT `qtl_analysis_method_ibfk_2` FOREIGN KEY (`positive_parent_stock_id`) REFERENCES `div_stock_parent` (`div_stock_parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_analysis_result`
--

DROP TABLE IF EXISTS `qtl_analysis_result`;
CREATE TABLE `qtl_analysis_result` (
  `qtl_analysis_result_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `qtl_analysis_method_id` int(10) unsigned NOT NULL default '0',
  `div_trait_uom_id` int(10) unsigned NOT NULL default '0',
  `r_square` double(11,5) default NULL,
  `genetic_var` double(11,5) default NULL,
  `gxe_var` double(11,5) default NULL,
  `environment_var` double(11,5) default NULL,
  PRIMARY KEY  (`qtl_analysis_result_id`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  KEY `qtl_analysis_method_id` (`qtl_analysis_method_id`),
  KEY `div_trait_uom_id` (`div_trait_uom_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_1` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_2` FOREIGN KEY (`qtl_analysis_method_id`) REFERENCES `qtl_analysis_method` (`qtl_analysis_method_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_3` FOREIGN KEY (`div_trait_uom_id`) REFERENCES `div_trait_uom` (`div_trait_uom_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_marker`
--

DROP TABLE IF EXISTS `qtl_marker`;
CREATE TABLE `qtl_marker` (
  `qtl_marker_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_qtl_id` int(10) unsigned NOT NULL default '0',
  `cdv_marker_id` int(10) unsigned NOT NULL default '0',
  `genetic_relationship` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_marker_id`),
  KEY `qtl_qtl_id` (`qtl_qtl_id`),
  KEY `cdv_marker_id` (`cdv_marker_id`),
  CONSTRAINT `qtl_marker_ibfk_1` FOREIGN KEY (`qtl_qtl_id`) REFERENCES `qtl_qtl` (`qtl_qtl_id`),
  CONSTRAINT `qtl_marker_ibfk_2` FOREIGN KEY (`cdv_marker_id`) REFERENCES `cdv_marker` (`cdv_marker_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_obs_unit`
--

DROP TABLE IF EXISTS `qtl_obs_unit`;
CREATE TABLE `qtl_obs_unit` (
  `qtl_obs_unit_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_study_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `comments` text,
  PRIMARY KEY  (`qtl_obs_unit_id`),
  UNIQUE KEY `name` (`name`),
  KEY `qtl_study_id` (`qtl_study_id`),
  CONSTRAINT `qtl_obs_unit_ibfk_1` FOREIGN KEY (`qtl_study_id`) REFERENCES `qtl_study` (`qtl_study_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_obs_unit_set`
--

DROP TABLE IF EXISTS `qtl_obs_unit_set`;
CREATE TABLE `qtl_obs_unit_set` (
  `qtl_obs_unit_set_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `comments` text,
  PRIMARY KEY  (`qtl_obs_unit_set_id`),
  UNIQUE KEY `name` (`name`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_obs_unit_set_ibfk_1` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_qtl`
--

DROP TABLE IF EXISTS `qtl_qtl`;
CREATE TABLE `qtl_qtl` (
  `qtl_qtl_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_analysis_result_id` int(10) unsigned NOT NULL default '0',
  `qtl_accession_id` varchar(255) NOT NULL default '',
  `published_symbol` varchar(255) default NULL,
  `linkage_group` varchar(255) default NULL,
  `start_position` double(11,2) default NULL,
  `peak_position` double(11,2) default NULL,
  `stop_position` double(11,2) default NULL,
  `additive` double(11,5) default NULL,
  `dominance` double(11,5) default NULL,
  `lod` double(11,5) default NULL,
  `f_value` double(11,5) default NULL,
  `t_value` double(11,5) default NULL,
  `p_value` double(11,5) default NULL,
  `r_square` double(11,5) default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_qtl_id`),
  UNIQUE KEY `qtl_accession_id` (`qtl_accession_id`),
  KEY `qtl_analysis_result_id` (`qtl_analysis_result_id`),
  CONSTRAINT `qtl_qtl_ibfk_1` FOREIGN KEY (`qtl_analysis_result_id`) REFERENCES `qtl_analysis_result` (`qtl_analysis_result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_study`
--

DROP TABLE IF EXISTS `qtl_study`;
CREATE TABLE `qtl_study` (
  `qtl_study_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(200) NOT NULL default '',
  `reference_id` int(10) unsigned default NULL,
  `div_experiment_id` int(10) unsigned default NULL,
  `cmap_map_set_acc` varchar(200) default NULL,
  PRIMARY KEY  (`qtl_study_id`),
  KEY `div_experiment_id` (`div_experiment_id`),
  CONSTRAINT `qtl_study_ibfk_1` FOREIGN KEY (`div_experiment_id`) REFERENCES `div_experiment` (`div_experiment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_trait`
--

DROP TABLE IF EXISTS `qtl_trait`;
CREATE TABLE `qtl_trait` (
  `qtl_trait_id` int(10) unsigned NOT NULL auto_increment,
  `div_trait_uom_id` int(10) unsigned NOT NULL default '0',
  `div_statistic_type_id` int(10) unsigned NOT NULL default '0',
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `date_measured` date default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`qtl_trait_id`),
  KEY `div_trait_uom_id` (`div_trait_uom_id`),
  KEY `div_statistic_type_id` (`div_statistic_type_id`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_trait_ibfk_1` FOREIGN KEY (`div_trait_uom_id`) REFERENCES `div_trait_uom` (`div_trait_uom_id`),
  CONSTRAINT `qtl_trait_ibfk_2` FOREIGN KEY (`div_statistic_type_id`) REFERENCES `div_statistic_type` (`div_statistic_type_id`),
  CONSTRAINT `qtl_trait_ibfk_3` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
