-- MySQL dump 10.10
--
-- Host: localhost    Database: diversity_rice22
-- ------------------------------------------------------
-- Server version	5.0.22-standard-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `cdv_allele_curated_allele`
--

DROP TABLE IF EXISTS `cdv_allele_curated_allele`;
CREATE TABLE `cdv_allele_curated_allele` (
  `cdv_allele_curated_allele_id` int(10) unsigned NOT NULL auto_increment,
  `cdv_curated_allele_id` int(10) unsigned default NULL,
  `div_allele_id` int(10) unsigned default NULL,
  `cdv_curation_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`cdv_allele_curated_allele_id`),
  KEY `cdv_curated_allele_id` (`cdv_curated_allele_id`),
  KEY `cdv_curation_id` (`cdv_curation_id`),
  KEY `div_allele_id` (`div_allele_id`),
  CONSTRAINT `cdv_allele_curated_allele_ibfk_1` FOREIGN KEY (`cdv_curated_allele_id`) REFERENCES `cdv_curated_allele` (`cdv_curated_allele_id`),
  CONSTRAINT `cdv_allele_curated_allele_ibfk_2` FOREIGN KEY (`cdv_curation_id`) REFERENCES `cdv_curation` (`cdv_curation_id`),
  CONSTRAINT `cdv_allele_curated_allele_ibfk_3` FOREIGN KEY (`div_allele_id`) REFERENCES `div_allele` (`div_allele_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_curated_allele`
--

DROP TABLE IF EXISTS `cdv_curated_allele`;
CREATE TABLE `cdv_curated_allele` (
  `cdv_curated_allele_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  PRIMARY KEY  (`cdv_curated_allele_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_curation`
--

DROP TABLE IF EXISTS `cdv_curation`;
CREATE TABLE `cdv_curation` (
  `cdv_curation_id` int(10) unsigned NOT NULL auto_increment,
  `cdv_reason_id` int(10) unsigned default NULL,
  `curator` varchar(255) default NULL,
  `curation_date` datetime default NULL,
  `comments` text,
  PRIMARY KEY  (`cdv_curation_id`),
  KEY `cdv_reason_id` (`cdv_reason_id`),
  CONSTRAINT `cdv_curation_ibfk_1` FOREIGN KEY (`cdv_reason_id`) REFERENCES `cdv_reason` (`cdv_reason_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_map_feature`
--

DROP TABLE IF EXISTS `cdv_map_feature`;
CREATE TABLE `cdv_map_feature` (
  `cdv_map_feature_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `chromosome_name` text,
  `genetic_bin` varchar(255) default NULL,
  `xref_map_id` varchar(255) default NULL,
  `genetic_map` varchar(255) default NULL,
  `genetic_position` double default NULL,
  `locus_type` varchar(255) default NULL,
  `physical_position` double default NULL,
  `comments` text,
  PRIMARY KEY  (`cdv_map_feature_id`),
  KEY `xref_map_id` (`xref_map_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_map_feature_annotation`
--

DROP TABLE IF EXISTS `cdv_map_feature_annotation`;
CREATE TABLE `cdv_map_feature_annotation` (
  `cdv_map_feature_annotation_id` int(10) unsigned NOT NULL auto_increment,
  `cdv_map_feature_id` int(10) unsigned NOT NULL default '0',
  `cdv_map_feature_annotation_type_id` int(10) unsigned NOT NULL default '0',
  `annotation_value` text NOT NULL,
  PRIMARY KEY  (`cdv_map_feature_annotation_id`),
  KEY `cdv_map_feature_id` (`cdv_map_feature_id`),
  KEY `cdv_map_feature_annotation_type_id` (`cdv_map_feature_annotation_type_id`),
  CONSTRAINT `cdv_map_feature_annotation_ibfk_1` FOREIGN KEY (`cdv_map_feature_id`) REFERENCES `cdv_map_feature` (`cdv_map_feature_id`),
  CONSTRAINT `cdv_map_feature_annotation_ibfk_2` FOREIGN KEY (`cdv_map_feature_annotation_type_id`) REFERENCES `cdv_map_feature_annotation_type` (`cdv_map_feature_annotation_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_map_feature_annotation_type`
--

DROP TABLE IF EXISTS `cdv_map_feature_annotation_type`;
CREATE TABLE `cdv_map_feature_annotation_type` (
  `cdv_map_feature_annotation_type_id` int(10) unsigned NOT NULL auto_increment,
  `anno_type` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`cdv_map_feature_annotation_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_marker`
--

DROP TABLE IF EXISTS `cdv_marker`;
CREATE TABLE `cdv_marker` (
  `cdv_marker_id` int(10) unsigned NOT NULL auto_increment,
  `cdv_map_feature_id` int(10) unsigned default NULL,
  `div_ref_stock_id` int(10) unsigned default NULL,
  `name` varchar(255) default NULL,
  `position` int(11) default NULL,
  `length` int(11) default NULL,
  `ref_seq` text,
  `marker_aid` varchar(255) default NULL,
  PRIMARY KEY  (`cdv_marker_id`),
  KEY `cdv_map_feature_id` (`cdv_map_feature_id`),
  KEY `marker_aid` (`marker_aid`),
  KEY `cdv_marker_ibfk_2` (`div_ref_stock_id`),
  CONSTRAINT `cdv_marker_ibfk_1` FOREIGN KEY (`cdv_map_feature_id`) REFERENCES `cdv_map_feature` (`cdv_map_feature_id`),
  CONSTRAINT `cdv_marker_ibfk_2` FOREIGN KEY (`div_ref_stock_id`) REFERENCES `div_stock` (`div_stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_marker_annotation`
--

DROP TABLE IF EXISTS `cdv_marker_annotation`;
CREATE TABLE `cdv_marker_annotation` (
  `cdv_marker_annotation_id` int(10) unsigned NOT NULL auto_increment,
  `cdv_marker_id` int(10) unsigned NOT NULL default '0',
  `cdv_marker_annotation_type_id` int(10) unsigned NOT NULL default '0',
  `annotation_value` text NOT NULL,
  PRIMARY KEY  (`cdv_marker_annotation_id`),
  KEY `cdv_marker_id` (`cdv_marker_id`),
  KEY `cdv_marker_annotation_type_id` (`cdv_marker_annotation_type_id`),
  CONSTRAINT `cdv_marker_annotation_ibfk_1` FOREIGN KEY (`cdv_marker_id`) REFERENCES `cdv_marker` (`cdv_marker_id`),
  CONSTRAINT `cdv_marker_annotation_ibfk_2` FOREIGN KEY (`cdv_marker_annotation_type_id`) REFERENCES `cdv_marker_annotation_type` (`cdv_marker_annotation_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_marker_annotation_type`
--

DROP TABLE IF EXISTS `cdv_marker_annotation_type`;
CREATE TABLE `cdv_marker_annotation_type` (
  `cdv_marker_annotation_type_id` int(10) unsigned NOT NULL auto_increment,
  `anno_type` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`cdv_marker_annotation_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_passport_group`
--

DROP TABLE IF EXISTS `cdv_passport_group`;
CREATE TABLE `cdv_passport_group` (
  `cdv_passport_group_id` int(10) unsigned NOT NULL auto_increment,
  `group_name` varchar(255) default NULL,
  PRIMARY KEY  (`cdv_passport_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_passport_set`
--

DROP TABLE IF EXISTS `cdv_passport_set`;
CREATE TABLE `cdv_passport_set` (
  `cdv_passport_set_id` int(10) unsigned NOT NULL auto_increment,
  `div_passport_id` int(10) unsigned default NULL,
  `cdv_passport_group_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`cdv_passport_set_id`),
  KEY `div_passport_id` (`div_passport_id`),
  KEY `cdv_passport_group_id` (`cdv_passport_group_id`),
  CONSTRAINT `cdv_passport_set_ibfk_1` FOREIGN KEY (`div_passport_id`) REFERENCES `div_passport` (`div_passport_id`),
  CONSTRAINT `cdv_passport_set_ibfk_2` FOREIGN KEY (`cdv_passport_group_id`) REFERENCES `cdv_passport_group` (`cdv_passport_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_reason`
--

DROP TABLE IF EXISTS `cdv_reason`;
CREATE TABLE `cdv_reason` (
  `cdv_reason_id` int(10) unsigned NOT NULL auto_increment,
  `description` text,
  PRIMARY KEY  (`cdv_reason_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `cdv_source`
--

DROP TABLE IF EXISTS `cdv_source`;
CREATE TABLE `cdv_source` (
  `cdv_source_id` int(10) unsigned NOT NULL auto_increment,
  `source` varchar(255) NOT NULL default '',
  `contact` varchar(255) default NULL,
  `institute` varchar(255) default NULL,
  `department` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `state_province` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `phone` varchar(255) default NULL,
  `fax` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `url` varchar(255) default NULL,
  `comments` varchar(255) default NULL,
  PRIMARY KEY  (`cdv_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_aa_annotation`
--

DROP TABLE IF EXISTS `div_aa_annotation`;
CREATE TABLE `div_aa_annotation` (
  `div_aa_annotation_id` int(10) unsigned NOT NULL auto_increment,
  `div_annotation_type_id` int(10) unsigned default NULL,
  `div_allele_assay_id` int(10) unsigned default NULL,
  `annotation_value` text,
  PRIMARY KEY  (`div_aa_annotation_id`),
  KEY `div_annotation_type_id` (`div_annotation_type_id`),
  KEY `div_allele_assay_id` (`div_allele_assay_id`),
  CONSTRAINT `div_aa_annotation_ibfk_1` FOREIGN KEY (`div_annotation_type_id`) REFERENCES `div_annotation_type` (`div_annotation_type_id`),
  CONSTRAINT `div_aa_annotation_ibfk_2` FOREIGN KEY (`div_allele_assay_id`) REFERENCES `div_allele_assay` (`div_allele_assay_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_accession_collecting`
--

DROP TABLE IF EXISTS `div_accession_collecting`;
CREATE TABLE `div_accession_collecting` (
  `div_accession_collecting_id` int(10) unsigned NOT NULL auto_increment,
  `div_locality_id` int(10) unsigned default NULL,
  `collector` varchar(255) default NULL,
  `collnumb` varchar(255) default NULL,
  `collsrc` varchar(255) default NULL,
  `collcode` varchar(255) default NULL,
  `col_date` datetime default NULL,
  PRIMARY KEY  (`div_accession_collecting_id`),
  KEY `collcode` (`collcode`),
  KEY `div_locality_id` (`div_locality_id`),
  CONSTRAINT `div_accession_collecting_ibfk_1` FOREIGN KEY (`div_locality_id`) REFERENCES `div_locality` (`div_locality_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_allele`
--

DROP TABLE IF EXISTS `div_allele`;
CREATE TABLE `div_allele` (
  `div_allele_id` int(10) unsigned NOT NULL auto_increment,
  `div_obs_unit_sample_id` int(10) unsigned default NULL,
  `div_allele_assay_id` int(10) unsigned default NULL,
  `accession` varchar(255) default NULL,
  `referencedb` varchar(255) default NULL,
  `allele_num` int(11) default NULL,
  `quality` text,
  `value` text,
  `proportion` int(11) default NULL,
  `total_n` int(11) default NULL,
  PRIMARY KEY  (`div_allele_id`),
  KEY `div_obs_unit_sample_id` (`div_obs_unit_sample_id`),
  KEY `div_allele_assay_id` (`div_allele_assay_id`),
  KEY `allele_num` (`allele_num`),
  CONSTRAINT `div_allele_ibfk_2` FOREIGN KEY (`div_allele_assay_id`) REFERENCES `div_allele_assay` (`div_allele_assay_id`),
  CONSTRAINT `div_allele_ibfk_3` FOREIGN KEY (`div_obs_unit_sample_id`) REFERENCES `div_obs_unit_sample` (`div_obs_unit_sample_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_allele_assay`
--

DROP TABLE IF EXISTS `div_allele_assay`;
CREATE TABLE `div_allele_assay` (
  `div_allele_assay_id` int(10) unsigned NOT NULL auto_increment,
  `div_source_assay_id` int(10) unsigned default NULL,
  `div_poly_type_id` int(10) unsigned default NULL,
  `div_scoring_tech_type_id` int(10) unsigned default NULL,
  `div_ref_stock_id` int(10) unsigned default NULL,
  `cdv_marker_id` int(10) unsigned default NULL,
  `name` varchar(255) default NULL,
  `assay_date` datetime default NULL,
  `producer` varchar(255) default NULL,
  `position` varchar(255) default NULL,
  `ref_seq` text,
  `length` int(11) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_allele_assay_id`),
  KEY `div_source_assay_id` (`div_source_assay_id`),
  KEY `div_poly_type_id` (`div_poly_type_id`),
  KEY `cdv_marker_id` (`cdv_marker_id`),
  KEY `div_ref_stock_id` (`div_ref_stock_id`),
  KEY `assay_date` (`assay_date`),
  KEY `name` (`name`),
  KEY `div_scoring_tech_type_id` (`div_scoring_tech_type_id`),
  CONSTRAINT `div_aa_annotation_ibfk_3` FOREIGN KEY (`div_scoring_tech_type_id`) REFERENCES `div_scoring_tech_type` (`div_scoring_tech_type_id`),
  CONSTRAINT `div_allele_assay_ibfk_1` FOREIGN KEY (`div_source_assay_id`) REFERENCES `div_allele_assay` (`div_allele_assay_id`),
  CONSTRAINT `div_allele_assay_ibfk_2` FOREIGN KEY (`div_poly_type_id`) REFERENCES `div_poly_type` (`div_poly_type_id`),
  CONSTRAINT `div_allele_assay_ibfk_3` FOREIGN KEY (`cdv_marker_id`) REFERENCES `cdv_marker` (`cdv_marker_id`),
  CONSTRAINT `div_allele_assay_ibfk_4` FOREIGN KEY (`div_ref_stock_id`) REFERENCES `div_stock` (`div_stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_annotation_type`
--

DROP TABLE IF EXISTS `div_annotation_type`;
CREATE TABLE `div_annotation_type` (
  `div_annotation_type_id` int(10) unsigned NOT NULL auto_increment,
  `anno_type` varchar(255) default NULL,
  PRIMARY KEY  (`div_annotation_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_experiment`
--

DROP TABLE IF EXISTS `div_experiment`;
CREATE TABLE `div_experiment` (
  `div_experiment_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `design` varchar(255) default NULL,
  `originator` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_experiment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_generation`
--

DROP TABLE IF EXISTS `div_generation`;
CREATE TABLE `div_generation` (
  `div_generation_id` int(10) unsigned NOT NULL auto_increment,
  `value` varchar(255) default NULL,
  `icis_id` text,
  `comments` text,
  `selfing_number` int(11) default NULL,
  `sibbing_number` int(11) default NULL,
  PRIMARY KEY  (`div_generation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_locality`
--

DROP TABLE IF EXISTS `div_locality`;
CREATE TABLE `div_locality` (
  `div_locality_id` int(10) unsigned NOT NULL auto_increment,
  `elevation` int(11) default NULL,
  `city` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `origcty` varchar(255) default NULL,
  `latitude` double default NULL,
  `longitude` double default NULL,
  `locality_name` varchar(255) default NULL,
  `state_province` varchar(255) default NULL,
  PRIMARY KEY  (`div_locality_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_obs_unit`
--

DROP TABLE IF EXISTS `div_obs_unit`;
CREATE TABLE `div_obs_unit` (
  `div_obs_unit_id` int(10) unsigned NOT NULL auto_increment,
  `div_experiment_id` int(10) unsigned default NULL,
  `div_stock_id` int(10) unsigned default NULL,
  `div_locality_id` int(10) unsigned default NULL,
  `name` varchar(255) default NULL,
  `coord_x` int(11) default NULL,
  `coord_y` int(11) default NULL,
  `rep` varchar(255) default NULL,
  `block` varchar(255) default NULL,
  `plot` varchar(255) default NULL,
  `season` varchar(255) default NULL,
  `plant` varchar(255) default NULL,
  `planting_date` datetime default NULL,
  `harvest_date` datetime default NULL,
  `comments` text,
  PRIMARY KEY  (`div_obs_unit_id`),
  KEY `div_experiment_id` (`div_experiment_id`),
  KEY `div_stock_id` (`div_stock_id`),
  KEY `div_locality_id` (`div_locality_id`),
  CONSTRAINT `div_obs_unit_ibfk_1` FOREIGN KEY (`div_experiment_id`) REFERENCES `div_experiment` (`div_experiment_id`),
  CONSTRAINT `div_obs_unit_ibfk_2` FOREIGN KEY (`div_stock_id`) REFERENCES `div_stock` (`div_stock_id`),
  CONSTRAINT `div_obs_unit_ibfk_3` FOREIGN KEY (`div_locality_id`) REFERENCES `div_locality` (`div_locality_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_obs_unit_sample`
--

DROP TABLE IF EXISTS `div_obs_unit_sample`;
CREATE TABLE `div_obs_unit_sample` (
  `div_obs_unit_sample_id` int(10) unsigned NOT NULL auto_increment,
  `div_obs_unit_id` int(10) unsigned default NULL,
  `name` varchar(255) default NULL,
  `sample_date` datetime default NULL,
  `producer` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_obs_unit_sample_id`),
  KEY `div_obs_unit_id` (`div_obs_unit_id`),
  CONSTRAINT `div_obs_unit_sample_ibfk_1` FOREIGN KEY (`div_obs_unit_id`) REFERENCES `div_obs_unit` (`div_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_passport`
--

DROP TABLE IF EXISTS `div_passport`;
CREATE TABLE `div_passport` (
  `div_passport_id` int(10) unsigned NOT NULL auto_increment,
  `div_taxonomy_id` int(10) unsigned default NULL,
  `div_accession_collecting_id` int(10) unsigned default NULL,
  `cdv_source_id` int(10) unsigned default NULL,
  `accename` varchar(255) NOT NULL default '',
  `germplasm_type` varchar(255) default NULL,
  `source` varchar(255) NOT NULL default '',
  `accenumb` varchar(255) default NULL,
  `sampstat` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_passport_id`),
  UNIQUE KEY `accename` (`accename`),
  KEY `div_taxonomy_id` (`div_taxonomy_id`),
  KEY `div_accession_collecting_id` (`div_accession_collecting_id`),
  KEY `cdv_source_id` (`cdv_source_id`),
  CONSTRAINT `div_passport_ibfk_1` FOREIGN KEY (`div_taxonomy_id`) REFERENCES `div_taxonomy` (`div_taxonomy_id`),
  CONSTRAINT `div_passport_ibfk_2` FOREIGN KEY (`div_accession_collecting_id`) REFERENCES `div_accession_collecting` (`div_accession_collecting_id`),
  CONSTRAINT `div_passport_ibfk_3` FOREIGN KEY (`cdv_source_id`) REFERENCES `cdv_source` (`cdv_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_poly_type`
--

DROP TABLE IF EXISTS `div_poly_type`;
CREATE TABLE `div_poly_type` (
  `div_poly_type_id` int(10) unsigned NOT NULL auto_increment,
  `poly_type` varchar(255) default NULL,
  PRIMARY KEY  (`div_poly_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_scoring_tech_type`
--

DROP TABLE IF EXISTS `div_scoring_tech_type`;
CREATE TABLE `div_scoring_tech_type` (
  `div_scoring_tech_type_id` int(10) unsigned NOT NULL auto_increment,
  `scoring_tech_group` varchar(255) default NULL,
  `scoring_tech_type` varchar(255) default NULL,
  PRIMARY KEY  (`div_scoring_tech_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_statistic_type`
--

DROP TABLE IF EXISTS `div_statistic_type`;
CREATE TABLE `div_statistic_type` (
  `div_statistic_type_id` int(10) unsigned NOT NULL auto_increment,
  `stat_type` varchar(255) default NULL,
  PRIMARY KEY  (`div_statistic_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_stock`
--

DROP TABLE IF EXISTS `div_stock`;
CREATE TABLE `div_stock` (
  `div_stock_id` int(10) unsigned NOT NULL auto_increment,
  `div_generation_id` int(10) unsigned default NULL,
  `div_passport_id` int(10) unsigned default NULL,
  `seed_lot` varchar(255) default NULL,
  `stock_source` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_stock_id`),
  KEY `div_generation_id` (`div_generation_id`),
  KEY `div_passport_id` (`div_passport_id`),
  CONSTRAINT `div_stock_ibfk_1` FOREIGN KEY (`div_generation_id`) REFERENCES `div_generation` (`div_generation_id`),
  CONSTRAINT `div_stock_ibfk_2` FOREIGN KEY (`div_passport_id`) REFERENCES `div_passport` (`div_passport_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_stock_parent`
--

DROP TABLE IF EXISTS `div_stock_parent`;
CREATE TABLE `div_stock_parent` (
  `div_stock_parent_id` int(10) unsigned NOT NULL auto_increment,
  `div_stock_id` int(10) unsigned default NULL,
  `div_parent_id` int(10) unsigned default NULL,
  `role` varchar(255) default NULL,
  `recurrent` tinyint(4) default NULL,
  PRIMARY KEY  (`div_stock_parent_id`),
  KEY `div_stock_id` (`div_stock_id`),
  KEY `div_parent_id` (`div_parent_id`),
  CONSTRAINT `div_stock_parent_ibfk_1` FOREIGN KEY (`div_stock_id`) REFERENCES `div_stock` (`div_stock_id`),
  CONSTRAINT `div_stock_parent_ibfk_2` FOREIGN KEY (`div_parent_id`) REFERENCES `div_stock` (`div_stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_synonym`
--

DROP TABLE IF EXISTS `div_synonym`;
CREATE TABLE `div_synonym` (
  `div_synonym_id` int(10) unsigned NOT NULL auto_increment,
  `div_passport_id` int(10) unsigned default NULL,
  `synonym` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`div_synonym_id`),
  KEY `div_passport_id` (`div_passport_id`),
  CONSTRAINT `div_synonym_ibfk_1` FOREIGN KEY (`div_passport_id`) REFERENCES `div_passport` (`div_passport_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_taxonomy`
--

DROP TABLE IF EXISTS `div_taxonomy`;
CREATE TABLE `div_taxonomy` (
  `div_taxonomy_id` int(10) unsigned NOT NULL auto_increment,
  `genus` varchar(255) default NULL,
  `species` varchar(255) default NULL,
  `subspecies` varchar(255) default NULL,
  `subtaxa` varchar(255) default NULL,
  `race` varchar(255) default NULL,
  `population` varchar(255) default NULL,
  `common_name` varchar(255) default NULL,
  `term_accession` varchar(255) default NULL,
  PRIMARY KEY  (`div_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_trait`
--

DROP TABLE IF EXISTS `div_trait`;
CREATE TABLE `div_trait` (
  `div_trait_id` int(10) unsigned NOT NULL auto_increment,
  `div_trait_uom_id` int(10) unsigned default NULL,
  `div_statistic_type_id` int(10) unsigned default NULL,
  `div_obs_unit_id` int(10) unsigned default NULL,
  `value` varchar(255) default NULL,
  `date_measured` datetime default NULL,
  PRIMARY KEY  (`div_trait_id`),
  KEY `div_trait_uom_id` (`div_trait_uom_id`),
  KEY `div_statistic_type_id` (`div_statistic_type_id`),
  KEY `div_obs_unit_id` (`div_obs_unit_id`),
  CONSTRAINT `div_trait_ibfk_1` FOREIGN KEY (`div_trait_uom_id`) REFERENCES `div_trait_uom` (`div_trait_uom_id`),
  CONSTRAINT `div_trait_ibfk_2` FOREIGN KEY (`div_statistic_type_id`) REFERENCES `div_statistic_type` (`div_statistic_type_id`),
  CONSTRAINT `div_trait_ibfk_3` FOREIGN KEY (`div_obs_unit_id`) REFERENCES `div_obs_unit` (`div_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_trait_uom`
--

DROP TABLE IF EXISTS `div_trait_uom`;
CREATE TABLE `div_trait_uom` (
  `div_trait_uom_id` int(10) unsigned NOT NULL auto_increment,
  `div_unit_of_measure_id` int(10) unsigned default NULL,
  `local_trait_name` varchar(255) default NULL,
  `trait_protocol` text,
  `to_accession` varchar(255) default NULL,
  `eo_accession` varchar(255) default NULL,
  PRIMARY KEY  (`div_trait_uom_id`),
  KEY `div_unit_of_measure_id` (`div_unit_of_measure_id`),
  KEY `to_accession` (`to_accession`),
  KEY `eo_accession` (`eo_accession`),
  CONSTRAINT `div_trait_uom_ibfk_1` FOREIGN KEY (`div_unit_of_measure_id`) REFERENCES `div_unit_of_measure` (`div_unit_of_measure_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_treatment`
--

DROP TABLE IF EXISTS `div_treatment`;
CREATE TABLE `div_treatment` (
  `div_treatment_id` int(10) unsigned NOT NULL auto_increment,
  `div_treatment_uom_id` int(10) unsigned default NULL,
  `div_obs_unit_id` int(10) unsigned default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`div_treatment_id`),
  KEY `div_treatment_uom_id` (`div_treatment_uom_id`),
  KEY `div_obs_unit_id` (`div_obs_unit_id`),
  CONSTRAINT `div_treatment_ibfk_1` FOREIGN KEY (`div_treatment_uom_id`) REFERENCES `div_treatment_uom` (`div_treatment_uom_id`),
  CONSTRAINT `div_treatment_ibfk_2` FOREIGN KEY (`div_obs_unit_id`) REFERENCES `div_obs_unit` (`div_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_treatment_uom`
--

DROP TABLE IF EXISTS `div_treatment_uom`;
CREATE TABLE `div_treatment_uom` (
  `div_treatment_uom_id` int(10) unsigned NOT NULL auto_increment,
  `div_unit_of_measure_id` int(10) unsigned default NULL,
  `local_treatment_name` varchar(255) default NULL,
  `treatment_protocol` varchar(255) default NULL,
  `eo_accession` varchar(255) default NULL,
  PRIMARY KEY  (`div_treatment_uom_id`),
  KEY `eo_accession` (`eo_accession`),
  KEY `div_unit_of_measure_id` (`div_unit_of_measure_id`),
  CONSTRAINT `div_treatment_uom_ibfk_1` FOREIGN KEY (`div_unit_of_measure_id`) REFERENCES `div_unit_of_measure` (`div_unit_of_measure_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `div_unit_of_measure`
--

DROP TABLE IF EXISTS `div_unit_of_measure`;
CREATE TABLE `div_unit_of_measure` (
  `div_unit_of_measure_id` int(10) unsigned NOT NULL auto_increment,
  `unit_type` varchar(255) default NULL,
  PRIMARY KEY  (`div_unit_of_measure_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_analysis_method`
--

DROP TABLE IF EXISTS `qtl_analysis_method`;
CREATE TABLE `qtl_analysis_method` (
  `qtl_analysis_method_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_study_id` int(10) unsigned NOT NULL default '0',
  `threshold_method` varchar(255) default NULL,
  `permutation_number` int(10) unsigned default NULL,
  `statistical_model` varchar(255) default NULL,
  `positive_parent_stock_id` int(10) unsigned default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_analysis_method_id`),
  KEY `qtl_study_id` (`qtl_study_id`),
  KEY `positive_parent_stock_id` (`positive_parent_stock_id`),
  CONSTRAINT `qtl_analysis_method_ibfk_1` FOREIGN KEY (`qtl_study_id`) REFERENCES `qtl_study` (`qtl_study_id`),
  CONSTRAINT `qtl_analysis_method_ibfk_2` FOREIGN KEY (`positive_parent_stock_id`) REFERENCES `div_stock_parent` (`div_stock_parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_analysis_result`
--

DROP TABLE IF EXISTS `qtl_analysis_result`;
CREATE TABLE `qtl_analysis_result` (
  `qtl_analysis_result_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `qtl_analysis_method_id` int(10) unsigned NOT NULL default '0',
  `div_trait_uom_id` int(10) unsigned NOT NULL default '0',
  `r_square` double(11,5) default NULL,
  `genetic_var` double(11,5) default NULL,
  `gxe_var` double(11,5) default NULL,
  `environment_var` double(11,5) default NULL,
  PRIMARY KEY  (`qtl_analysis_result_id`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  KEY `qtl_analysis_method_id` (`qtl_analysis_method_id`),
  KEY `div_trait_uom_id` (`div_trait_uom_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_1` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_2` FOREIGN KEY (`qtl_analysis_method_id`) REFERENCES `qtl_analysis_method` (`qtl_analysis_method_id`),
  CONSTRAINT `qtl_analysis_result_ibfk_3` FOREIGN KEY (`div_trait_uom_id`) REFERENCES `div_trait_uom` (`div_trait_uom_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_marker`
--

DROP TABLE IF EXISTS `qtl_marker`;
CREATE TABLE `qtl_marker` (
  `qtl_marker_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_qtl_id` int(10) unsigned NOT NULL default '0',
  `cdv_marker_id` int(10) unsigned NOT NULL default '0',
  `genetic_relationship` varchar(255) default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_marker_id`),
  KEY `qtl_qtl_id` (`qtl_qtl_id`),
  KEY `cdv_marker_id` (`cdv_marker_id`),
  CONSTRAINT `qtl_marker_ibfk_1` FOREIGN KEY (`qtl_qtl_id`) REFERENCES `qtl_qtl` (`qtl_qtl_id`),
  CONSTRAINT `qtl_marker_ibfk_2` FOREIGN KEY (`cdv_marker_id`) REFERENCES `cdv_marker` (`cdv_marker_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_obs_unit`
--

DROP TABLE IF EXISTS `qtl_obs_unit`;
CREATE TABLE `qtl_obs_unit` (
  `qtl_obs_unit_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_study_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `comments` text,
  PRIMARY KEY  (`qtl_obs_unit_id`),
  UNIQUE KEY `name` (`name`),
  KEY `qtl_study_id` (`qtl_study_id`),
  CONSTRAINT `qtl_obs_unit_ibfk_1` FOREIGN KEY (`qtl_study_id`) REFERENCES `qtl_study` (`qtl_study_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_obs_unit_set`
--

DROP TABLE IF EXISTS `qtl_obs_unit_set`;
CREATE TABLE `qtl_obs_unit_set` (
  `qtl_obs_unit_set_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `comments` text,
  PRIMARY KEY  (`qtl_obs_unit_set_id`),
  UNIQUE KEY `name` (`name`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_obs_unit_set_ibfk_1` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_qtl`
--

DROP TABLE IF EXISTS `qtl_qtl`;
CREATE TABLE `qtl_qtl` (
  `qtl_qtl_id` int(10) unsigned NOT NULL auto_increment,
  `qtl_analysis_result_id` int(10) unsigned NOT NULL default '0',
  `qtl_accession_id` varchar(255) NOT NULL default '',
  `published_symbol` varchar(255) default NULL,
  `linkage_group` varchar(255) default NULL,
  `start_position` double(11,2) default NULL,
  `peak_position` double(11,2) default NULL,
  `stop_position` double(11,2) default NULL,
  `additive` double(11,5) default NULL,
  `dominance` double(11,5) default NULL,
  `lod` double(11,5) default NULL,
  `f_value` double(11,5) default NULL,
  `t_value` double(11,5) default NULL,
  `p_value` double(11,5) default NULL,
  `r_square` double(11,5) default NULL,
  `comments` text,
  PRIMARY KEY  (`qtl_qtl_id`),
  UNIQUE KEY `qtl_accession_id` (`qtl_accession_id`),
  KEY `qtl_analysis_result_id` (`qtl_analysis_result_id`),
  CONSTRAINT `qtl_qtl_ibfk_1` FOREIGN KEY (`qtl_analysis_result_id`) REFERENCES `qtl_analysis_result` (`qtl_analysis_result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_study`
--

DROP TABLE IF EXISTS `qtl_study`;
CREATE TABLE `qtl_study` (
  `qtl_study_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(200) NOT NULL default '',
  `reference_id` int(10) unsigned default NULL,
  `div_experiment_id` int(10) unsigned default NULL,
  `cmap_map_set_acc` varchar(200) default NULL,
  PRIMARY KEY  (`qtl_study_id`),
  KEY `div_experiment_id` (`div_experiment_id`),
  CONSTRAINT `qtl_study_ibfk_1` FOREIGN KEY (`div_experiment_id`) REFERENCES `div_experiment` (`div_experiment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `qtl_trait`
--

DROP TABLE IF EXISTS `qtl_trait`;
CREATE TABLE `qtl_trait` (
  `qtl_trait_id` int(10) unsigned NOT NULL auto_increment,
  `div_trait_uom_id` int(10) unsigned NOT NULL default '0',
  `div_statistic_type_id` int(10) unsigned NOT NULL default '0',
  `qtl_obs_unit_id` int(10) unsigned NOT NULL default '0',
  `date_measured` date default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`qtl_trait_id`),
  KEY `div_trait_uom_id` (`div_trait_uom_id`),
  KEY `div_statistic_type_id` (`div_statistic_type_id`),
  KEY `qtl_obs_unit_id` (`qtl_obs_unit_id`),
  CONSTRAINT `qtl_trait_ibfk_1` FOREIGN KEY (`div_trait_uom_id`) REFERENCES `div_trait_uom` (`div_trait_uom_id`),
  CONSTRAINT `qtl_trait_ibfk_2` FOREIGN KEY (`div_statistic_type_id`) REFERENCES `div_statistic_type` (`div_statistic_type_id`),
  CONSTRAINT `qtl_trait_ibfk_3` FOREIGN KEY (`qtl_obs_unit_id`) REFERENCES `qtl_obs_unit` (`qtl_obs_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `xref`
--

DROP TABLE IF EXISTS `xref`;
CREATE TABLE `xref` (
  `xref_id` int(10) unsigned NOT NULL auto_increment,
  `table_name` varchar(50) NOT NULL default '',
  `record_id` int(10) unsigned NOT NULL default '0',
  `xref_type_id` int(10) unsigned NOT NULL default '0',
  `xref_value` varchar(255) NOT NULL default '',
  `comments` text,
  PRIMARY KEY  (`xref_id`),
  KEY `xref_type_id` (`xref_type_id`),
  KEY `table_name` (`xref_type_id`,`record_id`),
  KEY `record_id` (`record_id`),
  KEY `record_id_2` (`record_id`),
  CONSTRAINT `xref_ibfk_1` FOREIGN KEY (`xref_type_id`) REFERENCES `xref_type` (`xref_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `xref_type`
--

DROP TABLE IF EXISTS `xref_type`;
CREATE TABLE `xref_type` (
  `xref_type_id` int(10) unsigned NOT NULL auto_increment,
  `xref_type` varchar(100) NOT NULL default '',
  `url_template` text NOT NULL,
  PRIMARY KEY  (`xref_type_id`),
  UNIQUE KEY `xref_type` (`xref_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

