use strict;
use Module::Build;

my $build = Module::Build->new(
    dist_name      => 'GDPDM-Tools',
    dist_version   => '2.5.0',
    dist_author    => 'Ken Youens-Clark <kclark@cshl.edu>',
    dist_abstract  => 'Perl code for interacting with a GDPDM schema',
    license        => 'perl',
    requires       => {
        'Class::DBI'                        => 0,
        'Class::DBI::AsForm'                => 0,
        'Class::DBI::FromForm'              => 0,
        'Class::DBI::Pager'                 => 0,
        'Class::DBI::Plugin::AbstractCount' => 0,
        'Class::DBI::Plugin::RetrieveAll'   => 0,
        'Class::DBI::Sweet'                 => 0,
        'Config::Tiny'                      => 0,
        'Data::Stag'                        => 0,
        'DBI'                               => 0,
        'Graph'                             => 0.69,
        'Graph::Traversal::DFS'             => 0,
        'IO::Prompt'                        => 0,
        'List::Util'                        => 0,
        'Log::Dispatch'                     => 0,
        'Pod::Usage'                        => 0,
        'Readonly'                          => 0,
        'String::Similarity'                => 0,
        'Template'                          => 0,
    },
    recommends     => {
        'Excel::Template'         => 0,
        'Spreadsheet::ParseExcel' => 0.2603,
        'Spreadsheet::WriteExcel' => 0,
        'SQL::Translator'         => 0.07,
    },
    build_requires => {
        'Test::More'              => 0,
    },
    script_files   => [ 
        'scripts/excel2sexp',
        'scripts/gdpdm-import.pl', 
    ],
);

$build->create_build_script;
