# Ensembl module for Bio::EnsEMBL::Analysis::Config::General
#
# Copyright (c) 2004 Ensembl
#
=head1 NAME

Bio::EnsEMBL::Analysis::Config::General

=head1 SYNOPSIS

    use Bio::EnsEMBL::Analysis::Config::General;
    use Bio::EnsEMBL::Analysis::Config::General qw();

=head1 DESCRIPTION

General pipeline configuration.

It imports and sets a number of standard global variables into the
calling package. Without arguments all the standard variables are set,
and with a list, only those variables whose names are provided are set.
The module will die if a variable which doesn\'t appear in its
C<%Config> hash is asked to be set.

The variables can also be references to arrays or hashes.

Edit C<%Config> to add or alter variables.

All the variables are in capitals, so that they resemble environment
variables.

=head1 CONTACT

B<ensembl-dev@ebi.ac.uk>

=cut

package Bio::EnsEMBL::Analysis::Config::General;

use strict;
use vars qw(%Config);
#print $ENV{'PROGRAM_HOME'}, "\n";exit;
%Config = (

    # binaries, libraries and data files
    BIN_DIR  => '',
    DATA_DIR => $ENV{PROGRAM_HOME1}.'/refdata',
    LIB_DIR  => $ENV{PROGRAM_HOME1}.'/lib',

#    ANALYSIS_WORK_DIR => '/export/home/liang/tmp',
    ANALYSIS_WORK_DIR => $ENV{DATA_HOME}.'/tmp',
    ANALYSIS_REPEAT_MASKING => [], #['RepeatMask'],

);



sub import {
    my ($callpack) = caller(0); # Name of the calling package
    my $pack = shift; # Need to move package off @_

    # Get list of variables supplied, or else all
    my @vars = @_ ? @_ : keys(%Config);
    return unless @vars;

    # Predeclare global variables in calling package
    eval "package $callpack; use vars qw("
         . join(' ', map { '$'.$_ } @vars) . ")";
    die $@ if $@;


    foreach (@vars) {
	if (defined $Config{ $_ }) {
            no strict 'refs';
	    # Exporter does a similar job to the following
	    # statement, but for function names, not
	    # scalar variables:
	    *{"${callpack}::$_"} = \$Config{ $_ };
	} else {
	    die "Error: Config: $_ not known\n";
	}
    }
}

1;
