# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Analysis::Config::GeneBuild::Databases - imports global variables used by EnsEMBL gene building

=head1 SYNOPSIS
    use Bio::EnsEMBL::Analysis::Config::GeneBuild::Databases;
    use Bio::EnsEMBL::Analysis::Config::GeneBuild::Databases qw(  );

=head1 DESCRIPTION

Databases is a pure ripoff of humConf written by James Gilbert.

humConf is based upon ideas from the standard perl Env environment
module.

It imports and sets a number of standard global variables into the
calling package, which are used in many scripts in the human sequence
analysis system.  The variables are first decalared using "use vars",
so that it can be used when "use strict" is in use in the calling
script.  Without arguments all the standard variables are set, and
with a list, only those variables whose names are provided are set.
The module will die if a variable which doesn\'t appear in its
C<%Databases> hash is asked to be set.

The variables can also be references to arrays or hashes.

Edit C<%Databases> to add or alter variables.

All the variables are in capitals, so that they resemble environment
variables.

=head1 CONTACT

=cut


package Bio::EnsEMBL::Analysis::Config::GeneBuild::Databases;

use strict;
use vars qw( %Databases );

# Hash containing config info
%Databases = (
	      # We use several databases to avoid the number of connections to go over the maximum number
	      # of threads allowed by mysql. If your genome is small, you can probably use the same db 
	      # for some of these entries. However, reading and writing in the same db is not recommended.
	      
	      # database containing sequence plus features from raw computes
	      GB_DBHOST                  => 'dbserver1',
	      GB_DBNAME                  => 'sorghum_dna',
	      GB_DBUSER                  => 'liang',
	      GB_DBPASS                  => 'liang',
	      GB_DBPORT                  => '3306',
	      # database containing the genewise genes (TGE_gw,similarity_genewise)
              GB_GW_DBHOST               => 'dbserver504',
              GB_GW_DBNAME               => 'tigr4_proteingene_masked',
              GB_GW_DBUSER               => 'ensembl',
              GB_GW_DBPASS               => 'ensembl',
              GB_GW_DBPORT               => '3306',
	      # database containing the blessed genes if there are any
	      GB_BLESSED_DBHOST          => 'dbserver41',
	      GB_BLESSED_DBNAME          => 'tigr4_blessedgene',
	      GB_BLESSED_DBUSER          => 'ensembl',
	      GB_BLESSED_DBPASS          => 'ensembl',
	      GB_BLESSED_DBPORT          => '3306',
	      # database where the combined_gw_e2g genes will be stored
	      GB_COMB_DBHOST             => 'dbserver1',
	      GB_COMB_DBNAME             => 'maize_accel7_mixedgene_new',
	      GB_COMB_DBUSER             => 'liang',
	      GB_COMB_DBPASS             => 'liang',
	      GB_COMB_DBPORT             => '3306',
	      GB_ABINITIO_DBHOST             => 'dbserver1',
	      GB_ABINITIO_DBNAME             => 'maize_accel7_mixedgene_new',
#	      GB_ABINITIO_DBNAME             => 'zea_mays_core_53_4a',
	      GB_ABINITIO_DBUSER             => 'liang',
	      GB_ABINITIO_DBPASS             => 'liang',
	      GB_ABINITIO_DBPORT             => '3306',
	      # database containing the cdnas mapped, to be combined with the genewises
	      # by putting this info here, we free up ESTConf.pm so that two analysis can
	      # be run at the same time
	      GB_cDNA_DBHOST             => 'dbserver41',
	      GB_cDNA_DBNAME             => 'tigr4_finalmrnagene',
	      GB_cDNA_DBUSER             => 'ensembl',
	      GB_cDNA_DBPASS             => 'ensembl',
              GB_cDNA_DBPORT             => '3306',
	      # db to put pseudogenes in
	      PSEUDO_DBHOST              => 'dbserver41',
	      PSEUDO_DBNAME              => 'liang1_pseudogene',
	      PSEUDO_DBUSER              => 'liang',
	      PSEUDO_DBPASS              => '',
              PSEUDO_DBPORT              => '3306',
	      # this db needs to have clone & contig & static_golden_path tables populated
	      GB_FINALDBHOST             => 'dbserver1',
	      GB_FINALDBNAME             => 'maize_accel7_finalgene_new',
	      GB_FINALDBUSER             => 'liang',
	      GB_FINALDBPASS             => 'liang',
              GB_FINALDBPORT             => '3306',
	     );

sub import {
  my ($callpack) = caller(0); # Name of the calling package
  my $pack = shift; # Need to move package off @_
  
  # Get list of variables supplied, or else
  # all of Databases:
  my @vars = @_ ? @_ : keys( %Databases );
  return unless @vars;
  
  # Predeclare global variables in calling package
  eval "package $callpack; use vars qw("
    . join(' ', map { '$'.$_ } @vars) . ")";
    die $@ if $@;


    foreach (@vars) {
	if ( defined $Databases{ $_ } ) {
            no strict 'refs';
	    # Exporter does a similar job to the following
	    # statement, but for function names, not
	    # scalar variables:
	    *{"${callpack}::$_"} = \$Databases{ $_ };
	} else {
	    die "Error: Databases: $_ not known\n";
	}
    }
}

1;
