# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Analysis::Config::Pseudogene

=head1 SYNOPSIS

    use Bio::EnsEMBL::Analysis::Config::Pseudogene_config;

=head1 DESCRIPTION

Provides configuration for:
Bio::EnsEMBL::Analysis::Runnable::Pseudogene.pm
Bio::EnsEMBL::Analysis::RunnableDB::Spliced_elsewhere 
Bio::EnsEMBL::Analysis::RunnableDB::PSILC


=head1 CONTACT

=cut


package Bio::EnsEMBL::Analysis::Config::Pseudogene;
use strict;
use vars qw( %Pseudogene );

# Hash containing config info
%Pseudogene = (	

	       # configs for the introns in repeats test
	       # total length of introns
	       PS_MAX_INTRON_LENGTH   => '5000',
	       # %coverd  repeats
	       PS_MAX_INTRON_COVERAGE => '80',
	       # %coverd by repeats
	       PS_MAX_EXON_COVERAGE   => '20',	
	       PS_NUM_FRAMESHIFT_INTRONS  => 1,
	       PS_NUM_REAL_INTRONS  => 1,
	       # configs for the spliced elsewhere tests
	       # %ID of a tbalstx of the (presumed) retrotransposed query sequence to its 
	       # homolog that is spliced elsewhere in the genome. hits falling below 
	       # this cutoff are ignored (80%) is suggested
	       PS_PERCENT_ID_CUTOFF   => 80,
	       # analysis logic names to run over genes falling into these categories
	       SINGLE_EXON      => '',
	       INDETERMINATE    => '',
	       RETROTRANSPOSED  => '',
	       # if you dont wish to run further tests on retro transposed genes
	       # What type would you like to give them?
	       RETRO_TYPE       => '',
	       SPLICED_ELSEWHERE_LOGIC_NAME => '',
	       PSILC_LOGIC_NAME => '',

               # Ignore the following config unless also running PSILC and/or Spliced_elsewhere

	       # SPLICED ELSEWHERE SPECIFIC CONFIG
	       # ratio of the spans of the retrotransposed gene vs its spliced homologue
	       # spliced / retrotransposed
	       # ie: 1 is the same length genes 
	       # many retrotransposed genes have a ratio > 10
	       # used to make retrotransposition decision
	       PS_SPAN_RATIO          => 3,
	       # mimimum number of exons for the spliced gene to have
	       PS_MIN_EXONS           => 2,
	       # path of blast db of multi exon genes
	       PS_MULTI_EXON_DIR       => "/my/blast/dir" ,
	       # Chunk size
	       PS_CHUNK => '100',
	       DEBUG => '1',

	       # PSILC SPECIFIC CONFIG
	       # Homolog databases
	       SUBJECT              => 'human',
	       PSILC_SUBJECT_DBNAME => 'homo_sapiens_core_28_35a',
	       PSILC_SUBJECT_DBHOST => 'ecs2',
	       PSILC_SUBJECT_DBPORT => '3365',

	       ORTH1                => 'mouse',
	       PSILC_ORTH1_DBNAME   => 'mus_musculus_core_28_33d',
	       PSILC_ORTH1_DBHOST   => 'ecs2',
	       PSILC_ORTH1_DBPORT   => '3365',

	       ORTH2                => 'rat',
	       PSILC_ORTH2_DBNAME   => 'rattus_norvegicus_core_28_3e',
	       PSILC_ORTH2_DBHOST   => 'ecs2',
	       PSILC_ORTH2_DBPORT   => '3365',

	       PSILC_WORK_DIR       => '/PSILC/output/directory',
	       # Max number of transcripts for each species
	       PS_SPECIES_LIMIT     => '5',
	       # directory and file name of 3 species blast db
	       PSILC_BLAST_DB       => '/my/multispecies/blast/dir',
	       PSILC_CHUNK          => '30',
	       # Only run PSILC over the longest transript in a gene if set to 1
	       # should speed it up if running over a very large dataset
	       REP_TRANSCRIPT       => '',
	       );	

sub import {
  my ($callpack) = caller(0); # Name of the calling package
  my $pack = shift; # Need to move package off @_
  
  # Get list of variables supplied, or else
  # all of Pseudogene_config:
  my @vars = @_ ? @_ : keys( %Pseudogene );
  return unless @vars;
  
  # Predeclare global variables in calling package
  eval "package $callpack; use vars qw("
    . join(' ', map { '$'.$_ } @vars) . ")";
    die $@ if $@;


    foreach (@vars) {
	if ( defined $Pseudogene{ $_ } ) {
            no strict 'refs';
	    # Exporter does a similar job to the following
	    # statement, but for function names, not
	    # scalar variables:
	    *{"${callpack}::$_"} = \$Pseudogene{ $_ };
	} else {
	    die "Error: Pseudogene: $_ not known\n";
	}
    }
}

1;
