#
# package Bio::EnsEMBL::Pipeline::Config::ExonerateTranscript
# 
# Cared for by EnsEMBL (ensembl-dev@ebi.ac.uk)
#
# Copyright GRL & EBI
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::EnsEMBL::Analysis::Config::AlignmentFilter

=head1 SYNOPSIS

use Bio::EnsEMBL::Analysis::Config::AlignmentFilter;

=head1 DESCRIPTION

It imports and sets a number of standard global variables into the
calling package, which are used in many scripts in the human sequence
analysis system.  The variables are first declared using "use vars",
so that it can be used when "use strict" is in use in the calling
script.  Without arguments all the standard variables are set, and
with a list, only those variables whose names are provided are set.

=head1 CONTACT

=cut


package Bio::EnsEMBL::Analysis::Config::AlignmentFilter;

use strict;
use vars qw( %Config );

# Hash containing config info
%Config = (
           CHAIN_CONFIG_BY_LOGIC => {
             DEFAULT => {
               TARGET_NIB_DIR => '/dir/with/target/seq/nib-files',
               QUERY_NIB_DIR  => '/dir/with/query/seq/nib-files',

               INPUT_METHOD_LINK_TYPE => 'BLASTZ_RAW',
               OUTPUT_METHOD_LINK_TYPE => 'BLASTZ_CHAIN',

               COMPARA_DB => {
                 -dbname => '',
                 -host   => '',
                 -user   => '',
                 -pass   => '',
                 -port   => '',
               },
               QUERY_CORE_DB => {
                 -dbname => '',
                 -user   => '',
                 -host   => '',
                 -port   => '',
               },
               TARGET_CORE_DB => {
                 -dbname => '',
                 -user   => '',
                 -host   => '',
                 -port   => '',
               },

               MAX_GAP => 50,
             },

           },            

           NET_CONFIG_BY_LOGIC => {
             DEFAULT => {

               QUERY_SPECIES  => 'Homo sapiens',
               TARGET_SPECIES => 'Bos taurus',

               INPUT_METHOD_LINK_TYPE => 'BLASTZ_CHAIN',
               OUTPUT_METHOD_LINK_TYPE => 'BLASTZ_NET',

               COMPARA_DB => {
                 -dbname => 'klh_compara_human_cow_blastz_27',
                 -host   => 'ia64f',
                 -user   => 'ensadmin',
                 -pass   => 'ensembl',
                 -port   => '3306',                 
               },

               MAX_GAP => 50,
               MIN_CHAIN_SCORE => 2000,

               # If you want simple nets (not using Jim Kent's code), 
               # set the below to one of "LOW", "MEDIUM" or "HIGH". If
               # not, leave it empty
               SIMPLE_NET => 'MEDIUM',

               # the other parameters only apply if using Kent's tools
               FILTER_NON_SYNTENIC => 1,               
             },
           );

sub import {
  my ($callpack) = caller(0); # Name of the calling package
  my $pack = shift; # Need to move package off @_

  # Get list of variables supplied, or else everything
  my @vars = @_ ? @_ : keys( %Config );
  return unless @vars;
  
  # Predeclare global variables in calling package
  eval "package $callpack; use vars qw("
    . join(' ', map { '$'.$_ } @vars) . ")";
    die $@ if $@;


    foreach (@vars) {
	if ( defined $Config{$_} ) {
            no strict 'refs';
	    # Exporter does a similar job to the following
	    # statement, but for function names, not
	    # scalar variables:
	    *{"${callpack}::$_"} = \$Config{ $_ };
	} else {
	    die "Error: Config: $_ not known\n";
	}
    }
}

1;
