#!/usr/local/bin/perl 

use strict;
use warnings;

use lib qw ( ensembl/modules ensembl-external/modules lib/perl);

use CSHL::Config;
use Bio::EnsEMBL::DBLoader;


#    my $ENSEMBL_ORACLE_HOME='/oracle1/app/oracle/product/8.1.7';
#    #my $ENSEMBL_TWO_TASK='P:rice';
#    my $ENSEMBL_TWO_TASK='T:localhost:rice';
#    $ENV{ORACLE_HOME} = $ENSEMBL_ORACLE_HOME if ($ENSEMBL_ORACLE_HOME) ;
#    $ENV{TWO_TASK} = $ENSEMBL_TWO_TASK if ($ENSEMBL_TWO_TASK) ;
#    $ENV{ORA_PIPES} = "V2";
#    $ENV{TNS_ADMIN}=$ENSEMBL_ORACLE_HOME.'/network/admin';

    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator );
 
    my $gene_dbobj=$db->gene_Obj;
    #my $gene_adaptor=$db->get_GeneAdaptor;

    my @genes=$gene_dbobj->get_all_Gene_id();
		#$gene_adaptor->list_geneIds();	#$db->get_all_Gene_id();

    my %count;
    my $max_len=0;

    foreach my $geneid (@genes) {
	#print "! $geneid\n";
        my $gene=$gene_dbobj->get($geneid);
		#$gene_adaptor->fetch_by_dbID($geneid);	#$db->get_Gene($geneid);
	my @exons=();

	foreach my $trans ($gene->each_Transcript) {
	    my $pep=$trans->translate();
	    my $seq_len=length($pep->seq());
	    $count{$seq_len}++;
	    $max_len=$seq_len and print "$max_len\n" if $seq_len>$max_len;
	}
    }

    print "longest translation $max_len aa\n";

    print "\n",map { "$_: $count{$_}\n" } sort keys %count;


