#!/usr/local/bin/perl 

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use Gramene::GenbankTranslation;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;


    #my $ENSEMBL_ORACLE_HOME='/oracle1/app/oracle/product/8.1.7';
    #my $ENSEMBL_TWO_TASK='P:rice';
    #my $ENSEMBL_TWO_TASK='T:localhost:rice';
    #$ENV{ORACLE_HOME} = $ENSEMBL_ORACLE_HOME if ($ENSEMBL_ORACLE_HOME) ;
    #$ENV{TWO_TASK} = $ENSEMBL_TWO_TASK if ($ENSEMBL_TWO_TASK) ;
    #$ENV{ORA_PIPES} = "V2";
    #$ENV{TNS_ADMIN}=$ENSEMBL_ORACLE_HOME.'/network/admin';

    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator );
 
    my $gene_dbobj=$db->gene_Obj;
    #my $gene_adaptor=$db->get_GeneAdaptor;

    my @genes=@ARGV;
    @genes or @genes=$gene_dbobj->get_all_Gene_id();
		#$gene_adaptor->list_geneIds();	#$db->get_all_Gene_id();

    my %count;

    foreach my $geneid (@genes) {
	#print "! $geneid\n";
        my $gene=$gene_dbobj->get($geneid);
		#$gene_adaptor->fetch_by_dbID($geneid);	#$db->get_Gene($geneid);
	my @exons=();
	my (%clones,$strand,@gb_seq);

	my ($gb_seq,$gbid)=(undef,undef);

	foreach my $trans ($gene->each_Transcript) {
	    my $pep=$trans->translate();
	    my $ens_seq=lc($pep->seq());
	    my $gblation=Gramene::GenbankTranslation->new($db,$trans->id);
	    $gblation->ok(1) and ++$count{'ok'} and next 
	     if( $gblation->translation && $gblation->translation eq $ens_seq);
	    if(!defined $gbid or !$gb_seq) { #try to get from genbank
		($gbid,$gb_seq)=from_genbank($gene,$gblation,$ens_seq);
		$gb_seq or print "No GenBank sequence for $geneid\n\n" ;
		++$count{'Genbank Wrong'} and next if $gblation->ok == -1;
	    }
	    $gb_seq or ++$count{"No GenBank sequence"} and next;
	    if ( $gb_seq ne $ens_seq ) {
		$gblation->ok(0);
		#if(!@exons) {
		    ## Get a list of exons for this gene
		    #@exons=$gene->each_unique_Exon;
		    @exons=$trans->each_Exon;

		    my ($forward,$reverse);
		    foreach my $exon (@exons){
			$clones{$exon->clone_id}=1;
			$forward=1 if $exon->strand==1;
			$reverse=1 if $exon->strand==-1;
		    }
		    $strand = $forward ? $reverse ? 'forward & reverse strands'
		    				  : 'forward strand'
				       : 'reverse strand';
		    @gb_seq=unpack('C*',$gb_seq);
		#}
		my @ens_seq=unpack('C*',$ens_seq);
		my $mismatchposn;
		for($mismatchposn=0;$mismatchposn<=$#gb_seq;$mismatchposn++) { 
		    last if $ens_seq[$mismatchposn] != $gb_seq[$mismatchposn];
		}
		my $remaining=$mismatchposn*3;
		my $mm_exon='?';
		my $structure=join ('', map { $_->id." (".$_->length.") phase ".$_->phase." to ".$_->end_phase."\n" } @exons );
		foreach my $exon (@exons) {
		    $remaining -= $exon->length;
		    if($remaining<0) { $mm_exon=$exon->id; $remaining+=$exon->length; last; }
		}
		print "gene $geneid, clone: ",join("& ",keys %clones),", $strand  Mismatch after $mismatchposn ($mm_exon:$remaining) :\nEnsEMBL\n".show_mismatch($ens_seq,$mismatchposn)."\n$structure\nGenbank $gbid\n".show_mismatch($gb_seq,$mismatchposn)."\n\n" ;
		#{ my $seq=$trans->dna_seq->seq;
		#print join("\n",$seq =~ /(.{1,60})/g),"\n";
		#}
		$count{"mismatch $strand"}++;
	    } else {
		++$count{'ok'};
	    }
	}
    }

    print "\n",map { "$_: $count{$_}\n" } sort keys %count;


sub from_genbank {  # return ($gbid,$gbseq)
    my($gene,$gbtranscript,$our_translation)=@_;
    my @DBLINKS = $gene->each_DBLink();
    my $gbid='';
    foreach (@DBLINKS){
	#print "!! ",$_->database()," ",$_->primary_id(),"\n";
	if ($_->database() eq "ENTREZPRO"){
	    $_->primary_id() or next;
	    $gbid= $_->primary_id() ;

	    #$gbid =~ s/\..*//;
	    #print $gene->id,"->$gbid\n";

	    $gbtranscript->genbank_id($gbid);
	    last if $gbtranscript->verify($our_translation);
	}
    }
    if(!$gbid) {	#2 of these return false values, so can't and them together
	$gbtranscript->genbank_id('');
	$gbtranscript->translation('');
	$gbtranscript->ok(1);
    }
    return ($gbid,$gbtranscript->translation);
}

sub show_mismatch {
    my($seq,$mm)=@_;
    $seq=substr($seq,0,$mm).'<>'.substr($seq,$mm).'//';
    join("\n",$seq =~ /(.{1,60})/g);
}


