#!/usr/local/bin/perl

use strict;
use CGI(':all');

my  @best;

my %addnl_cols;
my $n_addnl_cols;
my $table;

my @headers;

while(<>) {
#    print and next if /^#/;
    chomp;
    if (/^#/) {
	s/^#//;
	push @headers,$_;
	next;
    }
    my @vals=split;

    my @addnl=0 x $n_addnl_cols;
    while ($vals[$#vals] =~ /(.*)=(.*)/) {
	my ($name,$count)=($1,$2);
	--$#vals;
	$addnl_cols{$name} = $n_addnl_cols++ unless exists $addnl_cols{$name};
	$addnl[$addnl_cols{$name}]=$count;
    }
    push @vals,@addnl;
    my $clone=shift @vals;	# remove name
    #add( qq(<a href="/perl/contigview?clone=$clone">$_</a><br>\n),\@vals );
    add( [$clone,$_],\@vals );
}

#print sort map { $_->[0] } @best;

#print sort map { ($_->[1]->[0]>1 ?
#		      qq(<a href="/perl/contigview?clone=").$_->[0]->[0].qq(">)
#			  .$_->[0]->[1].qq(</a><br>\n)
#		    : $_->[0]->[1]."<br>\n" ) } @best;


my $ncols= 1+scalar(@{$best[0]->[1]})-($n_addnl_cols?($n_addnl_cols-1):0);	#first 1+ for clone, all 'addnl' to one column
print STDERR "$ncols\n";
foreach my $row (sort { $a->[0]->[0] cmp $b->[0]->[0] } @best) {
    my $first= $row->[1]->[0]>1 ?	#i.e. only display phase 2 & 3
		      qq(<a href="/perl/contigview?clone=).$row->[0]->[0].qq(">)
			  .$row->[0]->[0].qq(</a>)
		    : $row->[0]->[0];
    my @info= split(' ',$row->[0]->[1],$ncols);
    shift @info;
    #push @info,join(" ",@info);	#splice(@info,-$n_addnl_cols));
    $table .= Tr(td($first),td(\@info))."\n";
}

my $title='Clones with a lot of Features';
print  start_html(-title=>$title), h1($title), table( { border=>1 },
(map { Tr(th[map { s/_/ /g?$_:$_ } split (/[, ]+/,$_,$ncols) ] )."\n" } @headers),  #note-not good if too few columns result
$table
), end_html;

sub vcompare {
my ($a,$b)=(@_);
    my ($gt,$lt)=(0,0);
    for my $i (0..$#$a) {
	if( $a->[$i]>($b->[$i] ||0)) { $gt=1; return undef if $lt; }
	if($a->[$i]<($b->[$i] ||0)) { $lt=1; return undef if $gt; }
    }
    if($#$b>$#$a ) {
	for my $i (($#$a+1)..$#$b) {
	    if( 0>$b->[$i] ) { $gt=1; return undef if $lt; }
	    if( 0<$b->[$i] ) { $lt=1; return undef if $gt; }
	}
    }
    return $gt-$lt;
}

sub add {
    my ($text,$vals)=(@_);
    my $i;
    for($i=0;$i<=$#best;$i++) {
	my $res=vcompare($vals,$best[$i]->[1]);
	next unless defined($res); #incomparable
	return if($res<0);	#new one is too small
	last if $res=0;	# new one is equiv to another 'best'
	#new one is better - remove an old one
	$best[$i]=$best[$#best];
	pop @best;
    }
    push @best,[$text,$vals];
}
