#!/usr/local/bin/perl 

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use CSHL::Config;
use Bio::EnsEMBL::DBLoader;


#    my $ENSEMBL_ORACLE_HOME='/oracle1/app/oracle/product/8.1.7';
#    #my $ENSEMBL_TWO_TASK='P:rice';
#    my $ENSEMBL_TWO_TASK='T:localhost:rice';
#    $ENV{ORACLE_HOME} = $ENSEMBL_ORACLE_HOME if ($ENSEMBL_ORACLE_HOME) ;
#    $ENV{TWO_TASK} = $ENSEMBL_TWO_TASK if ($ENSEMBL_TWO_TASK) ;
#    $ENV{ORA_PIPES} = "V2";
#    $ENV{TNS_ADMIN}=$ENSEMBL_ORACLE_HOME.'/network/admin';

    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator );
 
    my $gene_dbobj=$db->gene_Obj;
    #my $gene_adaptor=$db->get_GeneAdaptor;

    my @genes=@ARGV;


    foreach my $geneid (@genes) {
	#print "! $geneid\n";
        my $gene=$gene_dbobj->get($geneid);
	my @exons=();
	my (%clones,$strand);

	## Get a list of exons for this gene
	@exons=$gene->each_unique_Exon;

	my ($forward,$reverse);
	foreach my $exon (@exons){
	    $clones{$exon->clone_id}=1;
	    $forward=1 if $exon->strand==1;
	    $reverse=1 if $exon->strand==-1;
	}
	$strand = $forward ? $reverse ? 'forward+reverse'
				      : 'forward'
			   : 'reverse';
	print "$geneid ",join("+",keys %clones)," $strand (",
	          join(",", map { $_->start."..".$_->end } @exons),
		  ")\n";
    }



