#!/usr/local/bin/perl 

use strict;
use warnings;

use lib map { $ENV{'GrameneCodeDir'}."/$_" } qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use CSHL::Config;
use DBI;
use Bio::EnsEMBL::ExternalData::GMAPAdaptor;
use Bio::EnsEMBL::DBLoader;

#should get the following list with a query
my @features= sort  qw( BACend multi_est single_est hordeum_est
	triticum_est mays_est sorghum_bicolor_est cdo_bcd
	dupont_unigene_cluster dupont_unigenes maize_unigene_cluster
	tigr_maize_gi);

    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator );
    $db or die "database: $DBI::errstr";

    my $res=$db->selectcol_arrayref('select db from analysis where id in ( select unique analysis from feature ) ') 
	or print STDERR "features: $DBI::errstr\n" and exit;
    @features=sort @$res;
    print map { "$_\n" } @features;

    my $mdb=Bio::EnsEMBL::DBLoader->new( GMAPLocator );

    $mdb or die "cannot open Map Database: $DBI::errstr";

    print "#Clone, phase, #genes, ",(map { "#$_, "} @features ),"#repeats, markerstats\n";
    foreach my $clone_id ($db->get_all_Clone_id) {
	my $clone=$db->get_Clone($clone_id);
	my @genes=$clone->get_all_Genes();
	my @feat=$mdb->get_Ensembl_SeqFeatures_clone($clone_id,$clone->version);
	my %fcount=();
	foreach my $f (@feat) {
	    $fcount{$f->analysis->db}++;
	}
	#my $bacends=0;
	my %feature_counts= map { ($_,0) } @features;
	my $repfeatures=0;
	foreach my $contig ($clone->get_all_Contigs()) {

	    #my @bacends = $contig->get_all_SimilarityFeatures_above_score("BACend",80);
	    #$bacends += scalar(@bacends);
	    foreach my $feature (@features) {
		 my @hits= $contig->get_all_SimilarityFeatures_above_score($feature,80);
		 #$feature_counts{$feature}+=scalar(@hits);
		 my %ids=map { ($_->id,1) } @hits;	#so count an est, not each of its exons
		 $feature_counts{$feature}+=scalar(keys %ids);
	    }
	    my @repfeatures = $contig->get_all_RepeatFeatures();
	    $repfeatures+= scalar(@repfeatures);
	}
	print "$clone_id ",$clone->htg_phase," ",scalar(@genes),(map { " $feature_counts{$_}"} @features)," $repfeatures "
		,(map { "$_=$fcount{$_} " } sort keys %fcount),"\n";
    }


