#!/lab/bin/perl

use strict;

open SORT,"|sort -n" or die "sort:$!";
select(SORT);

my (%qbest,%tbest);

while(<>) {
    chomp;
    my @F=split /\t/;
    $F[0]>0 or next;
    my $qrat=$F[0]/$F[10];
    my $trat=$F[0]/$F[14];
    my $qname=$F[9];
    my $tname=$F[13];
    add(\%qbest,$qname,$qrat,$tname);
    add(\%tbest,$tname,$trat,$qname);
}

intersect(\%qbest,\%tbest);
intersect(\%tbest,\%qbest);

foreach my $q (keys %qbest) {
    my @qt=@{$qbest{$q}->[1]};
    my $qscore=$qbest{$q}->[0];
    foreach my $t (@qt) {
        print "$qscore\t",$tbest{$t}->[0],"\t$q\t$t\n";
    }
}

sub add {
    my($pbest,$name,$score,$other)=@_;
    if( exists $pbest->{$name} ) {
        return if $pbest->{$name}->[0]>$score;
	if($pbest->{$name}->[0]==$score)  {
	    push @{$pbest->{$name}->[1]},$other;
	    return;
	}
    }
    $pbest->{$name}=[$score,[$other]];
}

sub intersect {
    my ($xbest,$ybest)=@_;
    foreach my $x (keys %$xbest) {
	my @good=();
        foreach my $y ( @{$xbest->{$x}->[1]} ) {
	    push @good,$y if exists $ybest->{$y} && grep { $x eq $_ } @{$ybest->{$y}->[1]};
	}
	if(@good) {
	    $xbest->{$x}->[1]=\@good;
	} else {
	    delete $xbest->{$x};
	}
    }
}
