##########################################################################
# Programmer: Kuan Chang
# Date: 10/24/2001
# Version: 1.1
# Description: Reference Database Perl Module (RDB.pm)
##########################################################################
package RDB;

use strict;
use DBI;

##########################################################################
# constants
use constant DSN     => 'dbi:Oracle:'; 
use constant DB_USER => 'ref';
use constant DB_PASS => 'grain';

##########################################################################
# constants
my $TRAIT = 5;

##########################################################################
# constructor
sub new {
  my $invocant = shift;
  my $class = ref($invocant) || $invocant;
  my $self = { };
  bless($self, $class);
  return $self;
}

# destructor
sub DESTROY {
  my $self = shift;
  $self->terminate_database if $self->{'db'};
}

# subroutines
sub db {
  my $self = shift;
  unless ( $self->{'db'} ) {
  $self->{'db'} =  DBI->connect('dbi:Oracle:', q{ref/grain@(DESCRIPTION=
      (ADDRESS=(PROTOCOL=TCP)(HOST=chevre)(PORT=1521))
      (CONNECT_DATA=(SID=gramene)))}, "", 
      {
        'PrintError'  => 1, 
        'RaiseError'  => 1,
        'LongReadLen' => 3000,
        'LongTruncOk' => 1,
      });

#    $self->{'db'} = DBI->connect(
#        DSN, DB_USER, DB_PASS, { 
#        'PrintError'  => 1, 
#        'RaiseError'  => 1,
#        'LongReadLen' => 5000,
#        'LongTruncOk' => 1,
#    }) || die "Cannot open Ontology database: ", $DBI::errstr;
}
  return $self->{'db'};
}

sub terminate_database{
  my $self = shift;
  $self->{'db'}->disconnect() if $self->{'db'};
}

# functions for accessing ontology database
sub get_termID {
 # my $self = shift;
 # my $id = shift;
  my ($self, $id, $is_TO) = @_;
  my $dbh  = $self->db;
  die "Invalid input in get_termID" unless defined $id;
  my $sth;
 # $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id") || die $dbh->errstr;
  if($is_TO) {
    $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id and term_type = $TRAIT") || die $dbh->errstr;
  } else {
    $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id and term_type != $TRAIT") || die $dbh->errstr;
  }
  $sth->execute || die "Execute: ", $sth->errstr;
  my $term_id = $sth->fetchrow_array;
  $sth->finish;
  return $term_id;
}

sub get_gene_product_ids {
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_ids" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_id FROM association WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @product_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @product_ids, $row;
  }
  $sth->finish;
  return @product_ids;
}

sub get_association_id {
  my ($self, $term_id, $gene_product_id) = @_;
  die "Invalid input in get_association_id" unless (defined $term_id and defined $gene_product_id);
  my $dbh  = $self->db;
  my $sth = $dbh->prepare("SELECT association_id FROM association WHERE term_id=$term_id and gene_product_id=$gene_product_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $association_id = $sth->fetchrow_array;
  $sth->finish;
  return $association_id;
}

sub get_gene_product_symbol {
# id is gene product id
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_symbol" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_symbol FROM gene_product WHERE gene_product_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $symbol = $sth->fetchrow_array;
  $sth->finish;
  return $symbol;
}

sub get_gene_product_name {
# id is gene product id
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_name" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_full_name FROM gene_product WHERE gene_product_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $product_name = $sth->fetchrow_array;
  $sth->finish;
  return $product_name;
}

# from association id
sub get_evidence_codes {
  my ($self, $association_id) = @_;
  my $dbh  = $self->db;
  die  "Invalid input in get_evidence_codes" unless defined $association_id;
  my $sth = $dbh->prepare("SELECT evidence_code FROM evidence WHERE association_id=$association_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @evidence_codes = ();
  while(my $row = $sth->fetchrow_array){
    push @evidence_codes, $row;
  }
  $sth->finish;
  return @evidence_codes;
}

1;
