##########################################################################
# Programmer: Kuan Chang
# Date: 10/17/2001
# Version: 2.1
# Description: Ontology Database Perl Module (ODB.pm)
##########################################################################
package ODB;

use strict;
use DBI;

##########################################################################
##########################################################################
# constants
my $ISA = 1;
my $PARTOF = 2;
my $DEVELOPSFROM = 3;
my $TRAIT = 5;
my $GO_PREFIX = "GO:";
my $TO_PREFIX = "TO:";

##########################################################################
# constructor
sub new {
  my $invocant = shift;
  my $class = ref($invocant) || $invocant;
  my $self = { };
  bless($self, $class);
  return $self;
}

# destructor
sub DESTROY {
  my $self = shift;
  $self->terminate_database if $self->{'db'};
}

# subroutines
sub db {
  my $self = shift;
  unless ( $self->{'db'} ) {
    $self->{'db'} =  DBI->connect(OntologyDataSource, OntologyDBUser, OntologyDBPassword, OntologyDBOptions);
  }
}
  return $self->{'db'};
}

sub terminate_database{
  my $self = shift;
  $self->{'db'}->disconnect() if $self->{'db'};
}

# functions for accessing ontology database
sub get_termID {
 # my $self = shift;
 # my $id = shift;
  my ($self, $id, $is_TO) = @_;
  my $dbh  = $self->db;
  die "Invalid input in get_termID" unless defined $id;
  my $sth;
 # $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id") || die $dbh->errstr;
  if($is_TO) {
    $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id and term_type = $TRAIT") || die $dbh->errstr;
  } else {
    $sth = $dbh->prepare("SELECT term_id FROM term WHERE term_accession=$id and term_type != $TRAIT") || die $dbh->errstr;
  }
  $sth->execute || die "Execute: ", $sth->errstr;
  my $term_id = $sth->fetchrow_array;
  $sth->finish;
  return $term_id;
}

sub get_name {
  my $self = shift;
  my $id   = shift;
  #or die "Invalid input in get_name: No id";
  my $dbh  = $self->db;
  die "Invalid input in get_name" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_name FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $term_name = $sth->fetchrow_array;
  $sth->finish;  
 # my $term_name = $dbh->selectrow_array(qq[
 #     SELECT term_name 
 #     FROM   term 
 #     WHERE  term_id=?
 # ], {}, ( $id ) ) || die $dbh->errstr;
  return $term_name;
}

sub get_definition {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die "Invalid input in get_definition" unless defined $id;
  my $sth = $dbh->prepare("SELECT definition FROM term_definition WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $term_definition = $sth->fetchrow_array;
  $sth->finish;
  return $term_definition;
}

sub get_synonym {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die "Invalid input in get_synonym" unless defined $id;
  my $sth = $dbh->prepare("SELECT synonym_name FROM term_synonym WHERE term_id=$id")|| die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $synonym = $sth->fetchrow_array;
  $sth->finish;
  return $synonym;
}

sub get_gene_product_ids {
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_ids" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_id FROM association WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @product_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @product_ids, $row;
  }
  $sth->finish;
  return @product_ids;
}

sub get_association_id {
  my ($self, $term_id, $gene_product_id) = @_;
  die "Invalid input in get_association_id" unless (defined $term_id and defined $gene_product_id);
  my $dbh  = $self->db;
  my $sth = $dbh->prepare("SELECT association_id FROM association WHERE term_id=$term_id and gene_product_id=$gene_product_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $association_id = $sth->fetchrow_array;
  $sth->finish;
  return $association_id;
}

sub get_gene_product_symbol {
# id is gene product id
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_symbol" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_symbol FROM gene_product WHERE gene_product_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $symbol = $sth->fetchrow_array;
  $sth->finish;
  return $symbol;
}

sub get_gene_product_name {
# id is gene product id
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_gene_product_name" unless defined $id;
  my $sth = $dbh->prepare("SELECT gene_product_full_name FROM gene_product WHERE gene_product_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $product_name = $sth->fetchrow_array;
  $sth->finish;
  return $product_name;
}

# from association id
sub get_evidence_codes {
  my ($self, $association_id) = @_;
  my $dbh  = $self->db;
  die  "Invalid input in get_evidence_codes" unless defined $association_id;
  my $sth = $dbh->prepare("SELECT evidence_code FROM evidence WHERE association_id=$association_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @evidence_codes = ();
  while(my $row = $sth->fetchrow_array){
    push @evidence_codes, $row;
  }
  $sth->finish;
  return @evidence_codes;
}

# post: return list of IDs of parent terms;
sub get_parents {
  my $self = shift;  
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_parents" unless defined $id;
  my $sth = $dbh->prepare("SELECT term1_id FROM term_to_term WHERE term2_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @term_parents = ();
  while(my $row = $sth->fetchrow_array){
    push @term_parents, $row;
  }
  $sth->finish;
  return @term_parents;
}

# post: return list of IDs of child terms
sub get_children {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die  "Invalid input in get_children" unless defined $id;
  my $sth = $dbh->prepare("SELECT term2_id FROM term_to_term WHERE term1_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @term_children = ();
  while(my $row = $sth->fetchrow_array){
    push @term_children, $row;
  }
  $sth->finish;
  return @term_children;
}

# post: return $ISA, $PARTOF, $DEVELOPSFROM, or ""
sub get_relationship_type {
  my ($self, $parent, $child) = @_;
  die "Invalid input in get_relationship_type2" unless (defined $parent and defined $child);
  my $dbh  = $self->db;
  my $sth = $dbh->prepare("SELECT relationship_type FROM term_to_term WHERE term1_id=$parent and term2_id=$child") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $relationship_type = $sth->fetchrow_array;
  $sth->finish;
  return $relationship_type;
}

sub get_relationship_symbol {
  my ($self, $parent, $child) = @_;
  my $relationship = get_relationship_type($self, $parent, $child);
  if($relationship == $ISA){ return '[i] '; }
  elsif($relationship == $PARTOF){ return '[p] ';}
  elsif($relationship == $DEVELOPSFROM){ return  '[d] ';}
  else{ return ''; }
}

# post: return exact accesion id.  For example, GO:0005635
sub get_GO_accession {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die "Invalid input in GetAccessionID" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_accession FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $exact_accession = $GO_PREFIX;
  my $accession = $sth->fetchrow_array;
  my $length = 7 - length($accession);
  for my $x (1 .. $length){
      $exact_accession .= "0";
  }
  $exact_accession .= $accession;
  $sth->finish;
  return $exact_accession;
}

sub get_accession {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die "Invalid input in GetAccessionID" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_accession FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $accession = $sth->fetchrow_array;
  $sth->finish;
  $sth = $dbh->prepare("SELECT term_type FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $exact_accession;
  if($sth->fetchrow_array == $TRAIT) {
     $exact_accession = $TO_PREFIX;
  }
  else {
    $exact_accession = $GO_PREFIX;
  }
  my $length = 7 - length($accession);
  for my $x (1 .. $length){
      $exact_accession .= "0";
  }
  $exact_accession .= $accession;
  $sth->finish;
  return $exact_accession;
}

1;
