##########################################################################
# Programmer: Kuan Chang
# Date: 12/05/2001
# Version: 1.1
# Description: Mutant Database Perl Module (MuDB.pm)
#              Design for Simple Mutant Only
##########################################################################
package MuDB;

use strict;
use DBI;
use CSHL::Config;

##########################################################################
# constants
my $TRAIT = 5;
my $GO_PREFIX = "GO:";
my $TO_PREFIX = "TO:";

##########################################################################
# constructor
sub new {
  my $invocant = shift;
  my $class = ref($invocant) || $invocant;
  my $self = { };
  bless($self, $class);
  return $self;
}

# destructor
sub DESTROY {
  my $self = shift;
  $self->terminate_database if $self->{'db'};
}

# subroutines
sub db {
  my $self = shift;
  unless ( $self->{'db'} ) {
  $self->{'db'} =  DBI->connect(OntologyDataSource, OntologyDBUser, OntologyDBPassword,   {
        'PrintError'  => 1, 
        'RaiseError'  => 1,
        'LongReadLen' => 3000,
        'LongTruncOk' => 1,
      }); 
   }
  return $self->{'db'};
}

sub terminate_database{
  my $self = shift;
  $self->{'db'}->disconnect() if $self->{'db'};
}
##########################################################################
#functions for accessing mutant database
sub get_mutant_name {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_name" unless defined $id;
  my $sth = $dbh->prepare("SELECT mutant_name FROM core_mutant WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $name = $sth->fetchrow_array;
  $sth->finish;
  return $name;
};

sub get_mutant_symbol {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_symbol" unless defined $id;
  my $sth = $dbh->prepare("SELECT mutant_symbol FROM core_mutant WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $symbol = $sth->fetchrow_array;
  $sth->finish;
  return $symbol;
};

sub get_image_path {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_image_path" unless defined $id;
  my $sth = $dbh->prepare("SELECT image_path FROM core_mutant WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $path = $sth->fetchrow_array;
  $sth->finish;
  return $path; 
};

sub get_phenotypic_description {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_phenotypic_description" unless defined $id;
  my $sth = $dbh->prepare("SELECT phenotypic_description FROM core_mutant WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $phenotype = $sth->fetchrow_array;
  $sth->finish;
  return $phenotype; 
};

sub get_supplementray_description {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_supplementray_description" unless defined $id;
  my $sth = $dbh->prepare("SELECT supplementray_description FROM core_mutant WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $description = $sth->fetchrow_array;
  $sth->finish;
  return $description; 
}

# functions for map
#####################################################################
# one function fits all
# pre: data info in core mutant map info; given its mutant map info id
# post: return its info
#####################################################################
sub get_core_mutant_map_info {
  my ($self, $column_name, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_info" unless defined $id;
  my $sth = $dbh->prepare("SELECT $column_name FROM core_mutant_map_info WHERE mutant_map_info_id = $id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $info = $sth->fetchrow_array;
  $sth->finish;
  return $info;
}

### 
sub get_chromosome_number {
  my ($self, $map_info_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_chromosome_number" unless defined $map_info_id;
  my $sth = $dbh->prepare("SELECT chromosome_number FROM core_mutant_map_info WHERE mutant_map_info_id=$map_info_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $chromosome = $sth->fetchrow_array;
  $sth->finish;
  return $chromosome;
}

sub get_mutant_map_info_ids {
  my ($self, $mutant_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_map_info_ids" unless defined $mutant_id;
  my $sth = $dbh->prepare("SELECT mutant_map_info_id FROM core_mutant_map_info WHERE mutant_id=$mutant_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @map_info_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @map_info_ids, $row;
  }
  $sth->finish;
  return @map_info_ids;  
}

# get the reference ids for this $id in this $table_name
sub get_reference_ids {
  my ($self, $table_name, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_reference_ids" unless defined $id;
  my $sth = $dbh->prepare("SELECT reference_id FROM reference_to_object WHERE object_table = '$table_name' AND object_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @reference_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @reference_ids, $row;
  }
  $sth->finish;
  return @reference_ids;  
}

# one function fits all
sub get_reference_info {
  my ($self, $column_name, $ref_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_reference_info" unless defined $ref_id;
  my $sth = $dbh->prepare("SELECT $column_name FROM reference WHERE reference_id = $ref_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $info = $sth->fetchrow_array;
  $sth->finish;
  return $info; 
}

sub get_reference_source {
  my ($self, $ref_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_reference_source" unless defined $ref_id;
  my $sth = $dbh->prepare("SELECT source_name FROM source WHERE source_id IN (SELECT source_id FROM reference WHERE reference_id = $ref_id)") || die $dbh->errstr;

  # my $sth = $dbh->prepare("SELECT source.source_name FROM reference, source WHERE reference.reference_id = $ref_id AND reference.source_id = source.source_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $source_name = $sth->fetchrow_array;
  $sth->finish;
  return $source_name; 
}

sub get_reference_source_trivia {
  my ($self, $ref_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_reference_source_trivia" unless defined $ref_id;
  my $sth = $dbh->prepare("SELECT year FROM reference WHERE reference_id = $ref_id") || die $dbh->errstr;

  $sth->execute || die "Execute: ", $sth->errstr;
  my $source_trivia;
  my $tmp = $sth->fetchrow_array;
  if($tmp ne ""){
    $source_trivia = $tmp . "; ";
  }
  
  $sth = $dbh->prepare("SELECT volume FROM reference WHERE reference_id = $ref_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  $tmp = $sth->fetchrow_array;
  if($tmp ne ""){
    $source_trivia .= $tmp . ": ";
  }
  
  $sth = $dbh->prepare("SELECT start_page FROM reference WHERE reference_id = $ref_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  $tmp = $sth->fetchrow_array;
  if($tmp ne ""){
    $source_trivia .= $tmp . "-";
  }
  
 $sth = $dbh->prepare("SELECT end_page FROM reference WHERE reference_id = $ref_id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  $tmp = $sth->fetchrow_array;
  if($tmp ne ""){
    $source_trivia .= $tmp . ".";
  }

  $sth->finish;
  return $source_trivia; 
}

sub get_reference_author {
  my ($self, $ref_id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_reference_author" unless defined $ref_id;
  my $sth = $dbh->prepare("SELECT contributor_name FROM contributor WHERE contributor_id IN (SELECT contributor_id FROM author WHERE reference_id = $ref_id)") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  
  #my $author_name = $sth->fetchrow_array;
  my $author_name;

  while(my $row = $sth->fetchrow_array){
    $author_name .= $row . ", ";
  }
  $author_name =~ s/,$/./;
  $sth->finish;
  return $author_name; 
}

sub get_mutant_map_ids {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_map_ids" unless defined $id;
  my $sth = $dbh->prepare("SELECT map_id FROM core_mutant_map_info WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @map_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @map_ids, $row;
  }
  $sth->finish; 
  return @map_ids;
}

sub get_mutant_to_ontology {
  my ($self, $id) = @_;
  my $dbh = $self->db;
  die "Invalid input in get_mutant_to_ontology" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_id FROM core_mutant_to_ontology WHERE mutant_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my @term_ids = ();
  while(my $row = $sth->fetchrow_array){
    push @term_ids, $row;
  }  
  $sth->finish;
  return @term_ids;
}

sub get_ontology_term_name {
  my ($self, $id) = @_;
  my $dbh  = $self->db;
  die "Invalid input in get_ontology_term_name" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_name FROM term WHERE term_id=$id") || die
 $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $term_name = $sth->fetchrow_array;
  $sth->finish;  
  return $term_name;
}

# post: return exact accesion id.  For example, GO:0005635
sub get_ontology_term_accession {
  my $self = shift;
  my $id = shift;
  my $dbh  = $self->db;
  die "Invalid input in GetAccessionID" unless defined $id;
  my $sth = $dbh->prepare("SELECT term_accession FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $accession = $sth->fetchrow_array;
  $sth->finish;
  $sth = $dbh->prepare("SELECT term_type FROM term WHERE term_id=$id") || die $dbh->errstr;
  $sth->execute || die "Execute: ", $sth->errstr;
  my $exact_accession;
  if($sth->fetchrow_array == $TRAIT) {
     $exact_accession = $TO_PREFIX;
  }
  else {
    $exact_accession = $GO_PREFIX;
  }
  my $length = 7 - length($accession);
  for my $x (1 .. $length){
      $exact_accession .= "0";
  }
  $exact_accession .= $accession;
  $sth->finish;
  return $exact_accession;
}

1;
