##########################################################################
# Programmer: Kuan Chang
# Date:12/31/2001
# Description: Gramene Layout Perl Module (GL.pm)
##########################################################################
package GL;

use strict;
use CGI qw(:standard *table *TR *th *td *ul *ol);
use vars qw/@ISA @EXPORT $VERSION/;

require Exporter;
@ISA = 'Exporter';
@EXPORT = qw(print_top print_bottom print_mutant_search_area);
$VERSION = 1.2;
#####################################################################

sub print_top {
  my $title = shift;
  print start_html(-title=>$title,
		   -style=>{'src'=>'/stylesheets/gramene.css'},  
		   -bgcolor=>'white'
		  );
  print "<hr>";
}

sub print_bottom {
  print "<hr>";
  print table({-width=>'100%'},
	      TR(td( {-align=>"left",  -class=>"small"}, a( { -href=>'mailto:gramene@brie.cshl.org'}, 'gramene@brie.cshl.org')),
		 td( {-align=>"right", -class=>"small"}, "&copy;2001 Cold Spring Harbor Laboratory")));
}

sub print_mutant_search_area {
  my $self = url(-relative=>1);
  print start_form(-method=>'GET', -action=>"search_core");
  print table({-width=>'100%', -align=>'center'}, 
  '<th align=center class=searchtitle>Rice Mutant Database</th>
<tr align=center class=searchbody><td align=center><span class="alert">Type in ID or keyword to search for</span>&nbsp;&nbsp;&nbsp;<input type=text value="" framewidth=4 name=query size=50 maxlength=256>&nbsp;&nbsp;&nbsp;&nbsp;<input name=btn type=submit value="Mutant Search"> &nbsp;&nbsp;<input name=Clear type=reset value="Clear"><p>[e.g. <a href="/perl/mutant/search_mutant?id=GR:0060024">albino-5</a> or <a href="/perl/mutant/search_mutant?id=GR:0060024">GR:0060024</a>] </p></td></tr>'       
	     );
  
  print end_form();
  print "<hr>";
}

1;
