#!/usr/bin/perl
# File: time1.pl
use CGI ':standard';
use strict;
use IO::File;
use vars qw/$TMPNAM $TMPDIR $TMP_FILE %BLAST_OPTS/;

$TMPNAM = 'aaaaaa';
$TMPDIR = $ENV{'TMPDIR'} || $ENV{'TEMP'} || '/usr/tmp';
$TMP_FILE = tmpnam('.fasta');
open (BLAST_FILE,">/home/gramene/gramene_ensembl/perl/blast/Temp/lenny.blast");

my $sequence=param('sequence');
my $name=param('name');
my $path=param('path');
my $db=param('db');
my $program=param('program');
my @blast_opts=param('blast_opts');
my $blastmat=param('blastmat');
my $blastfilter=param('blastfilter');
my $blastdb="/home/gramene/blast_db";
my $unlinked;
%BLAST_OPTS= ('blastn'   =>  [qw/-progress 2 -hspmax 10/ ], 
              'tblastn'  =>  [qw/-progress 2 -hspmax 10/], 
              'blastp'  =>  [qw/-progress 2 -hspmax 10/], 
              'blastx'  =>  [qw/-progress 2 -hspmax 10/] 
             ); 

#create a temporary file in fasta format from the user-sequence
my $name = to_fasta($sequence,$name);

local(*B);
open(B,"-|") || do {
  @ENV{qw/BLASTMAT BLASTFILTER BLASTDB/} =  ($blastmat,$blastfilter,$blastdb);
  exec($path,$db,$TMP_FILE,@{$BLAST_OPTS{$program}}) && die "Couldn't exec: $!";   
};

#print out the blast output
 while (<B>) {
   chomp;
   print $_,"\n";
   print BLAST_FILE $_,"\n";
 }

unlink $TMP_FILE;
close(BLAST_FILE);
sub to_fasta {
  my ($sequence,$name) = @_;
  if ($sequence=~/^>(.+)$/m) { #fasta format already\
    $name = $1;
    $sequence=$';
  }
  $name ||= 'Untitled Sequence submitted by ' . remote_host();
  $sequence=~tr/a-zA-Z//cd;
  $sequence=~s/(.{80})/$1\n/g;
  my $file = IO::File->new(">$TMP_FILE") 
    || AceError("Couldn't open temporary file for writing sequence: $!");
  
  print $file ">$name\n$sequence";
  $file->close();
  $name;
}

sub tmpnam {
  my $suffix = shift;
  while(1) {
    my $tmpfile = "$TMPDIR/${$}" . $TMPNAM++ . $suffix;
    return $tmpfile if IO::File->new($tmpfile,O_EXCL|O_CREAT);
  }
}
