#!/usr/bin/perl

use GramenePage;
use strict;
use CGI ':standard';
use IO::File;
use IndexedFasta;
use vars qw/$TMPNAM $TMPDIR $SEQ1_FILE $SEQ2_FILE $SEQ2_REV_FILE $ALIGN_FILE $ALIGN_REV_FILE/;

$TMPNAM = 'seq';
$TMPDIR = $ENV{'TMPDIR'} || $ENV{'TEMP'} || '/usr/tmp';
$SEQ1_FILE = tmpnam('.fasta');
$SEQ2_FILE = tmpnam('.fasta');
$SEQ2_REV_FILE=tmpnam('.fasta');
$TMPNAM="aligned";
$ALIGN_FILE = tmpnam('.out');
$ALIGN_REV_FILE = tmpnam('.out');


#my $c_id=param('c_id');
#my $c_start=param('c_start');
#my $c_stop=param('c_stop');
#my $f_name=param('f_name');
#my $f_id=param('f_id');
#my $f_start=param('f_start');
#my $f_stop=param('f_stop');

my $c_id='AP004087';
my $c_start=60203;
my $c_stop=60388;
my $f_name='multi_est';
my $f_id='AA231654';
my $f_start=0;
my $f_stop=185;


my $fasta_dir='/home/gramene/blast_db/';

my %index_names=('rice_clones'=>'Rice_genome',
		 'bacend'=>'Rice_Bac_End',
		 'cdo_bcd_marker'=>'Markers',
		 'gramark'=> 'Markers',
		 'hordeum_est'=>'Barley_EST',
		 'mays_est'=>'Corn_EST',
		 'multi_est'=>'Rice_EST',
		 'single_est'=>'Rice_EST',
		 'sorghum_bicolor_est'=>' Sorghum_B_EST',
		 'ssr'=>'Markers',
		 'triticum_est'=>'Wheat_EST');

my $clone_file=$fasta_dir.$index_names{rice_clones};
my $feature_file=$fasta_dir.$index_names{$f_name};
my $if=IndexedFasta->new();

my $seq1_handle=IO::File->new(">$SEQ1_FILE") 
    || AceError("Couldn't open temporary file for writing sequence: $!");

$if->do_sequence_search(START=>$c_start,STOP=>$c_stop,SEQ_ID=>$c_id,FASTA=>$clone_file); 
my $seq1=$if->sequence();
print $seq1_handle ">$c_id\n$seq1";
$seq1_handle->close();
my $seq2_handle=IO::File->new(">$SEQ2_FILE") 
    || AceError("Couldn't open temporary file for writing sequence: $!");
$if->do_sequence_search(START=>$f_start,STOP=>$f_stop,SEQ_ID=>$f_id,FASTA=>$feature_file); 
my $seq2=$if->sequence();
print $seq2_handle ">$f_id\n$seq2";
$seq2_handle->close();


my $seq2_rev=reverse($seq2);
$seq2_rev=~tr/ACGT/TGCA/;
my $seq3_handle=IO::File->new(">$SEQ2_REV_FILE") 
    || AceError("Couldn't open temporary file for writing sequence: $!");
print $seq3_handle ">$f_id (Reverse complemented)\n$seq2_rev";
$seq3_handle->close();

#water seq1 seq2 -gapopen 10 -gapextend .5 -outfile first.water
#my @options=qw/-gapopen 10 -gapextend .5 -outfile whatever/;
my @options=qw(-gapopen 10 -gapextend .5  -datafile EDNAFULL -outfile);

system('water',$SEQ1_FILE,$SEQ2_FILE,@options,$ALIGN_FILE)==0 || die "Couldn't exec: $!"; 
system('water',$SEQ1_FILE,$SEQ2_REV_FILE,@options,$ALIGN_REV_FILE)==0 || die "Couldn't exec: $!"; 

my ($first_score,$first_align)=get_alignment($ALIGN_FILE);
my ($second_score,$second_align)=get_alignment($ALIGN_REV_FILE);
#if($first_score>$second_score){print $first_align;}
#else{print $second_align;}

my $page_title = "Smith Waterman Local Alignment";
my $q = CGI->new();
print $q->header;
my $page = GramenePage->new(Apache->request);
print $q->start_html( -title=>$page_title,
                      -style=>{'src'=>$page->stylesheet}
                    );

print $page->start_body();
 print pre(escapeHTML($first_align));
print $page->end_body();
END{
  unlink($SEQ1_FILE) or die "Couldn't unlink the file: $!";
  unlink($SEQ2_FILE) or die "Couldn't unlink the file: $!";
  unlink($SEQ2_REV_FILE) or die "Couldn't unlink the file: $!";
  unlink($ALIGN_FILE) or die "Couldn't unlink the file: $!";
  unlink($ALIGN_REV_FILE) or die "Couldn't unlink the file: $!";
}

sub tmpnam {
  my $suffix = shift;
  while(1) {
    my $tmpfile = "$TMPDIR/${$}" . $TMPNAM++ . $suffix;
    return $tmpfile if IO::File->new($tmpfile,O_EXCL|O_CREAT);
  }
}

sub get_alignment{
  my $file_name=shift;
  my $aligned_file=IO::File->new("$file_name") 
    || AceError("Couldn't open temporary file for writing sequence: $!");
  my $alignment; 
  my $score;
  while (defined(my $line=$aligned_file->getline())){
    if($line=~m/Score/){
#      print "$line";
      $alignment.=$line;
      ($score)=($line=~m/Score: (\d+\.\d+)/);
    }
    elsif($line=~m/$c_id/){
      my($id,$start,$sequence,$stop)=split(/\s+/,$line);
      $start+=$c_start;
      $stop+=$c_start;
      #print "$id\t$start\t $sequence\t$stop\n";
      $alignment.="$id\t$start\t $sequence\t$stop\n";
    }
    elsif($line=~m/$f_id/){
      my($id,$start,$sequence,$stop)=split(/\s+/,$line);
      #print "$id\t$start\t $sequence\t$stop\n";
      $alignment.="$id\t$start\t $sequence\t$stop\n";
    }
    else{
      $alignment.=$line;
      #print $line;
    }
  }
  return ($score,$alignment);
}
