#!/usr/local/bin/perl

use strict;
use CGI qw/:standard/;
use DBI qw(:sql_types);
use Apache;
use EnsWeb;
use GramenePage;
use CSHL::Config;

use vars qw( %ChromToCloneList );

my $chr = param('chr');
$chr=1 unless defined($chr) and $chr ne '';

my $sorting = param('sorting');

my ($item, $order);

if (!$sorting) {
    $item = "phase";
    $order= 21;
} else { 
    ($item,$order) = split(/_/, $sorting);
    $order = $item eq 'phase' ? 21 : 12
      unless $order == 21 or $order == 12;
}

unless($ChromToCloneList{$chr} && @{$ChromToCloneList{$chr}}) {

    my (%cloneName, %seqSite, %HTGPhase, %length, %homePage, %fragments);
    my ($clone_id, $clone_name, $site, $phase, $len, $page);

    #print STDERR "connect(,",SequenceDBUser,",",SequenceDBPassword,")\n";

    my $dbh 
      = DBI->connect(SequenceDataSource, SequenceDBUser, SequenceDBPassword);

    my $query = "select clone.id, clone.name, clone.site, clone.htg_phase, ". 
		"dna.length, sequencing_site.home_page ".
		"from clone, dna, sequencing_site, contig ".
		"where clone.internal_id = contig.clone and ".
		"contig.dna = dna.id and ".
		"clone.site = sequencing_site.id and ".
		"contig.chromosomeId = $chr";

    #print STDERR "$query\n";

    my $sth = $dbh->prepare($query);


    $sth->bind_columns(undef,\$clone_id,\$clone_name,\$site,\$phase,\$len,\$page) or print STDERR "bind_columns:",$sth->errstr,"\n"; 

    $sth->execute() or print STDERR "execute:",$sth->errstr,"\n"; 

    while ($sth->fetchrow) {

	if (!$cloneName{$clone_id}) {
	  $cloneName{$clone_id} = $clone_name;
	}
	$seqSite{$clone_id} = $site;
	$HTGPhase{$clone_id} = $phase;
	$length{$clone_id} += $len;
	$homePage{$clone_id} = $page;
	$fragments{$clone_id}++;
    }

    $sth->finish;

    foreach my $clone_id (keys %length) {
	my $annotated=0;
	if ($phase == 3) { 
	  my $query = "select exon.id ".
		      "from clone, contig, exon ".
		      "where clone.internal_id = contig.clone and ".
		      "exon.contig = contig.internal_id and ".
		      "clone.id = \'$clone_id\'";

	  my $sth = $dbh->prepare($query);

	  $sth->execute();
    
	  $annotated=1 if ($sth->fetchrow) ;
	  $sth->finish;
	}
	push @{$ChromToCloneList{$chr}},
	    [ $clone_id, 
              $cloneName{$clone_id}, 
	      $seqSite{$clone_id}, 
	      $HTGPhase{$clone_id}, 
	      $length{$clone_id}, 
	      $homePage{$clone_id}, 
	      $fragments{$clone_id}, 
              $annotated ]
        # - this list must match the arguments of tableContents()
        # and the   %column hash in buildSeqTable()
    }
}	#end of getting data for this chromosome

my %labels =('1'=>'Chromosome 1', 
	     '2'=>'Chromosome 2', 
             '3'=>'Chromosome 3', 
             '4'=>'Chromosome 4',
             '5'=>'Chromosome 5', 
             '6'=>'Chromosome 6', 
             '7'=>'Chromosome 7', 
             '8'=>'Chromosome 8',
             '9'=>'Chromosome 9', 
             '10'=>'Chromosome 10', 
             '11'=>'Chromosome 11', 
             '12'=>'Chromosome 12',
             '0'=>'Unassigned');

my @values = ('1', '2', '3', '4', '5', '6', '7', 
	      '8', '9', '10', '11', '12', '0');

my $r=Apache->request();
my $grpg=GramenePage->new($r);
print CGI::header();       
print CGI::start_html(-title=>"Rice Genome Browser",-style=>{-src=>$grpg->stylesheet});
print $grpg->start_body();


print <<HEADER;
<center>

<table cellspacing=\"0\" cellpadding=\"3\" border=\"0\" width=\"98%\">
 <tr>
   <th align=\"CENTER\" colspan=2 class=\"searchtitle\">Rice BAC/PAC Sequence Information</th>
 </tr>
 <tr valign=\"bottom\">
  <td align=\"CENTER\" class=\"searchbody\"><br>
  <span class=\"alert\"><font size=+1>Select a chromosome</font></span>
  </td>
  <td align=\"CENTER\" class=\"searchbody\"><br>
  <span class=\"alert\"><font size=+1> BAC/PAC Name or Accession&nbsp;&nbsp;</font></span>[e.g.&nbsp;<a href=\"/perl/contigview?clone=AP002540\">P0434B04</a>,&nbsp;&nbsp;<a href=\"/perl/contigview?clone=AP002540\">AP002540</a>]
  </td>
 </tr>
HEADER

print "<tr valign=\"top\">\n";
print " <td align=\"CENTER\" nowrap class=\"searchbody\">\n";
print start_form(-method=>'POST', 
                 -action=>'/perl/SeqTable.cgi');

print popup_menu(-name=>"chr",
                 -Values=>\@values,
                 -default=>"3",
                 -labels=>\%labels);

print submit('Search');
print end_form();
print "</td>\n";

print "<td align=\"CENTER\" nowrap class=\"searchbody\">\n";
print start_form(-method=>'GET',
                 -action=>'/perl/unisearch');
print hidden(-name=>'type',
             -value=>'clone');
print "<INPUT TYPE=\"TEXT\" NAME=\"q\" SIZE=\"20\">\n";
print submit('Display');         	    
print end_form();
print "</td>\n";
print "</tr>\n";
print "</table>\n";
print "</center>\n";

print <<MAINTABLETEXT;
<center>
 <h2>To view the features of a sequence, please select a BAC/PAC.</h2>
<p><span class="alert">(Note: Contig Viewer is currently able to display information for BACs/PACs in
 phase 2 and up)</span> 
</center>
MAINTABLETEXT

print "<br>";

print "<center><table align=\"CENTER\" width=\"80%\"><tr align=\"CENTER\"><td align=\"CENTER\">";
print EnsWeb::print_form( '',"all" );
print "</td></tr></table></center>";

if ( ! $ChromToCloneList{$chr} ) {
    print "<br><br>\n";
    print "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n";

    if ($chr == 0) {
      print "There is no information available for unassigned BAC/PACs\n";

    } else {
      print "There is no BAC/PAC information available on chromosome $chr.\n";
    } 
} else {

   print "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong>Chromosome $chr</strong>";
   print "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
   print "(",scalar(@{$ChromToCloneList{$chr}})," clones are sortable by clicking each column title )\n"; 

  buildSeqTable($chr,$item,$order);
}

print "<br>&nbsp;\n";
print $grpg->end_body;


sub buildSeqTable {

  my ($chr,$item,$order)=@_;

  my %order = (
	'phase' => 21,
	'acc' => 12,
	'clone' => 12,
	'site' => 12,
	'len' => 21,
    );
  $order{$item}=33-$order;	#if it's this column, reverse
  my ($c,$s,$p,$l,$ac)
    = map { $_."_".$order{$_} } qw( clone site phase len acc );
  
  print "<center>\n";
  print "<table BORDER COLS=7 WIDTH=\"95%\" NOSAVE >\n";
  print "<tr>\n";
  print "<td>\n";
  print "<center><font size=+1>";
  print "<a href=\"/perl/SeqTable.cgi?chr=$chr&sorting=$c\">";
  print "BAC/PAC</font> (contig viewer)</center>\n";
  print "</td>\n";

  print "<td>\n";
  print "<center><font size=+1>";
  print "<a href=\"/perl/SeqTable.cgi?chr=$chr&sorting=$s\">";
  print "Sequencing Site</font></center>\n";
  print "</td>\n";

  print "<td>\n";
  print "<center><font size=+1>";
  print "<a href=\"/perl/SeqTable.cgi?chr=$chr&sorting=$p\">";
  print "HTG Phase</font></center>\n";
  print "</td>\n";

  print "<td>\n";
  print "<center><font size=+1>Fragments</font></center>\n";
  print "</td>\n";

  print "<td>\n";
  print "<center><font size=+1>";
  print "<a href=\"/perl/SeqTable.cgi?chr=$chr&sorting=$l\">";
  print "DNA Length</font> (FASTA)</center>\n";
  print "</td>\n";

  print "<td>\n";
  print "<center><font size=+1>";
  print "<a href=\"/perl/SeqTable.cgi?chr=$chr&sorting=$ac\">";
  print "GenBank Accession</font></center>\n";
  print "</td>\n";
  print "</tr>\n";

  my %column = (
	'phase' => 3,
	'acc' => 0,
	'clone' => 1,
	'site' => 2,
	'len' => 4,
    );
  my %alpha = (
	'site' => 1,
	'clone' => 1,
	'acc' => 1,
	'phase' => 0,
	'len' => 0,
    );
   my $col=$column{$item};

   if ($order == 12 ) {
       if($alpha{$item}) {
	 foreach my $clone (sort {$a->[$col] cmp $b->[$col]
				    || $a->[0] cmp $b->[0] }
				  @{$ChromToCloneList{$chr}})  {
	   tableContents($clone);
	 }
       } else {
	 foreach my $clone (sort {$a->[$col] <=> $b->[$col]
				    || $a->[7] <=> $b->[7] 
				    || $b->[6] <=> $a->[6] 
				    || $b->[0] cmp $a->[0] }
				  @{$ChromToCloneList{$chr}})  {
	   tableContents($clone);
	 }
       }
   } else {
       if($alpha{$item}) {
	 foreach my $clone (sort {$b->[$col] cmp $a->[$col]
				    || $b->[0] cmp $a->[0] }
				  @{$ChromToCloneList{$chr}})  {
	   tableContents($clone);
	 }
       } else {	#default case : inverse by phase
	 foreach my $clone (sort {$b->[$col] <=> $a->[$col]
				    || $b->[7] <=> $a->[7] 
				    || $a->[6] <=> $b->[6] 
				    || $a->[0] cmp $b->[0] }
				  @{$ChromToCloneList{$chr}})  {
	   tableContents($clone);
	 }
       }

   }
  print "</table></center>\n";

}

sub tableContents {

    my $clone = shift;
    my ($clone_id, $clone_name, $site, $phase, $len, $page, $frags,$annotated)
        =@$clone;
  
    print "<tr>\n";
    print "<td>\n";
    print "<center>\n";
    if ($phase == 2 || $phase == 3) { 

      print "<a href=\"/perl/contigview?";
      print "clone=$clone_id\">\n";
      print "$clone_name</a>";
    } else {

      print "$clone_name";
    }
    print "</center>\n";
    print "</td>\n";
    print "<td>\n";
    print "<center><a href=\"$page\">$site</a></center>\n";
    print "</td>\n";

    print "<td>\n";

      if ($annotated ) {
	print "<center>$phase (annotated)</center>\n";
	
      } else {
	print "<center>$phase</center>\n";
      } 

    print "</td>\n";

    print "<td>\n";
    print "<center>$frags</center>\n";
    print "</td>\n";

    print "<td>\n";
    print "<center><a href=\"http://www3.ncbi.nlm.nih.gov/htbin-post/Entrez/query?uid=$clone_id&form=6&db=n&Dopt=f\">$len</a></center>\n";
    #print "<center><a href=\"http://www.ncbi.nlm.nih.gov/entrez/viewer.cgi?cmd&txt&save=0&cfm=on&query_key=1&db=nucleotide&view=fasta\">$len</a></center>\n";
    print "</td>\n";

    print "<td>\n";
    print "<center><a href=\"http://www3.ncbi.nlm.nih.gov/htbin-post/Entrez/query?uid=$clone_id&form=6&db=n&Dopt=g\">$clone_id</a></center>\n";
    print "</td>\n";

    print "</tr>\n";
}
