package HelpView;
#########
# rmp 2000
#
use strict;
use SiteDefs;
use CGI qw/:standard/;
use DBI;
use EnsWeb;

my $DB_HOST     = $ENSEMBL_HELP_HOST;
my $DB_NAME     = $ENSEMBL_HELP;
my $DB_PORT	= $ENSEMBL_HELP_PORT;
my $DB_USER     = $ENSEMBL_HELP_DBUSER;
my $DB_TABLE    = "helpview";
my $DB_PASSWORD = $ENSEMBL_HELP_DBPASS;
my $WIN_ATTRIBS = "width=400,height=500,resizable,scrollbars";
my $HELPVIEW    = "/perl/helpview";
my $HELPGFX     = "/gfx/helpview";

#########
# help table contains keyword->html content mappings.
# images reside in /htdocs/gfx/
#

#########
# handle incoming 'Eh?' searches
#
sub handler {
    my ($content_ref) = @_;
    my $kw = &CGI::param('kw');
    my $se = &CGI::param('se'); # single entry
    #print STDERR "hv key=$kw,1=$se\n";
    my $num;

    #my $dbh = DBI->connect("DBI:mysql:database=$DB_NAME;host=$DB_HOST;port=$DB_PORT", "$DB_USER", "$DB_PASSWORD", { RaiseError => 1});
    my $dbh = DBI->connect( "dbi:Oracle:",
	    qq{$DB_USER/$DB_PASSWORD@(DESCRIPTION=
		  (ADDRESS=(PROTOCOL=TCP)(HOST=$DB_HOST)(PORT=$DB_PORT))
		  (CONNECT_DATA=(SID=$DB_NAME)))},
	    "", { RaiseError => 1, FetchHashKeyName => 'NAME_lc' });
    

    if(!$se) {
	#########
	# if we're not looking for a single entry, do a search
	#
	$num = &search($dbh,$content_ref);
    } else {
	#########
	# otherwise, force us to look for a single kw in just a mo
	#
	$num = 1;
    }

    if($num == 1 ) {
	$$content_ref = "";
	&kw($dbh,$content_ref);
	return 1;

    } elsif($num <= 0) {
	$$content_ref = qq(No results found);
	return 0;

    } else {
	return $num;
    }
}

#########
# perform a fuzzy search
#
sub search {
    my ($dbh,$content_ref) = @_;
    my $content_tmp = "";
    my $rows = 0;
    my $line_hash;
    my $kw = &CGI::param('kw');

    eval {
	my $quotedkw = $dbh->quote("%$kw%");
	my $sth = $dbh->prepare("SELECT kw,title FROM $DB_TABLE WHERE kw LIKE $quotedkw OR content LIKE $quotedkw OR title LIKE $quotedkw ORDER BY title");
	$sth->execute();

	my %urlseen=();
	while($line_hash = $sth->fetchrow_hashref()) {
	    my $url = &helplink($$line_hash{'kw'});
	    next if $urlseen{$url}++;
	    $content_tmp .= qq(<li><a href="$url">$$line_hash{'title'}</a></li>\n);
	    $rows++;
	}
        $sth->finish();
    };
    if($@) {
        $$content_ref .= qq(Failed to perform search on $DB_NAME database);
        return;
    }

    if($content_tmp ne "") {
	$$content_ref .= qq(<ul>$content_tmp</ul>);
    }
    return $rows;
}

#########
# print an 'Eh?' search box
#
sub searchbox {
    my ($content_ref)=@_;
    my $kw = &CGI::param('kw');

    $$content_ref .= qq(<form action="/perl/helpview" method="GET"><input type="hidden" name="action" value="search"><input type="text" size="14" name="kw" value="$kw"><input type="image" src="/gfx/buttons/lookup.gif" border="0" width="70" height="25" alt="Lookup" hspace="2" vspace="2" align="absmiddle"></form>);
}

#########
# print out a single result (optional result_hash_ref, if we've just done a search)
#
sub kw {
    my ($dbh,$content_ref) = @_;
    my $kw = &CGI::param('kw');
    my $result_hash_ref;
    my ($content,$title);

	eval {
	    my $quotedkw = $dbh->quote($kw);
	    my $sth = $dbh->prepare("SELECT kw,title,content FROM $DB_TABLE 
			WHERE kw=$quotedkw 
			ORDER BY piece");
	    $sth || print STDERR $dbh->errstr;
	    $sth->execute() || print STDERR $dbh->errstr;

	    while($result_hash_ref = $sth->fetchrow_hashref()) {
		$content .= $$result_hash_ref{'content'};
		$title ||= $$result_hash_ref{'title'};
	    }

	    $sth->finish();
	};
	#print STDERR "$title:\n",substr($content,0,80),"\n";
	if($@) {
	    print STDERR "!:$@\n";
	    $$content_ref .= qq(Failed to retrieve result from $DB_NAME database);
	    return;
	}

    if(!defined $title) {
	$$content_ref .= qq(Sorry, no sections matching '$kw');

    } else {
	$$content_ref .=qq(
	<h3 align="center">$title</h3>
	$content
	<br><br>);
        return 1;
    }
}

#########
# return an href suitable for placing within inline text
#
#sub link {
#    my ($content_ref, $kw) = @_;
#    my $url = qq(javascript:void(window.open('$HELPVIEW?kw=$kw','$DB_TABLE','$WIN_ATTRIBS')););
#    $$content_ref .= qq(<a href="$url">$kw</a>);
#}

#########
# return html header
#
sub eh_header {
    my ($content_ref) = @_;
    my $searchbox = "";
    &searchbox(\$searchbox);
    $$content_ref .= qq(
    <table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr valign="middle">
	<td><a href="/"><img src="/gramene/images/icons/gramene_logo180.jpg" border="0" alt="Gramene"></a></td>
	<td ><img src="/gfx/eh-header.gif" alt="Help" width="200" height="40"></td>

      </tr>
      <tr valign="middle">
	<td align="center"><a href="/perl/helpview"><img src="/gfx/buttons/index.gif" alt="Index" hspace="2" vspace="2" width="70" height="25" border="0"></a></td>
	<td align="center" nowrap>${searchbox}</td>
      </tr>
      <tr valign="top">
	<td align="center" valign="top">
	  <a href="javascript:self.close();"><img src="/gfx/buttons/close.gif" border="0" alt="Close" width="70" height="25" hspace="2" vspace="2"></a>
	</td>
	<td  align="center">
	  <a href="javascript:history.back();"><img src="/gfx/buttons/prev.gif" border="0" width="70" height="25" alt="Back" hspace="2" vspace="2" align="absmiddle"></a>
	  <a href="javascript:history.forward();"><img src="/gfx/buttons/next.gif" border="0" width="70" height="25" alt="Forward" hspace="2" vspace="2" align="absmiddle"></a>
	  <br clear="all">
          <small>(help history)</small>
	</td>
      </tr>
      <tr><td colspan="2"><hr width="100%"></td></tr>
    </table>
    <table border="0" width="100%">
      <tr valign="top">
	<td><img src="/gfx/blank.gif" width="1" height="350" alt=""></td>
	<td width="100%">);
}

#########
# return html footer
#
sub eh_footer {
    my ($content_ref) = @_;
    $$content_ref .= qq(</td></tr></table>);
    $$content_ref .=  EnsWeb::make_cgi_footer();
}

#########
# returns href text
#
sub helplink {
    my ($kw) = @_;
    return qq(javascript:void(window.open('$HELPVIEW?se=1&kw=$kw','$DB_TABLE','$WIN_ATTRIBS')););
}

#########
# do mapping substitutions
#
sub mappings {
    my ($content_ref) = @_;
    $$content_ref =~ s/HELP_(.*?)_HELP/$HELPVIEW?se=1&kw=$1/mg;
    $$content_ref =~ s/IMG_(.*?)_IMG/$HELPGFX\/$1/mg;
}

1;
__END__
