
package EnsWeb;

#
# Things we need for the web site. A sort of grab bag at the moment
#

use strict;
use Apache::Constants qw(:response :methods :http);
use Apache 'exit';
use SiteDefs qw/:DEFAULT :URL $ENSEMBL_SERVERADMIN/;
use HelpView;
use Bio::EnsemblViewer::JSTools;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::DBAdaptor;
use Bio::EnsEMBL::DBSQL::Gene_Obj;
use Bio::SeqIO;
use Bio::EnsEMBL::EMBL_Dump;

use vars qw/@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS/;
require  Exporter;
@ISA     = qw(Exporter);
@EXPORT  = qw( get_locator ensembl_exception ensembl_exit);

my $hostname = $ENSEMBL_SERVER; 

###############################################################################
sub get_locator {

    (my $db_from_pathinfo = CGI::path_info())=~s!^/!!;

    my $dbname = $ENSEMBL_DB;
    my $dbpass = $ENSEMBL_DBPASS; 
    my $dbuser = $ENSEMBL_DBUSER;
    my $host   = $ENSEMBL_HOST;
    my $port   = $ENSEMBL_HOST_PORT;
    my $driver = $ENSEMBL_DRIVER;

    my $mapname = undef;

    if ($db_from_pathinfo){
        $dbname = $db_from_pathinfo;
    } else {
        $mapname = $ENSEMBL_MAP;
    }
    
    if (!$port){
	$port=3306;
    }

    #Oracle Insanity:
    #my $ENSEMBL_ORACLE_HOME='/oracle1/app/oracle/product/8.1.5';
    #my $ENSEMBL_TWO_TASK='P:rice';
    #my $ENSEMBL_TWO_TASK='T:localhost:rice';
    #$ENV{ORACLE_HOME} = $ENSEMBL_ORACLE_HOME if ($ENSEMBL_ORACLE_HOME) ;
    #$ENV{TWO_TASK} = $ENSEMBL_TWO_TASK if ($ENSEMBL_TWO_TASK) ;
    #$ENV{ORA_PIPES} = "V2";
    #$ENV{TNS_ADMIN}='/oracle1/app/oracle/product/8.1.5/network/admin';
    #$ENV{TNS_ADMIN}=$ENSEMBL_ORACLE_HOME.'/network/admin';


#    if (defined $ENV{HTTP_USER_AGENT} &&
#		$ENV{HTTP_USER_AGENT} =~ /Mac/ &&
#		$ENV{HTTP_USER_AGENT} =~ /MSIE/) {
#		$ENV{'NO_JS_MENUS'} = 1;
#    } else {
		undef($ENV{'NO_JS_MENUS'});
#    }

    my $debug=1;

    if( defined( $ENV{'MOD_PERL'} ) )
    {
      my $r;
      $r = Apache->request();
      #print STDERR "args:",$r->args,"\n";
      $debug=$1 if $r->args =~ /debug=(\d+)/;
    }

    return "Bio::EnsEMBL::DBSQL::DBAdaptor/host=$host;port=$port;dbname=$dbname;user=$dbuser;pass=$dbpass;perlonlyfeatures=0;mapdbname=$mapname;driver=$driver;debug=$debug";
}

###############################################################################
sub ensembl_exit {
#    my ($db_handle) = shift;
#
#    if (defined $db_handle){
#        $db_handle->deleteObj;
#    }
    
    if (defined $ENV{'MOD_PERL'} || $ENV{'GATEWAY_INTERFACE'} =~ /^CGI-Perl/){
	&Apache::exit;
    } else {
        exit;
    }
}

###############################################################################
#
#   Takes:
#	error message to display to user,
#	"real" error - i.e $@ or $! or whatever,
#	nomail - if this has a value, no email is sent.  Use for trivial "you
#	have forgotten to supply an argument" type errors.
#
###############################################################################
sub ensembl_exception {
    my ($user_error,$exception,$nomail) = @_;
   
    if($ENV{'GATEWAY_INTERFACE'} =~ /^CGI-Perl/){ # This is mod_perl so delegate error handling
        my $r = Apache->request();
        $r->err_header_out('ensembl_headers_out'=>1);
        $r->err_header_out('Ensembl-Error'=>$user_error);
	$r->err_header_out('Ensembl-Exception'=>$exception);
	$r->err_header_out('Ensembl-Server'=>$hostname);
	$r->err_header_out('Ensembl-Nomail'=>$nomail);
#	{
#	my $stuff='';
#	for(my $rr=$r;$rr;$rr=$rr->prev) {
#	    $stuff .= $rr->headers_in->{'Referer'} .":".$rr->the_request();
#	}
#	$r->err_header_out('Ensembl-Referer'=>$stuff);
#	}
	

	#########
	# ...redirect request to our error handler
	#
        $r->internal_redirect('/Crash');
	&Apache::exit;

    } else {
	#########
	# This is vanilla CGI - just barf
	#
        my $q = new CGI;
        $q->print (
		   h1('Gramene EnsEMBL Server Error'),
		   p(qq(Sorry, an error occured while the server was processing your request.
			Please email a report , quoting any additional information given below,
			along with the URL, to Ensembl server administrator using the link below.)),

		   p(b("The error was:")),
		   p(
		     blockquote({-class=> "error"},
				strong(pre($exception)),
				)
		     ),

		   p(b("URL:")),
		   p(
		     blockquote({-class=> "error"},
				strong($ENV{'REDIRECT_URL'}),
				)
		     ),

		   p(b("HTTP Status Code:")),
		   p(
		     blockquote({-class=> "error"},
				strong($ENV{'REDIRECT_STATUS'}), 
				)
		     ),

		   p(b("Request Method:")),
		   p(
		     blockquote({-class=> "error"},
				strong($ENV{'REDIRECT_REQUEST_METHOD'}), 
				)
		     ),
		   p(b("Query String (if known):")),
		   p(
		     blockquote({-class=> "error"},
				strong($ENV{'REDIRECT_QUERY_STRING'}),
				)
		     ),
		   
		   p(b("Error (if known):")),
		   p(
		     blockquote({-class=> "error"},
				strong($ENV{'REDIRECT_ERROR_NOTES'}),
				)
		     ),
		   
		   );
	exit;
    }
}
###############################################################################
# Beyond this point lies what used to be EnsWeb.pm
###############################################################################

#############################################################
# Construct the standard EnsEMBL page header
#############################################################
sub http_header {
  return &CGI::header();
}

#############################################################
sub cgi_header_info {

    my (%opts_ref)  = @_;
    my $script      = "";
    my $onload      = "";
    my $js_divs     = "";
    my $CSS         = "EnsEMBL.css";
    my $BASE        = "";

    $CSS = qq(EnsEMBL-mac.css) if($ENV{HTTP_USER_AGENT} =~ /Mac/);


    if(defined $opts_ref{'initfocus'}) {
	$script .= qq(
<script LANGUAGE="javascript" TYPE="text/javascript">
<!-- Hide script
function init()  {  
    document.feederform.q.focus();
    document.feederform.q.select();
    return (false);
}
  preloaders = new Array;
  preloaders[0] = new Image(1,1);
  preloaders[0].src = "/gfx/blank.gif";
  preloaders[1] = new Image(112,195);
  preloaders[1].src = "/gfx/gray.gif";
  preloaders[2] = new Image(112,195);
  preloaders[2].src = "/gfx/green.gif";
  preloaders[3] = new Image(16,16);
  preloaders[3].src = "/gfx/close.gif";
// End script hiding -->
</script>);

	$onload = qq( ONLOAD="init()" ); 
    }

    if(defined $opts_ref{'menus'}) {
	$script  .= &JSTools::js_menu_header();
	$js_divs .= &JSTools::js_menu_div();
    }

    if(defined $opts_ref{'tooltips'}) {
	$script  .= &JSTools::js_tooltip_header();
	$js_divs .= &JSTools::js_tooltip_div();
    }

    if(defined $opts_ref{'nocss'}) {
        $CSS = "";
    }

    if(defined $opts_ref{'basehref'}) {
        $BASE = qq(<BASE HREF="$opts_ref{'basehref'}">);
    }

#    my $scriptimg = "blank";
#    unless(defined $opts_ref{'noheadicon'}) {
#	my $tmp = $ENV{'SCRIPT_NAME'};
#    	$tmp =~ s/.*\/(.*?)$/$1/;
#	$scriptimg = $tmp if($tmp =~ /.*view$/);
#    }

        return (qq(
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<HTML>
 <HEAD>
  <TITLE>Gramene EnsEMBL Server</TITLE>
  <LINK REL="stylesheet" HREF="/$CSS">
  $BASE
  $script
 </HEAD>),$onload,
  $js_divs);

} # end of sub"

sub make_cgi_header {

    my ($head,$onload,$js_divs)=cgi_header_info(@_);
    

    my $gramene= $ENSEMBL_EXTERNAL_URLS->{'GRAMENE_HOME'};


	return $head.
qq(
<BODY $onload TEXT="#000000" BGCOLOR="#FFFFFF" topmargin="2" marginheight="2">
  $js_divs

<!-- begin header -->
<table width="100%" border="0" >
  <tr valign="bottom">
    <td width="150" align="center"><table border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td align="left"><A HREF="http://www.ensembl.org"><IMG SRC="/gramene/images/icons/e_with.png" BORDER="0" alt="Ensembl"></A></td>
        </tr>
    </table></td>
    <td align="left"><A HREF="$gramene/index.html">
    <IMG SRC="/gramene/images/icons/gramene_banner.gif" BORDER="0" alt=Gramene></a>
  </tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <TR>
    <td bgcolor="#e2e2ff" width="125" align="center"><A class="trailbar" HREF="$gramene/index.html"><small>Home</small></A></td>
    <TD nowrap class="violet1"><img src="/gfx/arrow.small.red.up.gif"></td>
  </TR>
  <tr>
    <td bgcolor="#f5f5ff" width="125"><img src="/gfx/blank.gif" width="125" height="1" alt=""></td>
    <td bgcolor="#f5f5ff" width="100%" colspan="17"><img src="/gfx/blank.gif" width="1" height="1" alt=""></td>
  </tr>
</TABLE>
<!-- end header -->

);
#<table width="100%" border="0" cellspacing="0" cellpadding="0">
#  <tr valign="bottom">
#    <td align="left"><A HREF="http://www.gramene.org"><IMG SRC="/gramene/images/icons/gramene_banner.gif" BORDER="0" alt=Gramene></a>
#    <td><table border="0" cellspacing="0" cellpadding="0">
#	<tr>
#	    <td align="left"><font size=6 color=#FF0000><i><strong>Built with</strong></i></font>
#	</tr>
#	<tr>
#	    <td align="left"><A HREF="http://www.ensembl.org"><IMG SRC="/gfx/ensembl-header1.gif" BORDER="0" width="286" height="40" alt="Ensembl"></A></td>
#	</tr>
#    </table></td>
#  </tr>
#</table>
    #<td nowrap class="violet1"><a class="trailbar" href="/~x-pan/gramene/cgi-perl/OracleDB.cgi"><small>DB Status</small></a></td>
    #<td nowrap class="violet1" width="100%"><img src="/gfx/arrow.small.red.up.gif"></td>

#    <td nowrap class="violet1"><img src="/gfx/arrow.small.red.up.gif"></td>
#    <td nowrap class="violet1"><a class="trailbar" href="/perl/blastview"><small>BLAST</small></a></td>
#    <td nowrap class="violet1"><img src="/gfx/arrow.small.red.up.gif"></td>
#    <td nowrap class="violet1"><a class="trailbar" href="/perl/diseaseview"><small>Disease Browser</small></a></td>
#    <td nowrap class="violet1"><img src="/gfx/arrow.small.red.up.gif"></td>
#    <td nowrap class="violet1"><a class="trailbar" href="/Docs/wiki/html/EnsemblDocs/"><small>Docs</small></a></td>
#    <td nowrap class="violet1"><img src="/gfx/arrow.small.red.up.gif"></td>
#    <td nowrap class="violet1"><a class="trailbar" href="/Docs/wiki/html/EnsemblDocs/DownloadEnsembl.html"><small>Download</small></a></td>

} # end of sub"

##############################################################################
sub make_cgi_footer {


    my ($footer);

    my ($sec, $min, $hour, $day, $month, $year) = localtime();
    $year  += 1900;
    $month += 1;

    $month = sprintf "%02d", $month;
    $day   = sprintf "%02d", $day;
    $sec   = sprintf "%02d", $sec;
    $min   = sprintf "%02d", $min;
    $hour  = sprintf "%02d", $hour;

    my $date = qq($year-$month-$day $hour:$min:$sec);

    $footer=qq(
    
<!-- begin footer -->

<TABLE BORDER="0" WIDTH="100%" cellpadding="0" cellspacing="0">
  <TR bgcolor="#f5f5ff" valign="middle">
    <TD>
      &nbsp;<I>Date : $date </I>
    </TD>
    <td><img src="/gfx/blank.gif" height="22" alt=""></td>
    <TD ALIGN="RIGHT">
        <I>
	<address><a href="mailto:$ENSEMBL_SERVERADMIN">$ENSEMBL_SERVERADMIN</a></address>
	</I>&nbsp;
    </TD>
  </TR>
</TABLE>
<br>
<!-- end footer -->

</BODY>
</HTML>

);
	#<A HREF="/feedback.html">$ENSEMBL_SERVERADMIN</A>
    
    return $footer;

} # end of sub"

###############################################################################
sub print_form {

    my ($q, $type) = @_;
    my $PREFIX = $ENSEMBL_PREFIX;
    my $PREFIXG = $ENSEMBL_PREFIXG;

    my $SELF   = $ENV{'SCRIPT_NAME'};
    $SELF =~ s|.*/(.*)|$1|;

    my $help_link = "";
    eval{
        $help_link = &HelpView::helplink($SELF);
        #print STDERR "$help_link\n";
    };
    if ($@){
        $help_link = "/perl/helpview";    
        print STDERR "Error in helpview link creation: $@\n";
    }

    $q    ||= "";
    $type ||= "all";

    my %sel = (
	"gene"        => '',
	"seqentry"    => '',
	"contig"      => '',
	"vcontig"     => '',
	#"domainentry" => '',
	"marker"      => '',
	"transcript"  => '',
	#"disease"     => '',
	#"chromosome"  => '',
	#"snp"	      => '',
	"all"	      => '',
#	"tcore"       => '',
        "protein"     => '',
	"clone"	      => '',
        "marker"     => '',
        "bacend"     => '',
        "zaceobject"   => '',

    );

    my %crappy_backwards_lookup = (
				   'all'        => 'All',
				   'gene'       => 'Gene',
				   'clone'      => 'Clone',
				   'contig'     => 'Contig',
				   #'peptide'    => 'Peptide',
				    'protein'    => 'Protein',
				   #'snp'        => 'SNP',
				   #'feature'    => 'Feature',
				   #'family'     => 'Protein Family',
				   'marker'     => 'Map Marker',
				   #'genscan'    => 'Genscan',
				   #'domainentry'     => 'Protein Domain',
				   #'transcript' => 'Transcript',
				   #'disease'    => 'Disease',
				   #'ipi'        => 'IPI',
				   #'chromosome' => 'Chromosome',
				   #'external'   => 'External',
				   'bacend'     => 'BAC End',
				   'zaceobject'   => 'Object in acedb',
				   );

    $sel{"$type"} = "selected";

    my $eg = '';
    if($type eq "seqentry") {
	$eg = qq([e.g. <A HREF="/perl/seqentryview?seqentry=AC084380">AC084380</A>: ]);

    } elsif($type eq "gene") {
        $eg = qq([e.g. <A HREF="/perl/geneview?gene=${PREFIXG}1001">${PREFIXG}1001</A>, <A HREF="/perl/geneview?gene=Q9FSJ3">Q9FSJ3</A>]);

    } elsif($type eq "vcontig") {
        $eg = qq([e.g.  <A HREF="/perl/contigview?clone=AP003702">AP003702</A>, <A HREF="/perl/contigview?clone=AC084380">AC084380</A>]);

    } elsif($type eq "contig") {
        $eg = qq([e.g.  <A HREF="/perl/contigview?contig=AP003701.001">AP003701.001</A>, <A HREF="/perl/contigview?contig=AP003405.002">AP003405.002</A>]);

    } elsif($type eq "clone") {
        $eg = qq([e.g.  <A HREF="/perl/contigview?clone=AP003702">AP003702</A>, <A HREF="/perl/contigview?clone=AC084380">AC084380</A>]);

    #} elsif($type eq "domainentry") {
        #$eg = qq([e.g. <A HREF="/perl/domainview?domainentry=IPR000504">IPR000504</A>]);

    } elsif($type eq "marker") {
        $eg = qq([e.g. <A HREF="/perl/markerview?marker=C101">C101</A>, <A HREF="/perl/markerview?marker=G232">G232</A>]);

#    } elsif($type eq "transcript") {
#        $eg = qq([e.g. <A HREF="/perl/transview?transcript=${PREFIX}T00000157775">${PREFIX}T00000157775</A>]);

#    } elsif($type eq "chromosome") {
#        $eg = qq([e.g. <A HREF="/perl/mapview?chr=1">1</A>, <A HREF="/perl/mapview?chr=12">12</A>, <A HREF="/perl/mapview?chr=X">X</A> ]);

#    } elsif($type eq "snp") {
#        $eg = qq([e.g. <A HREF="/perl/snpview?snp=20410">20410</A>]);
#
#    } elsif($type eq "disease") {
#        $eg = qq([e.g. <A HREF="/perl/diseaseview?disease=cancer">cancer</A>, <A HREF="/perl/diseaseview?disease=albinism">albinism</A>, <A HREF="/perl/diseaseview?disease=alzheimer">Alzheimer</A> ]);
#
#    } elsif($type eq "tcore") {
#        $eg = qq([e.g. <A HREF="/perl/tcoreview?tcore=22">22</A> ]);
#
#    } elsif($type eq "family") {
#        $eg = qq([e.g. <A HREF="/perl/familyview?family=ENSF00000001177">${PREFIX}F00000001177</A>]);

    } elsif ($type eq "bacend") {
        $eg = qq([e.g.  <A HREF="/perl/unisearch?type=bacend&q=AQ160873">AQ160873</A>, <A HREF="/perl/unisearch?type=bacend&q=AQ690296">AQ690296</A>]);
    } elsif($type eq "protein") {
        $eg = qq([e.g. <A HREF="/perl/protein_search?word=dehydrogenase">dehydrogenase</A>, <A HREF="/perl/protein_search?swall=Q9FSJ3">Q9FSJ3</A>]);
    
    } elsif($type eq "all") {
        #$eg = qq([e.g. <A HREF="/perl/${ENSEMBL_SEARCH}?q=cancer">cancer</A>, <A HREF="/perl/${ENSEMBL_SEARCH}?q=AC084380">AC084380</A>, <A HREF="/perl/${ENSEMBL_SEARCH}?q=D1S2806">D1S2806</A> ]);
        $eg = qq([e.g.  <A HREF="/perl/contigview?clone=AP003702">AP003702</A>, <A HREF="/perl/contigview?contig=AP003701.001">AP003701.001</A>, <A HREF="/perl/markerview?marker=C101">C101</A>]);

    }  

    my $content = "";
    $content .= qq(
	<form action="/perl/${ENSEMBL_SEARCH}" method="GET" name="feederform">
    <table cellspacing="0" cellpadding="0" border="0" align=center class="yellow1">
      <tr>
        <td colspan="5"><img src="/gfx/blank.gif" height="4" alt=""></td>
      </tr>
      <tr valign="middle">
        <td align="right" nowrap>
	  &nbsp;Find <select name="type" class="white" onchange="init()">
);

for my $idx (sort keys %crappy_backwards_lookup) {
    $content .= qq(<option $sel{$idx} value="$idx">$crappy_backwards_lookup{$idx}</option>\n);
}

$content .= qq(
          </select>
        </td>
        <td>
          <INPUT NAME="q" SIZE="24" value="$q">&nbsp;
        </td>
        <td>
          <INPUT TYPE="image" VALUE="Search" class="red2" src="/gfx/lookup.gif" border="0">&nbsp;
        </td>
	<td class="barial" nowrap width="100%">&nbsp;$eg&nbsp;</td>
	<td><A HREF="$help_link"><img border="0" align="right" alt="Click for help on $SELF" src="/gfx/helpview/help.gif"></A></td>
        <td nowrap>
          &nbsp;&nbsp;
        </td>
      </tr>
      <tr>
        <td colspan="5"><img src="/gfx/blank.gif" height="4" alt=""></td>
      </tr>
    </table>
	  </form>
);

return $content;

}

#############################################################
sub make_trace_header {

    my (%opts_ref)  = @_;
    my $script      = "";
    my $onload      = "";
    my $js_divs     = "";
    my $CSS         = "EnsEMBL.css";

    if(defined $opts_ref{'initfocus'}) {
		$script .= qq(
		<script LANGUAGE="javascript" TYPE="text/javascript">
		<!-- Hide script
		function init()  {  
		    document.feederform.traceform.focus();
		    return (false);
		}
		preloaders = new Array;
		preloaders[0] = new Image(1,1);
		preloaders[0].src = "/gfx/blank.gif";
		preloaders[1] = new Image(112,195);
		preloaders[1].src = "/gfx/gray.gif";
		preloaders[2] = new Image(112,195);
		preloaders[2].src = "/gfx/green.gif";
		preloaders[3] = new Image(16,16);
		preloaders[3].src = "/gfx/close.gif";
		// End script hiding -->
		</script>);

		$onload = " ONLOAD=\"init()\" "; 
    }

    if(defined $opts_ref{'nocss'}) {
    		$CSS = "";
    }

    my $scriptimg = "blank";
    unless(defined $opts_ref{'noheadicon'}) {
	my $tmp = $ENV{'SCRIPT_NAME'};
    	$tmp =~ s/.*\/(.*?)$/$1/;
	$scriptimg = $tmp if($tmp =~ /.*view$/);
    }
	return <<EOS;
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<HTML>
 <HEAD>
  <TITLE>Gramene EnsEMBL Server</TITLE>
  <BASE HREF="http://www.ensembl.org">   
  <LINK REL="stylesheet" HREF="/$CSS">
  $script
 </HEAD>
<BODY $onload TEXT="#000000" BGCOLOR="#FFFFFF" topmargin="2" marginheight="2">
<!-- begin header -->
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr valign="bottom">
    <td align="left"><A HREF="http://trace.ensembl.org/"><IMG SRC="/gfx/ensembl-header1.gif" BORDER="0" width="286" heigh ="40" alt="Ensembl Trace Server"></A><img src="/gfx/traceview.gif" width="120" height="40" alt=""></td>
    <td align="right" width="77"><A HREF="http://www.sanger.ac.uk/"><IMG SRC="/gfx/sanger.gif" BORDER="0" width="77" height="40" alt="The Sanger Centre"></A></td>
    <td align="right" width="77"><A HREF="http://www.ebi.ac.uk/"><IMG SRC="/gfx/ebi.gif" BORDER="0" width="77" height="40" alt="The European Bioinformatics Institute"></A></td>
  </tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td bgcolor="#f5f5ff" width="125"><img src="/gfx/blank.gif" width="125" height="1" alt=""></td>
    <td bgcolor="#f5f5ff" width="100%" colspan="17"><img src="/gfx/blank.gif" width="1" height="1" alt=""></td>
  </tr>
</TABLE>
<!-- end header -->

    <table cellspacing="0" cellpadding="0" border="0" width="100%" class="yellow1">
      <tr>
        <td colspan="5"><img src="/gfx/blank.gif" height="4" alt=""></td>
      </tr>
      <tr>
	<form action="http://trace.ensembl.org/perl/traceview2" method="POST" name="traceform">
        <td align="right" nowrap>
	  &nbsp;Search for  <select name="tracedb" class="white" onchange="init()">
            			<option value="all" selected>Mouse</option>
         </select>trace file &nbsp;&nbsp;
        </td>
        <td>
          <INPUT NAME="traceid" SIZE="24" value="">&nbsp;
        </td>
        <td>
          <INPUT TYPE="image" VALUE="Search" class="red2" src="/gfx/lookup.gif" border="0">&nbsp;
        </td>
	<td class="barial" nowrap width="100%">&nbsp;
		[<B><I><small>eg. mk2A-a76f05.q1cSCF</small></I></B>]&nbsp;
	</td>
	<td valign="middle"><A HREF="javascript:void(window.open('/perl/helpview?se=1&kw=traceview','helpview','width=400,height=500,resizable,scrollbars'));"><img border="0" align="right" alt="Click for help on traceview" src="/gfx/helpview/help.gif"></A></td>
        <td>
	  &nbsp;
        </td>
        </form>
      </tr>
      <tr>
        <td colspan="5"><img src="/gfx/blank.gif" height="4" alt=""></td>
      </tr>
    </table>

<BR><BR>

EOS

} # end of sub"

1;

