package Bump;
###############################################################################
#
#   NAME:	    Bump.pm
#
#   DESCRIPTION:    Bumping code.  Pass in the start and end of the thing you
#		    want bumping, the length of the thing to bump against, and
#		    a reference to an array.  The array will be modified by
#		    this subroutine, to maintain persistence.
#
#   HISTORY:	    2001-01-05	jws	original version
#
###############################################################################

use strict;
use Carp;
#use base qw( Exporter );

#@EXPORT_OK = qw( bump_row );

#------------------
sub bump_row {
#------------------
    my($start,$end,$bit_length,$bit_array)=@_;
    my $row=0;
    my $len=$end-$start+1;

    if( $len <= 0 || $bit_length <= 0 ) {
       carp("We've got a bad length of $len or $bit_length from $start-$end in Bump. Probably you haven't flipped on a strand");
    }

    #######################
    # make incoming bitmap
    #######################
    my $element='0' x $bit_length;
    
    substr($element, $start,$len)='1' x $len;
    
    
    LOOP:{
        if($$bit_array[$row]){
            #################################################################
            # logical AND the row with the element.  If it equals zero, then
            # they don't overlap.  If not, then they do, so try another row.
            #################################################################
            if (($$bit_array[$row] & $element)==0){
                ############################################
                # no overlap, so combine the two with an OR
                ############################################
                $$bit_array[$row]=($$bit_array[$row] | $element);
            }
            else {
                    $row++;
                    redo LOOP;
            }
	}
        else{
            #############################
            # new row, so row=element...
            #############################
            $$bit_array[$row]=$element;
        }
    }
    return $row;
}


# THE END!
1;
