package WebUserConfig;
use strict;
use CGI qw(:cookie);
use ColourMap;
use Exporter;
use TextHelper;
use vars qw(@ISA);
use constant CONFIG_COOKIE_NAME    => 'ensemblconfig';
use constant CONFIG_COOKIE_EXPIRES => '+10y';
use Data::Dumper;
use Storable qw(freeze thaw);

@ISA = qw(Exporter);

#########
# 'general' settings contain defaults.
# 'user' settings are restored from cookie if available
# 'general' settings are overridden by 'user' settings
#

sub new {
    my ($class, $cgi, $script) = @_;

    my $cmap = new ColourMap; 

    my $self = {
	'_cgi'        => $cgi || new CGI,
	'_script'     => $script,
	'_colourmap'  => $cmap,
	'_texthelper' => new TextHelper,
	'general' => {
	    'contigviewtop' => {    #replaced marker_label and marker by gramark_label and gramark
		'_artefacts' => [qw( contig gene gramark_label gene_label gramark scalebar bacend multi_est single_est ssr ssr_label hordeum_est triticum_est mays_est sorghum_bicolor_est cdo_bcd_marker cdo_bcd_marker_label maize_unigene_cluster tigr_maize_gi bgi_indica_est bgi_indica_cluster oryza_cds tigr_oryza_gi)], #chr_band 
#		'_options'  => [qw(on off)],
		'_options'  => [],
		'_names'     => {
		    'on'      => 'activate',
		    'col'     => 'colour',
		    'dep'     => 'depth',
		},
		#dep => '074' = default to compressed
		'_settings' => {
		    'width'     => 700,
		    'default_vc_size'	    => 50000,
		    'default_top_vc_size'   => 200000,
		    'imagemap'   => 1,
		    'bgcolor'   => $cmap->id_by_name('yellow1'),
		    'bgcolour1' => $cmap->add_hex('yellow1'),
		    'bgcolour2' => $cmap->add_hex('yellow1'),
		    #'bgcolour1' => $cmap->add_hex('ffffcc'),
		    #'bgcolour2' => $cmap->add_hex('ffffdd'),
		},
		'contig' => {
		    'on'  => "on",
		    'pos' => '0',
		    'col' => $cmap->id_by_name('black'),
		},
		'bacend' => {
		    'on'  => "on",
		    'pos' => '2',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('pine'),
		    'dep' => '6',
		    'src' => 'all', # all|sptr|...
		},
		'multi_est' => {
		    'on'  => "on",
		    'pos' => '15',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('red'),
		    'dep' => '074',
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice Multi-Exon EST',
		    'feature' => 'multi_est',
		},
		'single_est' => {
		    'on'  => "on",
		    'pos' => '16',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('red'),
		    'dep' => '074',
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice Single-Exon EST',
		    'feature' => 'single_est',
		},
		'tigr_oryza_gi' => {
		    'on'  => "on",
		    'pos' => '17',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('peach'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'TIGR Oryza Gene Index',
		    'feature' => 'tigr_oryza_gi',
		},
		'bgi_indica_cluster' => {
		    'on'  => "on",
		    'pos' => '18',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('orange'),
		    'dep' => '074',
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'BGI Indica Cluster',
		    'feature' => 'bgi_indica_cluster',
		},
		'bgi_indica_est' => {
		    'on'  => "on",
		    'pos' => '19',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('gold3'),
		    'dep' => '074',
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'BGI Indica EST',
		    'feature' => 'bgi_indica_est',
		},
		'oryza_cds' => {
		    'on'  => "on",
		    'pos' => '20',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('cyan'),
		    'dep' => '074',
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice CDS',
		    'feature' => 'oryza_cds',
		},
		'hordeum_est' => {
		    'on'  => "on",
		    'pos' => '26',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('darkorange'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Hordeum EST',
		    'feature' => 'hordeum_est',
		},
		'triticum_est' => {
		    'on'  => "on",
		    'pos' => '27',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('orange'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Triticum EST',
		    'feature' => 'triticum_est',
		},
		'maize_unigene_cluster' => {
		    'on'  => "on",
		    'pos' => '23',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('orange'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Unigene Maize Cluster',
		    'feature' => 'maize_unigene_cluster',
		},
		'tigr_maize_gi' => {
		    'on'  => "on",
		    'pos' => '24',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('peach'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'TIGR Maize Gene Index',
		    'feature' => 'tigr_maize_gi',
		},
		'mays_est' => {
		    'on'  => "on",
		    'pos' => '25',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('gold2'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Zea mays EST',
		    'feature' => 'mays_est',
		},

		'sorghum_bicolor_est' => {
		    'on'  => "on",
		    'pos' => '28',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('goldenrod'),
		    'dep' => '074',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Sorghum bicolor EST',
		    'feature' => 'sorghum_bicolor_est',
		},
		'gramark' => {
		    'on'  => "on",
		    'pos' => '3',
		    'col' => $cmap->id_by_name('magenta'),
		    'glyph' => 'gmap',
		    'dep' => '6',
		    'text' => 'Markers on Rice Maps',
		    'database' => 'MarkerTag',
		},
		'gramark_label' => {
		    'on'      => "on",
		    'pos'     => '4',
		    'col' => $cmap->id_by_name('black'),
		    'glyph' => 'gmap_label',
		    'dep' => '6',
		    'text' => 'Marker Label',	#just for config
		    'database' => 'MarkerTag',
		},
		'ssr' => {
		    'on'  => "on",
		    'pos' => '5',
		    'col' => $cmap->id_by_name('cyan'),
		    'glyph' => 'gmap',
		    'dep' => '6',
		    'text' => 'SSR Marker',
		    'database' => 'ssr',
		},
		'ssr_label' => {
		    'on'      => "on",
		    'pos'     => '6',
		    'col' => $cmap->id_by_name('black'),
		    'glyph' => 'gmap_label',
		    'dep' => '6',
		    'database' => 'ssr',
		},
#		'cdo_bcd_marker' => {
#		    'on'  => "on",
#		    'pos' => '7',
#		    'col' => $cmap->id_by_name('gold3'),
#		    'glyph' => 'gmap',
#		    'dep' => '6',
#		    'text' => 'Oat&Barley Markers',
#		    'database' => 'cdo_bcd',
#		},
#		'cdo_bcd_marker_label' => {
#		    'on'      => "on",
#		    'pos'     => '8',
#		    'col' => $cmap->id_by_name('black'),
#		    'glyph' => 'gmap_label',
#		    'dep' => '6',
#		    'database' => 'cdo_bcd',
#		},
		'gene' => {
		    'on'      => "on",
		    'pos'     => '10',
		    'src'     => 'all', # 'ens' or 'all'
		    'known'   => $cmap->id_by_name('rust'),
		    'unknown' => $cmap->id_by_name('black'),
		    'ext'     => $cmap->id_by_name('pine'),
		    'hi'      => $cmap->id_by_name('green'),
		    'dep' 	  => '6',
		},
		'gene_label' => {
		    'on'      => "on",
		    'pos'     => '11',
		    'src'     => 'all', # 'ens' or 'all'
		    'known'   => $cmap->id_by_name('rust'),
		    'unknown' => $cmap->id_by_name('black'),
		    'ext'     => $cmap->id_by_name('pine'),
		    'hi'      => $cmap->id_by_name('green'),
		    'dep'     => '6',
		},
		'scalebar' => {
		    'on'  => "on",
		    'pos' => '1',
		    'col' => $cmap->id_by_name('black'),
		    'str' => 'f',
		    'abbrev' => 'on',
		},
#		'chr_band' => {
#		    'on'  => "on",
#		    'pos' => '7',
#		},
	    },
	    'contigviewbottom' => {
		'_artefacts' => [qw( stranded_contig ruler transcript cpg gcplot repeat gramark ssr scalebar multi_est single_est bacend hordeum_est triticum_est mays_est sorghum_bicolor_est cdo_bcd_marker maize_unigene_cluster tigr_maize_gi bgi_indica_est bgi_indica_cluster oryza_cds tigr_oryza_gi)],  #tilepath snp trace genscan trna  unigene sptr marker 
		'_options'  => [qw(on pos col hi low dep str src known unknown ext)],
		'_names'     => {
		    'on'      => 'activate',
		    'pos'     => 'position',
		    'col'     => 'colour',
		    'dep'     => 'depth',
		    'str'     => 'strand',
		    'hi'      => 'highlight colour',
		    'src'     => 'source',
		    'known'   => 'known colour',
		    'unknown' => 'unknown colour',
		    'ext'     => 'external colour',
		},
		'_settings' => {
		    'width'   => 700,
		    'imagemap'   => 1,
		    'bgcolor' => $cmap->id_by_name('yellow1'),
		    'bgcolour1' => $cmap->add_hex('ffffcc'),
		    'bgcolour2' => $cmap->add_hex('ffffdd'),
		},
#		'eponine' => {
#		    'on'  => "on",
#		    'pos' => '8',
#		    'col' => $cmap->id_by_name('green'),
#		},
		'stranded_contig' => {
		    'on'  => "on",
		    'pos' => '0',
#		    'col' => $cmap->id_by_name('black'),
		},
		'ruler' => {
		    'on'  => "on",
		    'pos' => '31',
		    'col' => $cmap->id_by_name('black'),
		},
#		'trna' => {
#		    'on'  => "on",
#		    'pos' => '9',
#		    'str'     => 'b',
#		    'col' => $cmap->id_by_name('gold2'),
#		},
		'transcript' => {
		    'on'      => "on",
		    'pos'     => '1',
		    'str'     => 'b',
		    'src'     => 'all', # 'ens' or 'all'
		    'known'   => $cmap->id_by_name('rust'),
		    'unknown' => $cmap->id_by_name('black'),
		    'ext'     => $cmap->id_by_name('pine'),
		    'pseudo'  => $cmap->id_by_name('grey2'),
		    'hi'      => $cmap->id_by_name('green'),
		},
#		'sptr' => {
#		    'on'  => "on",
#		    'pos' => '9',
#		    'col' => $cmap->id_by_name('orange'),
#		    'src' => 'all', # all|sptr|...
#		    'dep' => '6',
#		    'str' => 'b',
#		},
		'bacend' => {
		    'on'  => "on",
		    'pos' => '8',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('pine'),
		    'dep' => '74',	#since 37 is largest known legit & 111 is smallest known bogus
		    'src' => 'all', # all|sptr|...
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
		},
		'multi_est' => {
		    'on'  => "on",
		    'pos' => '10',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('red'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice Multi-Exon EST',
		    'feature' => 'multi_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
		},
		'single_est' => {
		    'on'  => "on",
		    'pos' => '11',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('red'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice Single-Exon EST',
		    'feature' => 'single_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
		},
		'tigr_oryza_gi' => {
		    'on'  => "on",
		    'pos' => '12',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('gold3'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'TIGR Oryza Gene Index',
		    'feature' => 'tigr_oryza_gi',
		    'linkout'=>{TIGR => 'http://www.tigr.org/docs/tigr-scripts/nhgi_scripts/tc_report.pl?tc=FEATUREID&species=Rice'},
		},
		'bgi_indica_cluster' => {
		    'on'  => "on",
		    'pos' => '13',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('peach'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'BGI EST Cluster',
		    'feature' => 'bgi_indica_cluster',
		    'linkout'=>{'BGI'=>'http://btn.genomics.org.cn/rice/index.php'},
		},
		'bgi_indica_est' => {
		    'on'  => "on",
		    'pos' => '14',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('gold3'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'BGI EST',
		    'feature' => 'bgi_indica_est',
		    'linkout'=>{'BGI'=>'http://btn.genomics.org.cn/rice/index.php'},
		},
		'oryza_cds' => {
		    'on'  => "on",
		    'pos' => '15',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('cyan'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Rice CDS',
		    'feature' => 'oryza_cds',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
				},
		'hordeum_est' => {
		    'on'  => "on",
		    'pos' => '25',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('darkorange'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Hordeum EST',
		    'feature' => 'hordeum_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID',
				'GrainGenes'=>'http://www.graingenes.org/cgi-bin/WebAce/webace?db=graingenes&class=Sequence&object=FEATUREID&display=text&.submit=show+object%28s%29&Condition='},
		},
		'triticum_est' => {
		    'on'  => "on",
		    'pos' => '26',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('orange'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Triticum EST',
		    'feature' => 'triticum_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID',
				'GrainGenes'=>'http://www.graingenes.org/cgi-bin/WebAce/webace?db=graingenes&class=Sequence&object=FEATUREID&display=text&.submit=show+object%28s%29&Condition='},
		 },
		'maize_unigene_cluster' => {
		    'on'  => "on",
		    'pos' => '22',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('orange'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Unigene Maize Cluster',
		    'feature' => 'maize_unigene_cluster',
		    'linkout'=>{MaizeDB => 'http://www.agron.missouri.edu/index.html'},
		},
		'tigr_maize_gi' => {
		    'on'  => "on",
		    'pos' => '23',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('peach'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'TIGR Maize Gene Index',
		    'feature' => 'tigr_maize_gi',
		    'linkout'=>{TIGR => 'http://www.tigr.org/docs/tigr-scripts/nhgi_scripts/tc_report.pl?tc=FEATUREID&species=Maize'},
		},
		'mays_est' => {
		    'on'  => "on",
		    'pos' => '28',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('gold2'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Zea mays EST',
		    'feature' => 'mays_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
		},
		'sorghum_bicolor_est' => {
		    'on'  => "on",
		    'pos' => '25',
		    'str' => 'r',
		    'col' => $cmap->id_by_name('goldenrod'),
		    'dep' => '74',	
		    'src' => 'all', # all|sptr|...
		    'glyph' => 'est',
		    'text' => 'Sorghum bicolor EST',
		    'feature' => 'sorghum_bicolor_est',
		    'linkout'=>{GenBank => 'http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?db=n&form=1&field=Sequence+ID&term=FEATUREID'},
		},
		'gramark' => {
		    'on'  => "on",
		    'pos' => '7',
		    'col' => $cmap->id_by_name('magenta'),
		    'src' => 'all', # all|sptr|...
		    'dep' => '6',
		    'str' => 'b',
		    'glyph' => 'gmap',
		    'text' => 'Markers on Rice Maps',
		    'database' => 'MarkerTag',
		},
		'ssr' => {
		    'on'  => "on",
		    'pos' => '6',
		    'col' => $cmap->id_by_name('cyan'),
		    'src' => 'all', # all|sptr|...
		    'dep' => '6',
		    'str' => 'b',
		    'glyph' => 'gmap',
		    'text' => 'SSR Marker',
		    'database' => 'ssr',
		},
		'cdo_bcd_marker' => {
		    'on'  => "on",
		    'pos' => '4',
		    'col' => $cmap->id_by_name('gold3'),
		    'glyph' => 'gmap',
		    'dep' => '6',
		    'text' => 'Oat&Barley Markers',
		    'database' => 'cdo_bcd',
		},
#		'unigene' => {
#		    'on'  => "on",
#		    'pos' => '5',
#		    'col' => $cmap->id_by_name('red'),
#		    'src' => 'all', # all|sptr|...
#		    'dep' => '6',
#		    'str' => 'b',
#		},
#		'genscan' => {
#		    'on'  => "on",
#		    'pos' => '3',
#		    'col' => $cmap->id_by_name('lightseagreen'),
#		    'dep' => '6',
#		    'str' => 'b',
#		},
#		'marker' => {
#		    'on'  => "on",
#		    'pos' => '9',
#		    'col' => $cmap->id_by_name('magenta'),
#		},
		'cpg' => {
		    'on'  => "on",
		    'pos' => '36',
		    'str'     => 'b',
		    'col' => $cmap->id_by_name('purple1'),
		},
#		'snp' => {
#		    'on'  => "on",
#		    'pos' => '13',
#		    'col' => $cmap->id_by_name('blue'),
#		},
#		'trace' => {
#		    'on'  => "on",
#		    'pos' => '15',
#		    'col' => $cmap->id_by_name('pink'),
#		    'str' => 'b',
#		},
		'repeat' => {
		    'on'  => "on",
		    'pos' => '33',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('grey3'),
		},
		'scalebar' => {
		    'on'  => "on",
		    'pos' => '34',
		    'col' => $cmap->id_by_name('black'),
		    'str' => 'b',
		    'subdivs' => 'on',
		    'abbrev' => 'on',
		},
#		'tilepath' => {
#		    'on'  => "on",
#		    'pos' => '23',
#		    'col1' => $cmap->id_by_name('red'),
#		    'col2' => $cmap->id_by_name('orange'),
#		    'lab1' => $cmap->id_by_name('white'),
#		    'lab2' => $cmap->id_by_name('black'),
#		    'str' => 'r',
#		    'dep' => '6',
#		},
		'gcplot'  => {
		    'on'  => "on",
		    'pos' => '35',
		    'hi'  => $cmap->id_by_name('black'),
		    'low' => $cmap->id_by_name('black'),
		},
	    },
	    'seqentryview' => {
		'_artefacts' => [qw( stranded_contig ruler transcript cpg repeat gramark ssr marker bacend scalebar)], #snp trace trna sptr unigene genscan 
		'_options'  => [qw(on pos col hi low dep str src known unknown ext)],
		'_names'     => {
		    'on'      => 'activate',
		    'pos'     => 'position',
		    'col'     => 'colour',
		    'dep'     => 'bumping depth',
		    'str'     => 'strand',
		    'hi'      => 'highlight colour',
		    'src'     => 'source',
		    'known'   => 'known colour',
		    'unknown' => 'unknown colour',
		    'ext'     => 'external colour',
		},
		'_settings' => {
		    'width'   => 700,
		    'imagemap'   => 1,
		    'bgcolor' => $cmap->id_by_name('yellow1'),
		    'bgcolour1' => $cmap->add_hex('ffffcc'),
		    'bgcolour2' => $cmap->add_hex('ffffdd'),
		},
		'stranded_contig' => {
		    'on'  => "on",
		    'pos' => '0',
		    'col' => $cmap->id_by_name('black'),
		},
		'ruler' => {
		    'on'  => "on",
		    'pos' => '30',
		    'col' => $cmap->id_by_name('black'),
		},
		'bacend' => {
		    'on'  => "on",
		    'pos' => '1',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('pine'),
		    'dep' => '6',
		    'src' => 'all', # all|sptr|...
		},
#		'trna' => {
#		    'on'  => "on",
#		    'pos' => '9',
#		    'str'     => 'b',
#		    'col' => $cmap->id_by_name('gold2'),
#		},
		'transcript' => {
		    'on'      => "on",
		    'pos'     => '2',
		    'str'     => 'b',
		    'src'     => 'all', # 'ens' or 'all'
		    'known'   => $cmap->id_by_name('rust'),
		    'unknown' => $cmap->id_by_name('black'),
		    'ext'     => $cmap->id_by_name('pine'),
		    'hi'      => $cmap->id_by_name('green'),
		},
#		'sptr' => {
#		    'on'  => "on",
#		    'pos' => '5',
#		    'col' => $cmap->id_by_name('orange'),
#		    'src' => 'all', # all|sptr|...
#		    'dep' => '6',
#		    'str' => 'b',
#		},
		'gramark' => {
		    'on'  => "on",
		    'pos' => '5',
		    'col' => $cmap->id_by_name('magenta'),
		    'src' => 'all', # all|sptr|...
		    'dep' => '6',
		    'str' => 'b',
		    'glyph' => 'gmap',
		    'text' => 'Marker Sequence Tag',
		    'database' => 'MarkerTag',
		},
		'ssr' => {
		    'on'  => "on",
		    'pos' => '5',
		    'col' => $cmap->id_by_name('cyan'),
		    'glyph' => 'gmap',
		    'src' => 'all', # all|sptr|...
		    'dep' => '6',
		    'str' => 'b',
		    'glyph' => 'gmap',
		    'text' => 'SSR Marker',
		    'database' => 'ssr',
		},
#		'unigene' => {
#		    'on'  => "on",
#		    'pos' => '5',
#		    'col' => $cmap->id_by_name('red'),
#		    'src' => 'all', # all|sptr|...
#		    'dep' => '6',
#		    'str' => 'b',
#		},
#		'genscan' => {
#		    'on'  => "on",
#		    'pos' => '5',
#		    'col' => $cmap->id_by_name('lightseagreen'),
#		    'dep' => '6',
#		    'str' => 'b',
#		},
#		'marker' => {
#		    'on'  => "on",
#		    'pos' => '5',
#		    'col' => $cmap->id_by_name('magenta'),
#		},
		'cpg' => {
		    'on'  => "on",
		    'pos' => '9',
		    'str'     => 'b',
		    'col' => $cmap->id_by_name('purple1'),
		},
#		'snp' => {
#		    'on'  => "on",
#		    'pos' => '10',
#		    'col' => $cmap->id_by_name('blue'),
#		},
#		'trace' => {
#		    'on'  => "on",
#		    'pos' => '11',
#		    'col' => $cmap->id_by_name('pink'),
#		    'str' => 'b',
#		},
		'repeat' => {
		    'on'  => "on",
		    'pos' => '12',
		    'str'     => 'r',
		    'col' => $cmap->id_by_name('grey3'),
		},
		'scalebar' => {
		    'on'  => "on",
		    'pos' => '13',
		    'col' => $cmap->id_by_name('black'),
		    'str' => 'b',
		    'subdivs' => 'on',
		    'abbrev' => 'on',
		},
	    },
	    'geneview' => {
		'_artefacts' => [qw(transcript )], #snp 
		'_options'  => [qw(pos col known unknown)],
		'_settings' => {
		    'width'     => 250,
		    'bgcolor'   => $cmap->id_by_name('yellow1'),
		    'bgcolour1' => $cmap->add_hex('yellow1'),
		    'bgcolour2' => $cmap->add_hex('yellow1'),
		    #'bgcolour1' => $cmap->add_hex('ffffcc'),
		    #'bgcolour2' => $cmap->add_hex('ffffdd'),
		},
		'transcript' => {
		    'on'      => "on",
		    'pos'     => '1',
		    'str'     => 'b',
		    'src'     => 'all', # 'ens' or 'all'
		    'known'   => $cmap->id_by_name('rust'),
		    'unknown' => $cmap->id_by_name('black'),
		    'ext'     => $cmap->id_by_name('pine'),
		    'hi'      => $cmap->id_by_name('green'),
		},
#		'snp' => {
#		    'on'  => "on",
#		    'pos' => '3',
#		    'col' => $cmap->id_by_name('blue'),
#		},
	    },
	    'chromosome' => {
		'_artefacts' => [qw(ideogram )],
		'_options'  => [],
		'_settings' => {
		    'width'     => 700,
		    'bgcolor'   => $cmap->id_by_name('yellow1'),
		    'bgcolour1' => $cmap->add_hex('yellow1'),
		    'bgcolour2' => $cmap->add_hex('yellow1'),
		    #'bgcolour1' => $cmap->add_hex('ffffcc'),
		    #'bgcolour2' => $cmap->add_hex('ffffdd'),
		},
		'ideogram' => {
		    'on'  => "on",
		    'pos' => '6',
		},
	    },
	    'transview' => {
		'_artefacts' => [qw(transcript )],	# sptr
		'_options'   => [qw(on pos col hi dep str known unknown)],
		'_names'     => {
		    'on'  => 'activate',
		    'pos' => 'position',
		    'col' => 'colour',
		    'dep' => 'bumping depth',
		    'str' => 'strand',
		    'hi'  => 'highlight colour',
		},
		'_settings' => {
		    'width'  => 700,
		    'bgcolor' => $cmap->id_by_name('white'),
		},
		'transcript' => {
		    'on'  => "on",
		    'pos' => '1',
		    'known' => $cmap->id_by_name('black'),
		    'unknown' => $cmap->id_by_name('rust'),
		    'dep' => '6',
		    'str' => 'b',
		    'hi'  => $cmap->id_by_name('green'),
		},
#		'sptr' => {
#		    'on'  => "on",
#		    'pos' => '2',
#		    'col' => $cmap->id_by_name('green'),
#		    'dep' => '6',
#		    'str' => 'b',
#		},
	    },
	    'protview' => {
		'_artefacts' => [qw(prot_scalebar protein pfam prints prosite coils low_complex signal_peptide transmembrane prot_snp)],
		'_options'   => [qw(on pos col hi known unknown)],
		'_names'     => {
		    'on'  => 'activate',
		    'pos' => 'position',
		    'col' => 'colour',
		    'dep' => 'bumping depth',
		    'str' => 'strand',
		    'hi'  => 'highlight colour',
		},
		'_settings' => {
		    'width'   => 600,
		    'bgcolor' => $cmap->id_by_name('white'),
		},
		'prot_scalebar' => {
		    'on'  => "on",
		    'pos' => '0',
		    'col' => $cmap->id_by_name('black'),
		},
		'protein' => {
		    'on'      => "on",
		    'pos'     => '1',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('purple1'),
		    'dep' => '6',
		},
		'intron' => {
		    'on'      => "on",
		    'pos'     => '3',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('purple1'),
		    'dep' => '6',
		},
		'coils' => {
		    'on'      => "on",
		    'pos'     => '5',
		    'dep'     => '0',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('darkblue'),
		    'dep' => '6',
		},
		'low_complex' => {
		    'on'      => "on",
		    'pos'     => '7',
		    'dep'     => '0',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('gold2'),
		    'dep' => '6',
		},
		'signal_peptide' => {
		    'on'      => "on",
		    'pos'     => '9',
		    'dep'     => '6',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('pink'),
		    'dep' => '6',
		},
		'transmembrane' => {
		    'on'      => "on",
		    'pos'     => '11',
		    'dep'     => '6',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('pine'),
		    'dep' => '6',
		},
		'pfam' => {
		    'on'      => "on",
		    'pos'     => '13',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('grey1'),
		    'dep' 	  => '6',
		},
		'prosite' => {
		    'on'      => "on",
		    'pos'     => '15',
		    'dep'     => '0',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('orange'),
		    'dep' => '6',
		},
		'prints' => {
		    'on'      => "on",
		    'pos'     => '17',
		    'dep'     => '6',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('rust'),
		},
		'prot_snp' => {
		    'on'      => "on",
		    'pos'     => '19',
		    'dep'     => '6',
		    'hi'      => $cmap->id_by_name('green'),
		    'col'     => $cmap->id_by_name('contigblue1'),
		},
		'pdb' => {
		    'on'      => "on",
		    'pos'     => '21',
		    'dep'     => '6',
		    'hi'      => $cmap->id_by_name('blue'),
		    'col'     => $cmap->id_by_name('blue'),
		},
	    },
	},
	'user' => {
	},
    };

    bless($self, $class);

    $self->foo_load();

    return $self;
}

sub foo_load {
    my ($self) = @_;

    for my $section ($self->sections()) {

	my $cookie = $self->{'_cgi'}->cookie(-name => &CONFIG_COOKIE_NAME . $section);

	$self->{'user'}->{$section} = &Storable::thaw($cookie) if(defined $cookie);

    }
}

sub save {
    my ($self) = @_;

    my $cookie_list = [];
    for my $section ($self->sections()) {
	next unless (defined $self->{'user'}->{$section});

	my $cookie = $self->{'_cgi'}->cookie(
	    -name    => &CONFIG_COOKIE_NAME . $section,
	    -value   => &Storable::freeze($self->{'user'}->{$section}),
	    -expires => &CONFIG_COOKIE_EXPIRES,
	    -path    => "/perl/",
	);
	push @{$cookie_list}, $cookie;
    }
    return $cookie_list;
}

sub reset {
    my ($self, $section_to_expire) = @_;

    my $cookie_list = [];
    for my $section ($self->sections()) {
	next unless (defined $self->{'user'}->{$section});

	my $cookie;
	if($section eq $section_to_expire) {
	    $cookie = $self->{'_cgi'}->cookie(
					      -name    => &CONFIG_COOKIE_NAME . $section,
					      -value   => "",
					      -expires => "-10d",
					      );
	    delete($self->{'user'}->{$section});

	} else {
	    $cookie = $self->{'_cgi'}->cookie(
					      -name    => &CONFIG_COOKIE_NAME . $section,
					      -value   => &Storable::freeze($self->{'user'}->{$section}),
					      -expires => &CONFIG_COOKIE_EXPIRES,
					      );
	}
	push @{$cookie_list}, $cookie;
    }
    return $cookie_list;
}

sub dump {
    my ($self) = @_;
    print STDERR Dumper($self);
}

#########
# return supported scripts
#
sub sections {
    my ($self) = @_;
    return (keys %{$self->{'general'}});
}

#########
# return artefacts on scripts
#
sub subsections {
    my ($self, $section) = @_;
    return unless(defined $self->{'general'}->{$section});
    return @{$self->{'general'}->{$section}->{'_artefacts'}};
}

#########
# return a list of the available options for this set of artefacts
#
sub options {
    my ($self, $section) = @_;
    return unless(defined $self->{'general'}->{$section});
    return @{$self->{'general'}->{$section}->{'_options'}};
}

#########
# return a hashref of settings (user XOR general) for artefacts on scripts
#
sub values {
    my ($self, $section, $subsection) = @_;
    my $userref;
    my $genref;
    my $hashref;

    return {} unless(defined $self->{'general'}->{$section});
    return {} unless(defined $self->{'general'}->{$section}->{$subsection});

    $userref = $self->{'user'}->{$section}->{$subsection};
    $genref  = $self->{'general'}->{$section}->{$subsection};
    
    for my $key (keys %{$genref}) {
	$$hashref{$key} = $$userref{$key} || 
	    ( $$genref{$key} =~ /^0\d+/ ? 0 : $$genref{$key} ) ; 
    }
    return $hashref;
}

sub canset {
    my ($self, $section, $subsection, $key) = @_;
    return 1 if(defined $self->{'general'}->{$section}->{$subsection}->{$key});
    return undef;
}

sub set {
    my ($self, $section, $subsection, $key, $value) = @_;

    return unless(defined $key && defined $section && defined $subsection);
    return unless(defined $self->{'general'}->{$section});
    return unless(defined $self->{'general'}->{$section}->{$subsection});
    return unless(defined $self->{'general'}->{$section}->{$subsection}->{$key});

    $self->{'user'}->{$section}->{$subsection}->{$key} = $value;
}

sub get {
    my ($self, $section, $subsection, $key) = @_;

    return unless(defined $key && defined $section && defined $subsection);
    return unless(defined $self->{'general'}->{$section});
    return unless(defined $self->{'general'}->{$section}->{$subsection});
    return unless(defined $self->{'general'}->{$section}->{$subsection}->{$key});

    my $user_pref = $self->{'user'}->{$section}->{$subsection}->{$key};
    my $default   = $self->{'general'}->{$section}->{$subsection}->{$key};

    return $user_pref if(defined $user_pref);
    $default=0 if $default =~ /^0\d*$/;	#so can default to compressed while still expanding
    return $default;
}

sub default {
    my ($self, $section, $subsection, $key) = @_;

    return unless(defined $key && defined $section && defined $subsection);
    return unless(defined $self->{'general'}->{$section});
    return unless(defined $self->{'general'}->{$section}->{$subsection});
    return unless(defined $self->{'general'}->{$section}->{$subsection}->{$key});

    return $self->{'general'}->{$section}->{$subsection}->{$key};

}

sub script {
    my ($this, $val) = @_;
    $this->{'_script'} = $val if(defined $val);
    return $this->{'_script'};
}

sub cgi {
    my ($this, $val) = @_;
    $this->{'_cgi'} = $val if(defined $val);
    return $this->{'_cgi'};
}

sub colourmap {
    my ($this) = @_;
    return $this->{'_colourmap'};
}

sub dimensions {
    my ($this, $script) = @_;
    $script ||= $this->{'_script'};
print STDERR qq(WebUserConfig::dimensions is going to be DECPRECATED shortly. use width = image_width()\n);
    return ($this->get($script,'_settings','width'), 0);
}

sub image_width {
    my ($this, $script) = @_;
    $script ||= $this->{'_script'};
    return $this->get($script,'_settings','width');
}

sub bgcolor {
    my ($this, $script) = @_;
    $script ||= $this->{'_script'};
    return $this->get($script,'_settings','bgcolor');
}

sub bgcolour {
    my ($this, $script) = @_;
    return $this->bgcolor($script);
}

sub texthelper {
    my ($this) = @_;
    return $this->{'_texthelper'};
}

sub scalex {
    my ($this, $val) = @_;
    if(defined $val) {
    	$this->{'_scalex'} = $val;
	$this->{'_texthelper'}->scalex($val);
    }
    return $this->{'_scalex'};
}

sub container_width {
    my ($this, $val) = @_;
    if(defined $val) {
        $this->{'_containerlength'} = $val;

	my $width = $this->image_width();
	$this->scalex($width/$val);
    }
    return $this->{'_containerlength'};
}

sub transform {
    my ($this) = @_;
    return $this->{'transform'};
}
