package TextHelper;
use strict;

#########
# stinky GD helper object for fonts
#
sub new {
    my ($class, $transform_ref) = @_;
    my $this = {
	'_scalex' => $$transform_ref{'scalex'} || 1,
	'_scaley' => $$transform_ref{'scaley'} || 1,
	'Tiny' => {
		'width'  => 5,
		'height' => 8,
	},
	'Small' => {
		'width'  => 6,
		'height' => 12,
	},
	'MediumBold' => {
		'width'  => 7,
		'height' => 13,
	},
	'Large' => {
		'width'  => 8,
		'height' => 16,
	},
	'Giant' => {
		'width'  => 9,
		'height' => 15,
	},
    };

    bless($this, $class);
    return $this;
}

#########
# basepair to pixel ratio for a specified font
# $scaling may be calculated from $Config->dimensions()[0] / $vc->length();
#
sub bp2px {
    my ($this, $fontname) = @_;
    my $scalex = $this->{'_scalex'} || 1;
    my $scaley = $this->{'_scaley'} || 1;
    return (int($this->{$fontname}->{'width'} * $scalex), int($this->{$fontname}->{'height'} * $scaley));
}

#########
# basepair to pixel ratio for a specified font
# $scaling may be calculated from $Config->dimensions()[0] / $vc->length();
#
sub px2bp {
    my ($this, $fontname) = @_;
    my $scalex = $this->{'_scalex'} || 1;
    my $scaley = $this->{'_scaley'} || 1;
    return (int($this->{$fontname}->{'width'} / $scalex), int($this->{$fontname}->{'height'} / $scaley));
}

sub scalex {
    my ($this, $val) = @_;
    $this->{'_scalex'} = $val if(defined $val);
    return $this->{'_scalex'};
}

sub scaley {
    my ($this, $val) = @_;
    $this->{'_scaley'} = $val if(defined $val);
    return $this->{'_scaley'};
}

sub width {
    my ($this, $fontname) = @_;
    return $this->{$fontname}->{'width'} if(defined $this->{$fontname});
}

sub height {
    my ($this, $fontname) = @_;
    return $this->{$fontname}->{'height'} if(defined $this->{$fontname});
}
1;
