#package Medline;
package Gramene::Medline;

use strict;
use Carp;
use FileHandle;

use vars qw/ $AUTOLOAD /;

sub new {	# argument is text to parse

    my $class=shift;
    my $text=shift;

    #print "class $class\n";

    my %value;
    
    my $what='none';
    while($text =~ /^(.*)$/mg) {
        my $line=$1 or next;
	if(substr($line,0,6) eq '      ') {
	    $value{$what}->[-1].=" ".substr($line,6);
	} elsif(substr($line,4,2) eq '- ') {
	    $what=substr($line,0,4);
	    $what =~ s/ *$//;
	    push @{$value{$what}},substr($line,6);
	} else {
	    print STDERR "bad medline line: $line\n" if $line=~/\S/;
	    $what='junk';
	}
    }

    my $result=\%value;
    bless $result,$class;
    return $result;
}

sub keys {
    my $self=shift;
    return sort keys %{$self};
}

sub dump {
    my $self=shift;
    return map { "$_ => ".join("++",@{$self->{$_}})."\n"; } $self->keys;
}

sub AUTOLOAD {
    my $obj=$_[0];
    (my $name=$AUTOLOAD) =~ s/.*:://;
    return wantarray ? () : undef unless $obj->{$name};
    return wantarray ? @{$obj->{$name}} : $obj->{$name}->[0];
}

1;
