package Gramene::GetRefData; 

# A module for the publication search page of Gramene.     --------Wei Zhao (10/03/01)  


use strict;
use DBI;
use CGI;
use CSHL::Config;

my %attr;
my $dbh;

sub whatever {

    #my $invocant = shift;
    #my $class = ref($invocant) || $invocant;
    my $class = shift;
    my $self = { };
    bless($self, $class);
    return $self;

}


# destructor
sub DESTROY {
  my $self = shift;
  #$self->terminate_database if $self->{'db'};
  $self->terminate_database if $dbh;
}


sub terminate_database{
  my $self = shift;
  #$self->{'db'}->disconnect() if $self->{'db'};
  $dbh ->disconnect() if $dbh;
}


sub connect_to_ora {
	
    
    ### Attributes to pass to DBI->connect()
    %attr = (
	#PrintError => 1,
	RaiseError => 1
    );


    # Connect to the database
   
    $dbh = DBI->connect(OntologyDataSource, OntologyDBUser, OntologyDBPassword )
                      || die "Can't connect to Oracle database: $DBI::errstr\n";


 
    # Connect to the database
    #$dbh = DBI->connect( "dbi:Oracle:rice", "go", "grain", \%attr )
    #                 || die "Can't connect to Oracle database: $DBI::errstr\n";

    $dbh->{LongReadLen} = 5000;
    $dbh->{LongTruncOk} = 1;

    
}


sub name_to_person {

    my $author = $_[1];
     
    my ( @person_ids, @person_names );
    my ( $person_id, $person_name );


    my $sth1 = $dbh->prepare( "SELECT contributor_id, contributor_name FROM contributor 
			       WHERE UPPER(contributor_name) LIKE ?
                               ORDER BY contributor_name" );
    $sth1->bind_param( 1, $author );
    $sth1->execute();
    while( ( $person_id, $person_name ) = $sth1->fetchrow_array ) {
        
        
        @person_ids = ( @person_ids, $person_id );
	  @person_names = ( @person_names, $person_name );

    }
    $sth1->finish;
    return ( \@person_ids, \@person_names );
}


sub person_to_ref {
    my $person_id = $_[1];
    my ( $ref_id, @ref_ids );

    #my $sth2 = $dbh->prepare( "SELECT reference_id FROM author WHERE contributor_id = ?" );
    my $sth2 = $dbh->prepare( "SELECT reference_id from reference
                               where reference_id in
                                     (SELECT reference_id FROM author WHERE contributor_id = ?)
                               order by year DESC" );
    $sth2->bind_param( 1, $person_id );
    $sth2->execute();
    while( $ref_id = $sth2->fetchrow_array ) {
        
        
        @ref_ids = ( @ref_ids, $ref_id );


    }
    $sth2->finish;
    return @ref_ids;
}


sub source_id_to_source_name {
    my $source_id = $_[1];
    my $source_name;

    my $sth3 = $dbh->prepare( "SELECT source_name FROM source WHERE source_id = ?" );
    $sth3->bind_param( 1, $source_id );

    
    $sth3->execute();
    $source_name = $sth3->fetchrow_array();
    $sth3->finish;
    return $source_name;    
        
    
}


sub source_id_to_source_url {
    my $source_id = $_[1];
    my $source_url;

    my $sth40 = $dbh->prepare( "SELECT source_url FROM source_url_new WHERE source_id = ?" );
    $sth40->bind_param( 1, $source_id );

    
    $sth40->execute();
    $source_url = $sth40->fetchrow_array();
    $sth40->finish;
    return $source_url;    
        
    
}


sub ref_id_to_ref {
    my $ref_id = $_[1];
    my ( $title, $source_id, $year, $volume, $start_page, $end_page );
    my $sth4 = $dbh->prepare( "SELECT reference_id, title, source_id, year, volume, start_page, end_page 
					 FROM reference 
                               WHERE reference_id = ?" );
    $sth4->bind_param( 1, $ref_id );
    $sth4->execute();
	
    ( $ref_id, $title, $source_id, $year, $volume, $start_page, $end_page ) = $sth4->fetchrow_array();
    $sth4->finish;
    return ( $title, $source_id, $year, $volume, $start_page, $end_page );
}



sub ref_id_to_abstract {
    my $ref_id = $_[1];
    my ( $abstract, $aa, $ab );
    my $sth5 = $dbh->prepare( "SELECT abstract_part_a, abstract_part_b
					 FROM reference_abstract
					 WHERE reference_id = ?" );
    $sth5->bind_param( 1, $ref_id );
    $sth5->execute();
    ( $aa, $ab ) = $sth5->fetchrow_array();
    if( $aa ) {
        if( $ab ) {
	      $abstract = $aa.$ab;
	  } else {
	      $abstract = $aa;
        }
    } else {
	  $abstract = "Not available.";
    }
    $sth5->finish;
    return $abstract;
}

sub title_word_to_ref {
    my $word = $_[1];
    my ( @ref_ids, @titles, @source_ids, @years, @volumes, @start_pages, @end_pages );
    my ( $ref_id, $title, $source_id, $year, $volume, $start_page, $end_page );


    my $sth6 = $dbh->prepare( "SELECT reference_id, source_id, title, year, volume, start_page, end_page 
					 FROM reference 
                               WHERE UPPER(title) LIKE ?
                               ORDER BY year DESC" ); 
    $sth6->bind_param( 1, $word );

    
    $sth6->execute();
    
    while( ( $ref_id, $source_id, $title, $year, $volume, $start_page, $end_page ) = $sth6->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
	  @source_ids = ( @source_ids, $source_id );
	  @titles = ( @titles, $title );
	  @years = ( @years, $year );
	  @volumes = ( @volumes, $volume );
	  @start_pages = ( @start_pages, $start_page );
	  @end_pages = ( @end_pages, $end_page );
    }

    
    $sth6->finish;
    return ( \@ref_ids, \@titles, \@source_ids, \@years, \@volumes, \@start_pages, \@end_pages );
}


sub word_to_ref {

    my $word = $_[1];
    my ( @ref_ids, @titles, @source_ids, @years, @volumes, @start_pages, @end_pages );
    my ( $ref_id, $title, $source_id, $year, $volume, $start_page, $end_page );


    my $sth6 = $dbh->prepare( "select reference_id, source_id, title, year, volume, start_page, end_page from reference
                               where UPPER(title) LIKE ?
                               or reference_id in
                                  (SELECT reference_id FROM reference_abstract
                                   WHERE UPPER(abstract_part_a) LIKE ?
                                   OR UPPER(abstract_part_b) LIKE ?)
                               order by year DESC" ); 
    $sth6->bind_param( 1, $word );
    $sth6->bind_param( 2, $word );
    $sth6->bind_param( 3, $word );
    
    $sth6->execute();
    
    while( ( $ref_id, $source_id, $title, $year, $volume, $start_page, $end_page ) = $sth6->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
	  @source_ids = ( @source_ids, $source_id );
	  @titles = ( @titles, $title );
	  @years = ( @years, $year );
	  @volumes = ( @volumes, $volume );
	  @start_pages = ( @start_pages, $start_page );
	  @end_pages = ( @end_pages, $end_page );
    }

    
    $sth6->finish;
    return ( \@ref_ids, \@titles, \@source_ids, \@years, \@volumes, \@start_pages, \@end_pages );
    
}


sub source_to_source_id {

    

    my $source = $_[1];
    my $year = $_[2];
    my ( $source_id, $source_name );
    my ( @source_ids, @source_names );


    my $sth8 = $dbh->prepare( "SELECT source_id, source_name FROM source
                               WHERE UPPER(source_name) LIKE ?
                               UNION
                               SELECT source_id, source_synonym FROM source_synonym
                               WHERE UPPER(source_synonym) LIKE ?
                               ORDER BY 2" );
   
    $sth8->bind_param( 1, $source );
    $sth8->bind_param( 2, $source );
    $sth8->execute();
    while( ( $source_id, $source_name ) = $sth8->fetchrow_array ) {
        my $unique = 1;
        my $i = 0;
	while( ( $unique ) && ( $i <= $#source_ids ) ) {
	  if( $source_id == $source_ids[$i] ) {
	      $unique = 0;
	  }
	  $i++;
	}
	if( $unique ) {
            @source_ids = ( @source_ids, $source_id );
	    @source_names = ( @source_names, $source_name );
	}
    }
    $sth8->finish;
    if( $year == 0 ) {
        return ( \@source_ids, \@source_names );
      } else {

	

	    my $found_source_id;
	    my @found_source_ids;
	    my @found_source_names;

	    my $sth9 = $dbh->prepare( "SELECT source_id FROM reference 
                                       WHERE source_id = ?
                                       AND year = ?" );
	    for( my $i=0; $i<=$#source_ids; $i++ ) {
                                  
	        $sth9->bind_param( 1, $source_ids[$i] );
		$sth9->bind_param( 2, $year );
		$sth9->execute();
		$found_source_id = $sth9->fetchrow_array; 

	        if( $found_source_id ) {
		    @found_source_names = ( @found_source_names, $source_names[$i] );
		    @found_source_ids = ( @found_source_ids, $source_ids[$i] );
		}
	    }
	    $sth9->finish;
	    return ( \@found_source_ids, \@found_source_names );

	  }

}
	    


sub source_id_to_ref {
    my $source_id = $_[1];
    my $year = $_[2]; #####changed
    my ( $ref_id, $title, $volume, $start_page, $end_page );
    my ( @ref_ids, @titles, @years, @volumes, @start_pages, @end_pages );
    my $sth10;

    if( $year ) {

    
         $sth10 = $dbh->prepare( "SELECT reference_id, title, year, volume, start_page, end_page FROM reference 
                                   WHERE source_id = ?
                                   AND year = ?
                                   ORDER BY volume DESC" ); 
	$sth10->bind_param( 1, $source_id );
	$sth10->bind_param( 2, $year );
    } else {
	 $sth10 = $dbh->prepare( "SELECT reference_id, title, year, volume, start_page, end_page FROM reference 
                                   WHERE source_id = ?
                                   ORDER BY year DESC" );
                                  
	$sth10->bind_param( 1, $source_id );
    }
    $sth10->execute();

    

	while( ( $ref_id, $title, $year, $volume, $start_page, $end_page ) = $sth10->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );

	@titles = ( @titles, $title );
	@years = ( @years, $year );
	@volumes = ( @volumes, $volume );
	@start_pages = ( @start_pages, $start_page );
	@end_pages = ( @end_pages, $end_page );
    }
    $sth10->finish;
    return ( \@ref_ids, \@titles, \@years, \@volumes, \@start_pages, \@end_pages );

}


sub ref_id_to_author {
    my $ref_id = $_[1];
    my ( $person_id, @person_ids, $author, @authors );
    
    my $sth12 = $dbh->prepare( "SELECT contributor_id FROM author
                                WHERE reference_id = ?
                                ORDER BY authorship_position" );
    my $sth13 = $dbh->prepare( "SELECT contributor_name FROM contributor
                                WHERE contributor_id = ?" );
    $sth12->bind_param( 1, $ref_id );
    $sth12->execute();
    while( $person_id = $sth12->fetchrow_array() ) {
        @person_ids = ( @person_ids, $person_id );
        $sth13->bind_param( 1, $person_id );
	$sth13->execute();
	$author = $sth13->fetchrow_array();
	@authors = ( @authors, $author );
    }
    $sth12->finish;
    $sth13->finish;
    return (\@person_ids, \@authors);
}


sub ref_id_to_url {
    my $ref_id = $_[1];
    my ( $url, $label, @urls, @labels );
    my $sth14 = $dbh->prepare( "SELECT reference_url, url_label
				FROM reference_url
				WHERE reference_id = ?" );
    $sth14->bind_param( 1, $ref_id );
    $sth14->execute();
    while( ( $url, $label ) = $sth14->fetchrow_array() ) {
        @urls = ( @urls, $url );
	@labels = ( @labels, $label );
    }
    $sth14->finish;
    return (\@urls, \@labels);
}

sub ref_id_to_comment {
    my $ref_id = $_[1];
    my ( $comment );
    my $sth15 = $dbh->prepare( "SELECT reference_comment
				FROM reference_comment
				WHERE reference_id = ?" );
    $sth15->bind_param( 1, $ref_id );
    $sth15->execute();
    $comment = $sth15->fetchrow_array();
    $sth15->finish; 
    return $comment;
}


sub ref_id_to_xref {
    my $ref_id = $_[1];
    my ( $db_name, $acc, @db_names, @accs );
    my $sth17 = $dbh->prepare( "SELECT dbxref_id
				FROM objectxref
				WHERE table_name = ?
                                AND row_id = ?" );
    $sth17->bind_param( 1, "gramene.ontology.reference" );
    $sth17->bind_param( 2, $ref_id );
    $sth17->execute();

    my $dbxref_id;
    while( $dbxref_id = $sth17->fetchrow_array() ) {
        my $sth16 = $dbh->prepare( "SELECT xref_dbname, xref_key
				    FROM dbxref
				    WHERE dbxref_id = ?" );
	$sth16->bind_param( 1, $dbxref_id );
	$sth16->execute();
	( $db_name, $acc ) = $sth16->fetchrow_array();
	@db_names = ( @db_names, $db_name );
	@accs = ( @accs, $acc );
	$sth16->finish;
    }
    $sth17->finish;
    
    return ( \@db_names, \@accs );
}


###################

#sub get_annotation {
#    my $ref_id = $_[1];
#    my ( $dbxref, $ann, @dbxrefs, @anns );
#    my $sth18 = $dbh->prepare( "SELECT dbxref_id, annotation
#				FROM reference_annotation
#				WHERE reference_id = ?" );
#                              
#    
#    $sth18->bind_param( 1, $ref_id );
#    $sth18->execute();

#    while( ( $dbxref, $ann ) = $sth18->fetchrow_array() ) {
#        
#	@dbxrefs = ( @dbxrefs, $dbxref );
#	@anns = ( @anns, $ann );

#    }
#    $sth18->finish;
#    return ( \@dbxrefs, \@anns );
#}


#####################

sub get_xref {
    my $dbxref_id = $_[1];
    my ( $key, $type, $name );
    my $sth19 = $dbh->prepare( "SELECT xref_key, xref_keytype, xref_dbname
				FROM dbxref
				WHERE dbxref_id = ?" );
                              
    
    $sth19->bind_param( 1, $dbxref_id );
    $sth19->execute();

    ( $key, $type, $name ) = $sth19->fetchrow_array();
        
    $sth19->finish;
    return ( $key, $type, $name );
}
######################

  
1;
	

