package Gramene::GetProteinData;       

#A perl module for the protein page.                  -----Wei Zhao(10/17/01)

use strict;
use DBI;
use CSHL::Config;

my %attr;
my $dbh;

sub new {

    #my $invocant = shift;
    #my $class = ref($invocant) || $invocant;
    my $class = shift;
    my $self = { };
    bless($self, $class);
    return $self;

}


# destructor
sub DESTROY {
  my $self = shift;
  $self->terminate_database if $dbh;
}


sub terminate_database{
  my $self = shift;
  $dbh ->disconnect() if $dbh;
}



sub connect_to_ora {
	
    
    ### Attributes to pass to DBI->connect()
    %attr = (
	#PrintError => 1,
	RaiseError => 1
    );

    # Connect to the database
    $dbh = DBI->connect( OntologyDataSource, OntologyDBUser, OntologyDBPassword )
                      || die "Can't connect to Oracle database: $DBI::errstr\n";



    $dbh->{LongReadLen} = 2000;
    $dbh->{LongTruncOk} = 1;

    
}


####################################



sub get_detail {

    my $id = $_[1];
    my $sth11 = $dbh->prepare( "SELECT gene_product_symbol, gene_product_full_name, gene_product_description 
                                FROM gene_product
                                WHERE gene_product_id = ?" );
    $sth11->bind_param( 1, $id );
    $sth11->execute();
    my ( $symbol, $name, $des ) = $sth11->fetchrow_array;
    $sth11->finish;
    return ( $symbol, $name, $des );

}




sub get_associations {
    
    my $id = $_[1];
    my $sth13 = $dbh->prepare( "SELECT association_id, association.term_id  
                                FROM association, term
                                WHERE gene_product_id = ?
                                AND association.term_id = term.term_id
                                AND term_type = 4" );
    $sth13->bind_param( 1, $id );
    $sth13->execute();
    my $sth14 = $dbh->prepare( "SELECT association_id, association.term_id  
                                FROM association, term
                                WHERE gene_product_id = ?
                                AND association.term_id = term.term_id
                                AND term_type = 2" );
    $sth14->bind_param( 1, $id );
    $sth14->execute();
    my $sth15 = $dbh->prepare( "SELECT association_id, association.term_id  
                                FROM association, term
                                WHERE gene_product_id = ?
                                AND association.term_id = term.term_id
                                AND term_type = 3" );
    $sth15->bind_param( 1, $id );
    $sth15->execute();
    my ( $asso, @assos, $term, @terms, $go_term, @go_terms, $go_name, @go_names );
    while( ($asso, $term) = $sth13->fetchrow_array ) {
        @assos = ( @assos, $asso );
	@terms = ( @terms, $term );
    }
    while( ($asso, $term) = $sth14->fetchrow_array ) {
        @assos = ( @assos, $asso );
	@terms = ( @terms, $term );
    }
    while( ($asso, $term) = $sth15->fetchrow_array ) {
        @assos = ( @assos, $asso );
	@terms = ( @terms, $term );
    }
##################
    
    foreach my $t ( @terms ) {
	################
	my $sth41 = $dbh->prepare( "SELECT term_accession, term_name  
                                    FROM term
                                    WHERE term_id = ?" );
	$sth41->bind_param( 1, $t );
	$sth41->execute();
	( $go_term, $go_name ) = $sth41->fetchrow_array;
	if( $go_term < 99 ) {
	    $go_term = "GO:00000".$go_term;
	} elsif( $go_term < 999 ) {
	    $go_term = "GO:0000".$go_term;
	} elsif( $go_term < 9999 ) {
	    $go_term = "GO:000".$go_term;
	} else {
	    $go_term = "GO:00".$go_term;
	}

	@go_terms = ( @go_terms, $go_term );
	@go_names = ( @go_names, $go_name );
	$sth41->finish;
    } 
    $sth13->finish;
    $sth14->finish;
    $sth15->finish;
    return ( \@assos, \@go_names, \@go_terms, \@terms );

}




##################

sub get_evidences {

    my $asso_id = $_[1];
    
    my $sth45 = $dbh->prepare( "SELECT dbxref_id, evidence_code        
                                FROM evidence
                                WHERE association_id = ?" );
                               
    $sth45->bind_param( 1, $asso_id );
    $sth45->execute();
    my ( $x_id, @x_ids, $code, @codes, $key, @keys, $db_name, @db_names );
    my $sth46 = $dbh->prepare( "SELECT xref_key, xref_dbname        
                                FROM dbxref
                                WHERE dbxref_id = ?" );
    while( ($x_id, $code) = $sth45->fetchrow_array ) {
        $sth46->bind_param( 1, $x_id );
	$sth46->execute();
	( $key, $db_name ) = $sth46->fetchrow_array;
	@keys = ( @keys, $key );
	@db_names = ( @db_names, $db_name );
	@codes = ( @codes, $code );
	
    } 
    $sth45->finish;
    $sth46->finish;
    return ( \@keys, \@db_names, \@codes );

}
###################




###################


sub get_ref {

    my $ref_id = $_[1];
    
    my ( $x_key, $dbname, $title, $s_id, $year, $volume, $start_page, $end_page, $source );

    my $sth16 = $dbh->prepare( "SELECT reference_id, title, source_id, year, volume, start_page, end_page
                                FROM reference
                                WHERE reference_id = ?" );

    
    $sth16->bind_param( 1, $ref_id );
    $sth16->execute();
    ( $x_key, $title, $s_id, $year, $volume, $start_page, $end_page ) = $sth16->fetchrow_array();
    my $sth42 = $dbh->prepare( "SELECT source_name
                                FROM source
                                WHERE source_id = ?" );
    $sth42->bind_param( 1, $s_id );
    $sth42->execute();
    $source = $sth42->fetchrow_array; 
    $sth16->finish;
    $sth42->finish;
    return ( $x_key, $title, $source, $year, $volume, $start_page, $end_page );

}



    
sub get_origin {

    my $p_id = $_[1];
    my $sth17 = $dbh->prepare( "SELECT cultivar_id
                                FROM gene_product_to_cultivar
                                WHERE gene_product_id = ?" );
    $sth17->bind_param( 1, $p_id );
    $sth17->execute();
    my $cul_id = $sth17->fetchrow_array();
    my $sth18 = $dbh->prepare( "SELECT subspecies_id, species_id, cultivar_name
                                    FROM cultivar
                                    WHERE cultivar_id = ?" );
    my ( $sub_id, $spe_id, $cul_name, $sub_name, $spe_name );
    if( $cul_id ) {
        
	$sth18->bind_param( 1, $cul_id );
	$sth18->execute();
	( $sub_id, $spe_id, $cul_name ) = $sth18->fetchrow_array();

	my $sth19 = $dbh->prepare( "SELECT subspecies_name
                                    FROM subspecies
                                    WHERE subspecies_id = ?" );
	$sth19->bind_param( 1, $sub_id );
	$sth19->execute();
	$sub_name = $sth19->fetchrow_array();

	my $sth20 = $dbh->prepare( "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?" );
	$sth20->bind_param( 1, $spe_id );
	$sth20->execute();
	$spe_name = $sth20->fetchrow_array();
	$sth19->finish;
	$sth20->finish;
    } else {

        my $sth21 = $dbh->prepare( "SELECT subspecies_id
                                    FROM gene_product_to_subspecies
                                    WHERE gene_product_id = ?" );
	$sth21->bind_param( 1, $p_id );
	$sth21->execute();
	$sub_id = $sth21->fetchrow_array();
	$sth21->finish;


	if( $sub_id ) {

	    my $sth19 = $dbh->prepare( "SELECT subspecies_name, species_id 
                                    FROM subspecies
                                    WHERE subspecies_id = ?" );
	    $sth19->bind_param( 1, $sub_id );
	    $sth19->execute();
	    ( $sub_name, $spe_id ) = $sth19->fetchrow_array();

	    my $sth20 = $dbh->prepare( "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?" );
	    $sth20->bind_param( 1, $spe_id );
	    $sth20->execute();
	    $spe_name = $sth20->fetchrow_array();
	    $sth19->finish;
	    $sth20->finish;

	} else {
	    
	    my $sth22 = $dbh->prepare( "SELECT species_id
                                        FROM gene_product_to_species
                                        WHERE gene_product_id = ?" );
	    $sth22->bind_param( 1, $p_id );
	    $sth22->execute();
	    $spe_id = $sth22->fetchrow_array();
	    $sth22->finish;

	    if( $spe_id ) {
	        
	        my $sth20 = $dbh->prepare( "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?" );
		$sth20->bind_param( 1, $spe_id );
		$sth20->execute();
		$spe_name = $sth20->fetchrow_array();
		$sth20->finish;

	    }

	} #End else
    } #End else
    $sth17->finish;
    $sth18->finish;
    return ( $spe_name, $sub_name, $cul_name );

}


sub get_expression {

    my $p_id = $_[1];
    my $sth24 = $dbh->prepare( "SELECT expression_annotation
                                FROM expression
                                WHERE gene_product_id = ?" );
    $sth24->bind_param( 1, $p_id );
    $sth24->execute();
    my $exp = $sth24->fetchrow_array();
    $sth24->finish;
    return $exp;

}


sub get_synonyms {

    my $p_id = $_[1];
    my $sth25 = $dbh->prepare( "SELECT gene_product_synonym_symbol
                                FROM gene_product_synonym
                                WHERE gene_product_id = ?" );
    $sth25->bind_param( 1, $p_id );
    $sth25->execute();
    my ( $syn, @syns );
    while( $syn = $sth25->fetchrow_array() ) {
        @syns = ( @syns, $syn );
    }
    $sth25->finish;
    return \@syns;

}


sub get_xref {

    my $p_id = $_[1];
    my $sth26 = $dbh->prepare( "SELECT xref_dbname, xref_key
                                FROM dbxref
                                WHERE dbxref_id =
                                      (SELECT organism_dbxref_id
                                       FROM gene_product
                                       WHERE gene_product_id = ?)" );
    $sth26->bind_param( 1, $p_id );
    $sth26->execute();
    my ( $dbname, $key, @dbnames, @keys );
    while( ( $dbname, $key ) = $sth26->fetchrow_array() ) {
        @dbnames = ( @dbnames, $dbname );
	############
	$key =~ s/ORYZA/ORYSA/;
	############
	@keys = ( @keys, $key );

    }
    $sth26->finish;
    return ( \@dbnames, \@keys );

}

##############
sub get_acc {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "select swissprot_acc from gene_product_helper_two
                               where gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $acc = $sth1->fetchrow_array();
    $sth1->finish;
    return $acc;

}


sub get_symbol {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT gene_product_symbol
                               FROM gene_product
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $symbol = $sth1->fetchrow_array();
    if( $symbol eq "not available" ) {
        $symbol = "Not available";
    }
    $sth1->finish;
    return $symbol;

}


sub get_names {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT gene_product_full_name
                               FROM gene_product
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $name = $sth1->fetchrow_array();
    my $sth2 = $dbh->prepare( "SELECT gene_product_synonym_symbol
                               FROM gene_product_synonym
                               WHERE gene_product_id = ?" );
    $sth2->bind_param( 1, $p_id );
    $sth2->execute();
    my $syn;
    while( $syn = $sth2->fetchrow_array() ) {

      if( ( $syn =~ /\)/ ) && ( ! ( $syn =~ /\(/ ) ) ) {
	  $syn =~ s/\)//;
      }
      unless( $syn eq "FRAGMENT" ) {
        if( $name ) {
            $name = $name.", ".$syn;
	} else {
	    $name = $syn;
	}
      }
    }
    
    $sth1->finish;
    $sth2->finish;
    return $name;

}


sub get_ecs {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT xref_key
                               FROM dbxref
                               WHERE xref_keytype = 'EC'
                               AND xref_dbname = 'ENZYME'
                               AND dbxref_id IN
                                      (SELECT dbxref_id
                                       FROM objectxref
                                       WHERE row_id = ?
                                       AND table_name like '%gene_product')" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $ecs, $ec );
    while( $ec = $sth1->fetchrow_array() ) {
        if( $ecs ) {
            $ecs = $ecs.", ".$ec;
	} else {
	    $ecs = $ec;
	}
    }
    unless( $ecs ) {
        $ecs = "Not available";
    }
    $sth1->finish;
    return $ecs;

}

sub get_gns {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT gene_name
                               FROM gene_product_gene_name
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $gns, $gn );
    while( $gn = $sth1->fetchrow_array() ) {
        if( $gns ) {
            $gns = $gns.", ".$gn;
	} else {
	    $gns = $gn;
	}
    }
    $sth1->finish;
    unless( $gns ) {
        $gns = "Not available";
    }
    return $gns;

}


sub get_organisms {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT cultivar_id
                               FROM gene_product_to_cultivar
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $cul_id = $sth1->fetchrow_array;
    my $sth2 = $dbh->prepare( "SELECT genus, species, ncbi_taxa_id, subspecies_name, cultivar_name  
                               FROM species, subspecies, cultivar
                               WHERE cultivar_id = ?
                               AND subspecies.subspecies_id = cultivar.subspecies_id
                               AND species.species_id = cultivar.species_id" );
    $sth2->bind_param( 1, $cul_id );
    $sth2->execute();
    my ( $genus, $spe, $taxa_id, $sub, $cul ) = $sth2->fetchrow_array;
    
    $sth1->finish;
    $sth2->finish;
    
    return ( $genus, $spe, $taxa_id, $sub, $cul );

}

sub get_exp {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT expression_annotation
                               FROM expression
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $exp = $sth1->fetchrow_array();
    unless( $exp ) {
        $exp = "Not available";
    }
    $sth1->finish;
    return $exp;

}


sub get_tissue {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT tissue
                               FROM gene_product_tissue
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $tissue = $sth1->fetchrow_array();
    unless( $tissue ) {
        $tissue = "Not available";
    }
    $sth1->finish;
    return $tissue;

}


sub get_keywords {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT keyword
                               FROM keyword
                               WHERE keyword_id IN 
                                     (SELECT keyword_id
                                      FROM gene_product_to_keyword
                                      WHERE gene_product_id = ?)" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $gns, $gn );
    while( $gn = $sth1->fetchrow_array() ) {
        #$gns = $gns.", ".$gn;
	if( $gns ) {
            $gns = $gns.", ".$gn;
	} else {
	    $gns = $gn;
	}
    }
    $sth1->finish;
    unless( $gns ) {
        $gns = "Not available";
    }
    return $gns;

}


sub get_comment {

    my $p_id = $_[1];
    my $exp = "Not available";
    return $exp;

}


sub get_swall {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "select swissprot_id from gene_product_helper_two
                               where gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $acc = $sth1->fetchrow_array();
    $sth1->finish;
    return $acc;

}


sub get_protein {

    my $word = $_[1];
    my $wild_card = $_[2];
    my $complete_result = $_[3];

    my $new_word;
    my $sth1;

    if( $wild_card eq "ON" ) {
        $new_word = "%".$word."%";
	$word = "%".$word."%";
	$sth1 = $dbh->prepare( "select gene_product_id, swissprot_acc, swissprot_id, gene_product_name, organism, evidence_codes 
                                from gene_product_helper_two
                                where UPPER(gene_product_name) like ?
                                or UPPER(swissprot_acc) like ?
                                or UPPER(swissprot_id) like ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank" );
    } else {
        $new_word = "% ".$word." %";
	$sth1 = $dbh->prepare( "select gene_product_id, swissprot_acc, swissprot_id, gene_product_name, organism, evidence_codes  
                                from gene_product_helper_two
                                where UPPER(gene_product_name) like ?
                                or UPPER(swissprot_acc) = ?
                                or UPPER(swissprot_id) = ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank" );
    }
    
    
    

    $sth1->bind_param( 1, $new_word );
    $sth1->bind_param( 2, $word );
    $sth1->bind_param( 3, $word );
    $sth1->bind_param( 4, $new_word );
    
    $sth1->execute();

    my ( @ids, @names, @accs, @sids, @orgas, @codes );
    my ( $id, $acc, $sid, $name, $orga, $code );
    my $nothing = "";
    my $part_result = 0;

    if( $complete_result eq "1" ) {

        while( ( $id, $acc, $sid, $name, $orga, $code ) = $sth1->fetchrow_array() ) {
        
	    @ids = ( @ids, $id );

	    substr( $name, -1, 2 ) = $nothing;
	    @names = ( @names, $name );
	    @accs = ( @accs, $acc );
	    @sids = ( @sids, $sid );
	    
	    substr( $orga, -1, 2 ) = $nothing;
	    @orgas = ( @orgas, $orga );
	    @codes = ( @codes, $code );

	}

        
    } else {
        
        while( ( scalar( @ids ) < 500 ) && ( ( $id, $acc, $sid, $name, $orga, $code ) = $sth1->fetchrow_array() ) ) {
        
            @ids = ( @ids, $id );

	    substr( $name, -1, 2 ) = $nothing;
	    @names = ( @names, $name );
	    @accs = ( @accs, $acc );
	    @sids = ( @sids, $sid );
	    
	    substr( $orga, -1, 2 ) = $nothing;
	    @orgas = ( @orgas, $orga );
	    @codes = ( @codes, $code );
	    if( scalar( @ids ) >= 500 ) {
	        $part_result = 1;
	    }

	}

    }
    $sth1->finish;
    
    
    return ( \@ids, \@accs, \@sids, \@names, \@orgas, \@codes, $part_result );

}

###############################


sub get_protein_old {

    my $word = $_[1];
    
    my $sth1 = $dbh->prepare( "select * from gene_product_extra
                               where UPPER(gene_product_name) like ?
                               or UPPER(swissprot_acc) like ?
                               or UPPER(swissprot_id) like ?" );
    

    $sth1->bind_param( 1, $word );
    $sth1->bind_param( 2, $word );
    $sth1->bind_param( 3, $word );
    
    $sth1->execute();
    my ( @ids, @names, @accs, @sids );
    my ( $id, $name, $acc, $sid );
    while( ( $id, $name, $acc, $sid ) = $sth1->fetchrow_array() ) {
        
        my $unique = 1;
	my $i = 0;
	while( ( $unique ) && ( $i <= $#ids ) ) {
	    if( $id == $ids[$i] ) {
	        $unique = 0;
	    }
	    $i++;
	}
	if( $unique ) {
	    if( ( $name =~ /\)/ ) && ( ! ( $name =~ /\(/ ) ) ) {
	        $name =~ s/\)//;
	    }
	    @ids = ( @ids, $id );
	    @names = ( @names, $name );
	    
	    @accs = ( @accs, $acc );
	    
	    @sids = ( @sids, $sid );
	    
	}
    
    }
    $sth1->finish;
    
    
    return ( \@ids, \@names, \@accs, \@sids );

}


###############

sub get_gis {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT gi_number
                               FROM gene_product_to_gi_number
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( @gis, $gi );
    while( $gi = $sth1->fetchrow_array ) {
        @gis = ( @gis, $gi );
    }
    $sth1->finish;
    return @gis;

}


sub get_trans {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT xref_key
                               FROM dbxref
                               WHERE xref_keytype = 'id'
                               AND xref_dbname like '%translation'
                               AND dbxref_id IN
                                      (SELECT dbxref_id
                                       FROM objectxref
                                       WHERE row_id = ?
                                       AND table_name like '%gene_product')" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $ecs, $ec );
    while( $ec = $sth1->fetchrow_array() ) {
        if( $ecs ) {
            $ecs = $ecs.", ".$ec;
	} else {
	    $ecs = $ec;
	}
    }
    unless( $ecs ) {
        $ecs = "Not available";
    }
    $sth1->finish;
    return $ecs;

}



sub get_pfam {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT xref_key, xref_desc
                               FROM dbxref
                               WHERE xref_keytype = 'ACC'
                               AND xref_dbname = 'Pfam'
                               AND dbxref_id IN
                                      (SELECT dbxref_id
                                       FROM objectxref
                                       WHERE row_id = ?
                                       AND table_name like '%gene_product')" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $pfam, $extra ) = $sth1->fetchrow_array();
    
    $sth1->finish;
    return ( $pfam, $extra );

}


sub get_prosite {

    my $p_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT prosite_id, prosite_desc, prosite_sequence
                               FROM gene_product_prosite
                               WHERE gene_product_id = ?
                               order by prosite_id" );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( @keys, @descs, @sequences );
    while( my ( $key, $desc, $sequence ) = $sth1->fetchrow_array ) {
        @keys = ( @keys, $key );
	@descs = ( @descs, $desc );
	@sequences = ( @sequences, $sequence );
    }
    
    $sth1->finish;
    return ( \@keys, \@descs, \@sequences );

}


sub get_term_type {

    my $t_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT term_type
                               FROM term
                               WHERE term_id = ?" );
    $sth1->bind_param( 1, $t_id );
    $sth1->execute();
    my $type = $sth1->fetchrow_array();
    
    $sth1->finish;
    return $type;

}

sub get_id_by_swall {

    my $swall_id = $_[1];
    
    my $sth1 = $dbh->prepare( "select gene_product_id from gene_product_helper_two
                               where UPPER(swissprot_id) = ?" );  

    $sth1->bind_param( 1, $swall_id );
    $sth1->execute();
    my $id = $sth1->fetchrow_array();
    $sth1->finish;
    return $id;

}


sub get_trembl_new {

   
    my $gp_id = $_[1];
    my $sth1 = $dbh->prepare( "SELECT gene_product_id
                               FROM gene_product_trembl_new
                               WHERE gene_product_id = ?" );
    $sth1->bind_param( 1, $gp_id );
    $sth1->execute();
    my $trembl_new;
    if( $sth1->fetchrow_array() ) {
        $trembl_new = 1;
    } else {
        $trembl_new = 0;
    }
    
    $sth1->finish;
    return $trembl_new;

}

sub db {
    return $dbh;
}

###################

sub get_id_by_acc {

    my $acc = $_[1];
    my $sth1 = $dbh->prepare( "select gene_product_id from gene_product_helper_two
                               where UPPER(swissprot_acc) = ?" );  

    $sth1->bind_param( 1, $acc );
    $sth1->execute();
    my $p_id = $sth1->fetchrow_array();
    $sth1->finish;
    return $p_id;

}


sub validate_id {

    my $id = $_[1];
    my $sth1 = $dbh->prepare( "select gene_product_id from gene_product_helper_two
                               where gene_product_id = ?" );  

    $sth1->bind_param( 1, $id );
    $sth1->execute();
    my $p_id = $sth1->fetchrow_array();
    $sth1->finish;
    return $p_id;

}


##############################


sub get_ref_ids {

    my $id = $_[1];
    my $sth1 = $dbh->prepare( "select reference_id from reference_to_object
                               where object_id = ?
                               and object_table like '%gene_product'" );  

    $sth1->bind_param( 1, $id );
    $sth1->execute();
    my( $ref_id, @ref_ids );
    while( $ref_id = $sth1->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
    }
    $sth1->finish;
    return @ref_ids;

}


sub get_ref_detail {

    my $ref_id = $_[1];
    
    my ( $title, $s_id, $year, $volume, $start_page, $end_page );

    my $sth16 = $dbh->prepare( "SELECT title, source_id, year, volume, start_page, end_page
                                FROM reference
                                WHERE reference_id = ?" );

    
    $sth16->bind_param( 1, $ref_id );
    $sth16->execute();
    ( $title, $s_id, $year, $volume, $start_page, $end_page ) = $sth16->fetchrow_array();
    $sth16->finish;

    my $sth42 = $dbh->prepare( "SELECT source_name
                                FROM source
                                WHERE source_id = ?" );
    $sth42->bind_param( 1, $s_id );
    $sth42->execute();
    my $source = $sth42->fetchrow_array; 
    $sth42->finish;

    my $sth1 = $dbh->prepare( "SELECT author
                               FROM reference_extra
                               WHERE reference_id = ?" );
    $sth1->bind_param( 1, $ref_id );
    $sth1->execute();
    my $author = $sth1->fetchrow_array; 
    $sth1->finish;

    return ( $title, $source, $year, $volume, $start_page, $end_page, $author );

}


#################################################


sub get_protein_complete {

    my $word = $_[1];
    my $wild_card = $_[2];
    
    my $new_word;
    my $sth1;

    if( $wild_card eq "ON" ) {
        $new_word = "%".$word."%";
	$word = "%".$word."%";
	$sth1 = $dbh->prepare( "select gene_product_id, swissprot_acc
                                from gene_product_helper_two
                                where UPPER(gene_product_name) like ?
                                or UPPER(swissprot_acc) like ?
                                or UPPER(swissprot_id) like ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank" );
    } else {
        $new_word = "% ".$word." %";
	$sth1 = $dbh->prepare( "select gene_product_id, swissprot_acc 
                                from gene_product_helper_two
                                where UPPER(gene_product_name) like ?
                                or UPPER(swissprot_acc) = ?
                                or UPPER(swissprot_id) = ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank" );
    }
    
    
    

    $sth1->bind_param( 1, $new_word );
    $sth1->bind_param( 2, $word );
    $sth1->bind_param( 3, $word );
    $sth1->bind_param( 4, $new_word );
    
    $sth1->execute();

    my ( @ids, @accs );
    my ( $id, $acc );
    

    while( ( $id, $acc ) = $sth1->fetchrow_array() ) {
        
	    @ids = ( @ids, $id );
	    @accs = ( @accs, $acc );
	    
    }


    $sth1->finish;
    
    
    return ( \@ids, \@accs );

}


###################


sub get_all_refs {

    my $gp_id = $_[1];
    my $sth1 = $dbh->prepare( "select gene_product_name
                               from gene_product_helper_two
                               where gene_product_id = ?" );
    $sth1->bind_param( 1, $gp_id );
    $sth1->execute();
    my $gp_name = $sth1->fetchrow_array();
    substr( $gp_name, 0, 1 ) = "";
    substr( $gp_name, -1, 2 ) = "";
    my @names = split( /   /, $gp_name );
    
    my $query = "select reference_id 
                 from reference_extra
                 where UPPER(title) like ?
                 or UPPER(abstract_part_a) like ?
                 or UPPER(abstract_part_b) like ?";
    my $i = 2;
    while( $i <= scalar( @names ) ) {
        $query = $query." or UPPER(title) like ?
                          or UPPER(abstract_part_a) like ?
                          or UPPER(abstract_part_b) like ?";
	$i++;
    }
    my $sth2 = $dbh->prepare( $query );
    my $j = 1;
    while( $j <= scalar( @names ) ) {
        my $l = $j * 3 - 2;
	my $m = $j * 3 - 1;
	my $n = $j * 3;
	$names[$j-1] =~ tr/a-z/A-Z/;
	$names[$j-1] = "% ".$names[$j-1]." %";
	$sth2->bind_param( $l, $names[$j-1] );
	$sth2->bind_param( $m, $names[$j-1] );
	$sth2->bind_param( $n, $names[$j-1] );
	$j++;
    }
    $sth2->execute();
    my( $ref_id, @ref_ids );
    while( $ref_id = $sth2->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
    }
    $sth1->finish;
    $sth2->finish;
    return @ref_ids;

}


#################

sub get_features {

    my $pid = $_[1];
    my $sth1 = $dbh->prepare( "select feature_type, from_position, to_position
                               from gene_product_feature
                               where gene_product_id = ?
                               order by from_position" );

    $sth1->bind_param( 1, $pid );
    $sth1->execute();
    my( $feature, $from, $to, @features, @froms, @tos );
    while( ( $feature, $from, $to ) = $sth1->fetchrow_array ) {
        @features = ( @features, $feature );
	@froms = ( @froms, $from );
	@tos = ( @tos, $to );
    }
    $sth1->finish;
    return ( \@features, \@froms, \@tos );

}



################

1;
	

