package Gramene::GenbankTranslation;

use strict;
use warnings;

use Boulder::Genbank;

use constant OK => 2;
use constant BAD => 3;
use constant GENBANK_WRONG=>4;

# {-genbank} is defined iff genbank_translation row exists 
# {-ok} is defined iff translation_ok row exists

sub new {
    my($class,$db,$transcript)=@_;
    $db && $transcript or die "genbank_translation needs database handle and transcript";
    my $self={-db=>$db,-transcript=>$transcript};
    $self->{-genbank}=$db->selectrow_array(
	    "select genbank_id from genbank_translation where transcript_id=?"
	    ,undef
	    ,$transcript);
    $self->{-ok}=$db->selectrow_array(
	    "select ok from translation_ok where transcript_id=?"
	    ,undef
	    ,$transcript);
    bless $self,$class;
    return $self;
}

sub translation {
    my($self,$newlation)=@_;

    if(defined $newlation) {	#set
	if(defined $self->{-genbank}) {
	    if(!defined $self->translation ||  $self->translation ne $newlation) {
		#print $self->{-transcript}," lates to $newlation\n";
		$self->{-db}->do(
		"update genbank_translation set translation=? where transcript_id=?"
		,undef
		,$newlation,$self->{-transcript}) 
#		&& ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			    or die "Update translation".$self->{-db}->errstr;
	    }
	} elsif($newlation) {	
	    print STDERR "can't create genbank_translation for ",$self->{-transcript},"without genbank id !\n";
#	    #print $self->{-transcript}," lates to $newlation\n";
#	    $self->{-db}->do(
#	    "insert into genbank_translation (transcript_id,translation) values(?,?)"
#	    ,undef
#	    ,$self->{-transcript},$newlation) 
##		&& ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
#			or die "create for translation".$self->{-db}->errstr;
	}
	$self->{-translation}=$newlation;
    } else {		#get
	if(!exists $self->{-translation}) {
	    if(defined $self->{-genbank}) {
		$self->{-translation}=$self->{-db}->selectrow_array(
			"select translation from genbank_translation where transcript_id=?"
			,undef
			,$self->{-transcript});
	    } else {
	        $self->{-translation}=undef;
	    }
	}
    }
    return $self->{-translation};
}

sub genbank_id {
    my($self,$newgenbank)=@_;

    if(defined $newgenbank) {	#set
	if(defined $self->{-genbank}) {
	    if( $self->{-genbank} ne $newgenbank) {
	        if($newgenbank ne '') {
		    $self->{-db}->do(
		    "update genbank_translation set genbank_id=? where transcript_id=?"
		    ,undef
		    ,$newgenbank,$self->{-transcript}) 
	#		&& ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			    or die "Update genbank_id to <$newgenbank> ".$self->{-db}->errstr;
	        } else {
		    $self->{-db}->do(
		    "delete from genbank_translation  where transcript_id=?"
		    ,undef
		    ,$self->{-transcript}) 
	#		&& ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			    or die "delete".$self->{-db}->errstr;
		    undef $newgenbank;
		}
	    }
	} elsif($newgenbank) {
	    $self->{-db}->do(
	    "insert into genbank_translation (transcript_id,genbank_id) values(?,?)"
	    ,undef
	    ,$self->{-transcript},$newgenbank) 
#	    && ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			or die "create for genbank_id".$self->{-db}->errstr;
	}
	$self->{-genbank}=$newgenbank;
    } 		#get doesn't need to do anything since we got it in new()
    return $self->{-genbank};
}

sub ok {
    my($self,$newok)=@_;

    if(defined $newok) {	#set
	$newok=$newok==1?OK:$newok==-1?GENBANK_WRONG:BAD;
	if(defined $self->{-ok}) {
	    if( $self->{-ok} != $newok) {
		$self->{-db}->do(
		"update translation_ok set ok=? where transcript_id=?"
		,undef
		,$newok,$self->{-transcript}) 
#		&& ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			    or die "Update ok".$self->{-db}->errstr;
	    }
	} else {
	    #print "Inserting ",$self->{-transcript}," ok=$newok\n";
	    $self->{-db}->do(
	    "insert into translation_ok (transcript_id,ok) VALUES (?,?)"
	    ,undef
	    ,$self->{-transcript},$newok) 
#	    && ($self->{-db}->{AutoCommit} || $self->{-db}->commit )
			or die "create for ok".$self->{-db}->errstr;
	}
	$self->{-ok}=$newok;
    } 		#get doesn't need to do anything since we got it in new()
    return defined $self->{-ok} ? $self->{-ok}==GENBANK_WRONG?-1
    							   :$self->{-ok}==OK 
                                : undef;
}

sub verify {	#refresh the values from genbank and compare
    my($self,$our_translation)=@_;
    (my $acc=$self->{-genbank})=~s/\.\d*$//;
    my $gb = new Boulder::Genbank(-accessor=>'Entrez',
	      -db => 'p',
	      -fetch => [$acc]  );

    $gb or print "Boulder::Genbank(..,$acc) failed\n";
    my $s;
    if($s = $gb->get and $s->Sequence) {
	#print $self->{-genbank}," ",length($s->Sequence),"\n";
	$self->translation( lc($s->Sequence));
	$our_translation=lc($our_translation); 
	if( $self->translation eq $our_translation) {
	    return $self->ok(1);
	} elsif(  substr($self->translation,0,1) eq 'm' && 
	          substr($our_translation,0,1) eq 'l' &&
	    substr($self->translation,1) eq substr($our_translation,1) ) {
	    return $self->ok(-1);
	} else {
	    return $self->ok(0);
	}
    } 
    print $s?"only ".$s->tags."\n":"get failed\n";
    print "Couldn't get ",$self->{-genbank},"\n";
    return 0;
}

1;

