#!/usr/local/bin/perl -w
###############################################################################
#
#   Name:           ExtURL.pm
#
#   Description:    Module to compose URLs from a database name and an 
#		    identifier.
#
#   Usage:	    my $urlaliser = ExtURL->new;
#		    my $SNP_URL = $urlaliser->get_url("SNP","t7107252");
#
#		    $SNP_URL now contains 
#		      "http://www.snpland.org/cgi-bin/getsnp?id=t7107252"
#
#		    Base URL information comes from SiteDefs, and is of the
#		    form "http://whatever.org/whatever?foo=###ID###" where 
#		    "###ID###" is replaced in this module by the passed id.
#
#   History:        2001-01-16  jws:    original version
#
###############################################################################

package ExtURL;

use strict;
use SiteDefs qw(:URL);
use CGI;
my $INDEXER_PREFIX="ExtIndex_";


sub new {
    my $self=shift;
    my %urls = %{$ENSEMBL_EXTERNAL_URLS};
    return bless \%urls, $self;
}


sub get_url{
    my ($self, $db, $id)=@_;
    my $url="";

    $id=CGI->escape($id);
    if ($self->is_linked($db)){
	$url = $self->{$db};
	$url =~ s/###ID###/$id/;
    }
    elsif ($self->is_linked('DEFAULT')){
	$url = $self->{'DEFAULT'};
	$url =~ s/###ID###/$id/;
	$url =~ s/###DB###/$db/;
    }
	
    return $url;
}

sub is_linked{
    my ($self,$db)=@_;
    return exists $self->{$db};
}

1;
