#!/usr/local/bin/perl -w
###############################################################################
#
#   Name:           ExtIndex_SRS
#   
#   Description:    Implementation of the ExtIndex interface for SRS.
#                   The ExtIndex interface defines two functions:
#                       get_seq_by_id
#                       get_seq_by_acc
#
#                   These functions are called from ExtIndex.pm with a hashref
#                   of the following arguments:
#
#                   'EXE'       :   The executable to be used to search with
#                                   (e.g. getz)
#                   'DB'        :   The database to search (e.g. EMBL)
#                   'ID|ACC'    :   ID or Accession to search for
#                   'FORMAT'    :   Return FASTA or EMBL format
#                   'OPTIONS'   :   Return 'id', 'acc', 'desc', 'seq', 'all'
#                                   Describes what part of the results to 
#                                   return.
#
#
#   History:        2000-10-27  jws initial version
#
###############################################################################
package ExtIndex_SRS;
use strict;

my %options=(   'id'    =>  ['-f','id'],
                'acc'   =>  ['-f','acc'],
                'seq'   =>  ['-f','seq'],
                'desc'  =>  ['-f','des'],
                'all'   =>  ['-e'],
            );

sub get_seq_by_id{
    my ($self, $arghashref)=@_;
    my %args=%$arghashref;
    my $pid='';
    my @output;
    
    ########################
    # munge db to SRS style
    ########################
    $args{'DB'} = lc($args{'DB'}).'-id';
    
    
    ##################################
    # fork child process to read from
    ##################################
    unless (defined ($pid=open(READABLE_CHILD, "-|"))){
        warn "Cannot fork Readable_child for get_seq_by_id SRS: $!\n";
        return undef;
    }

    if ($pid){  # I'm the Daddy!
        @output=<READABLE_CHILD>;
        close READABLE_CHILD;
    }
    else {      # I'm the child 
		unless(exec($args{'EXE'}, 
                    @{$options{$args{'OPTIONS'}}}, 
                    "[$args{'DB'}:$args{'ID'}]"
                    )
                ){
            warn "Cannot exec SRS call $!\n";
            return undef;
        }
    }

    return \@output;
}


sub get_seq_by_acc{
    my ($self, $arghashref)=@_;
    my %args=%$arghashref;
    my $pid='';
    my @output;
    
    ########################
    # munge db to SRS style
    ########################
    $args{'DB'} = lc($args{'DB'}).'-acc';
    
    
    ##################################
    # fork child process to read from
    ##################################
    unless (defined ($pid=open(READABLE_CHILD, "-|"))){
        warn "Cannot fork Readable_child for get_seq_by_acc SRS: $!\n";
        return undef;
    }

    if ($pid){  # I'm the Daddy!
        @output=<READABLE_CHILD>;
        close READABLE_CHILD;
    }
    else {      # I'm the child 
        unless(exec($args{'EXE'}, 
                    @{$options{$args{'OPTIONS'}}}, 
                    "[$args{'DB'}:$args{'ACC'}]"
                    )
                ){
            warn "Cannot exec SRS call $!\n";
            return undef;
        }
    }

    return \@output;

}

1;
