package ColourMap;
use strict;
use Exporter;
use vars qw(@ISA);
@ISA = qw(Exporter);

sub new {
    my ($class, $cookie) = @_;

    my $self = {
	'a' => {
	    'name'  => 'red',
	    'value' => 'ff0000',
	},
	'b' => {
	    'name'  => 'green',
	    'value' => '00ff00',
	},
	'c' => {
	    'name'  => 'blue',
	    'value' => '0000ff',
	},
	'd' => {
	    'name'  => 'cyan',
	    'value' => '00ffff',
	},
	'e' => {
	    'name'  => 'yellow',
	    'value' => 'ffff00',
	},
	'f' => {
	    'name'  => 'magenta',
	    'value' => 'ff00ff',
	},
	'g' => {
	    'name'  => 'black',
	    'value' => '000000',
        },
	'h' => {
	    'name'  => 'white',
	    'value' => 'ffffff',
	},
	'i' => {
	    'name'  => 'yellow1',
	    'value' => 'ffffe7',
	},
	'j' => {
	    'name'  => 'yellow2',
	    'value' => 'fffffa',
	},
	'k' => {
	    'name'  => 'grey1',
	    'value' => 'c8c8c8',
	},
	'l' => {
	    'name'  => 'grey2',
	    'value' => 'c0c0c0',
	},
	'm' => {
	    'name'  => 'offwhite',
	    'value' => 'fbffff',
	},
	'n' => {
	    'name'  => 'rust',
	    'value' => 'a00000',
	},
	'o' => {
	    'name'  => 'gold1',
	    'value' => 'ffcc00',
	},
	'p' => {
	    'name'  => 'gold2',
	    'value' => 'ff9600',
	},
	'q' => {
	    'name'  => 'purple1',
	    'value' => '820082',
	},
	'r' => {
	    'name'  => 'orange',
	    'value' => 'ffb619',
	},
	's' => {
	    'name'  => 'darkblue',
	    'value' => '000046',
	},
	't' => {
	    'name'  => 'contigblue2',
	    'value' => '02599c',
	},
	'u' => {
	    'name'  => 'pine',
	    'value' => '00961c',
	},
	'v' => {
	    'name'  => 'contigblue1',
	    'value' => '368ec9',
	},
	'w' => {
	    'name'  => 'pink',
	    'value' => 'ff1493',
	},
	'x' => {
	    'name'  => 'grey3',
	    'value' => '888888',
	},
 	'y' => {
	    'name'  => 'lightseagreen',
	    'value' => '20b2aa',
	},
 	'z' => {
	    'name'  => 'slategrey',
	    'value' => '46505a',
	},
	'A' => {
	    'name'  => 'darkorange',
	    'value' => 'ff8c00',
	},
	'B' => {
	    'name'  => 'gold3',
	    'value' => 'ffd700',
	},
	'C' => {
	    'name'  => 'goldenrod',
	    'value' => 'daa520',
	},
	'D' => {
	    'name'  => 'firebrick',
	    'value' => 'b22222',
	},
	'E' => {
	    'name'  => 'peach',
	    'value' => 'cd853f',
	},
	'F' => {
	    'name'  => 'darkgoldenrod',
	    'value' => 'b8860b',
	},
  };

    bless($self, $class);
    return $self;
}

sub name_by_id {
    my ($self, $id) = @_;
    return %{$self->{$id}}->{'name'} if(defined $self->{$id});
}

sub hex_by_id {
    my ($self, $id) = @_;
    return %{$self->{$id}}->{'value'} if(defined $self->{$id});
}

sub rgb_by_id {
    my ($self, $id) = @_;

    if(defined $self->{$id}) {
	my ($hred, $hgreen, $hblue) = unpack("A2A2A2", %{$self->{$id}}->{'value'});
	return (hex($hred), hex($hgreen), hex($hblue));
    }
}

sub id_by_name {
    my ($self, $name) = @_;
    for my $id (keys %{$self}) {
	return $id if(%{$self->{$id}}->{'name'} eq $name);
    }
}

sub hex_by_name {
    my ($self, $name) = @_;
    return $self->hex_by_id($self->id_by_name($name));
}

sub rgb_by_name {
    my ($self, $name) = @_;
    return $self->rgb_by_id($self->id_by_name($name));
}

sub ids {
    my ($self, $name) = @_;
    return (keys %{$self});
}

sub names {
    my ($self, $name) = @_;
    my @results = ();
    for my $id (keys %{$self}) {
	push @results, %{$self->{$id}}->{'name'};
    }
    return @results;
}

sub hex_by_rgb {
    my ($self, $triple_ref) = @_;
    return sprintf("%02x%02x%02x", @{$triple_ref});
}

sub add_rgb {
    my ($self, $triple_ref) = @_;
    my $hex = $self->hex_by_rgb($triple_ref);
    $self->{$hex} = {
	'name'  => qq($hex),
	'value' => $hex,
    };
    return $hex;
}

sub add_hex {
    my ($self, $hex) = @_;
    $self->{$hex} = {
	'name'  => $hex,
	'value' => $hex,
    };
    return $hex;
}
1;
