package Apache::EnsEMBL::ServerError;
       
use strict;
use Apache::Constants qw(:response :http);
use Apache::File ();
use Apache::Log ();
use CGI qw(:html);
use SiteDefs qw(:WEB);

my %whose = (
    '/perl/SeqTable.cgi'		=> 'pan@cshl.org',
    '/perl/blast/pairwise.pl'		=> 'teytelma@cshl.org',
    '/perl/blast/remote_blast.pl'	=> 'teytelma@cshl.org',
    '/perl/blast/temp.pl'   		=> 'teytelma@cshl.org',
    '/perl/blast/working_pairwise.pl'	=> 'teytelma@cshl.org',
    '/perl/mutant/search_core'   	=> 'changku@cshl.org',
    '/perl/mutant/search_m'      	=> 'changku@cshl.org',
    '/perl/mutant/search_mutant' 	=> 'changku@cshl.org',
    '/perl/ontology/goterm'	   	=> 'changku@cshl.org',
    '/perl/ontology/search'	   	=> 'changku@cshl.org',
    '/perl/ontology/search_core'   	=> 'changku@cshl.org',
    '/perl/ontology/search_mutant' 	=> 'changku@cshl.org',
    '/perl/ontology/search_term'   	=> 'changku@cshl.org',
    '/perl/protein_search'		=> 'zhaow@cshl.edu',
    '/perl/pub_search'		        => 'zhaow@cshl.edu',
    '/perl/add_pubmed'		        => 'zhaow@cshl.edu',
    '/perl/add_ref'	                => 'zhaow@cshl.edu',
    '/perl/uni/protein_search'		=> 'zhaow@cshl.edu',
    
);

sub handler {

    my $r = shift;
    
    my $whence      = $r->headers_in->{'Referer'};
	    #.":".$r->the_request()."+". $r->err_header_out('Ensembl-Referer');
    my $error	    = $r->err_header_out('Ensembl-Error');
    my $exception   = $r->err_header_out('Ensembl-Exception');
    my $err_server  = $r->err_header_out('Ensembl-Server');
    my $nomail	    = $r->err_header_out('Ensembl-Nomail');
    unless ($error){
	$error = 'unknown (no specific information available)';
    }
    else{
	my $serverroot = $r->server_root_relative();
	$error =~ s!$serverroot!!ig;
    }

    return OK if $r->header_only;
	    
    #Only print header if they have not been sent already
    unless ($r->err_header_out('ensembl_headers_out')){  
	$r->content_type('text/html');
	$r->send_http_header;
	my $header = "";
	&Apache::EnsEMBL::Header::make_ensembl_header(\$r, \$header);
	$r->print($header); 
    }
	    
    ###############################################################
    # If ENSEMBL_MAIL_ERRORS is set, then mail out an error report
    ###############################################################
    if ($ENSEMBL_MAIL_ERRORS and !$nomail){
    
	my $date     = `date +"%Y-%m-%d %H:%M:%S"`;
	chomp $date;
	my $scriptname=$ENV{'REDIRECT_URL'};
	$scriptname=~s:/perl/::;

	my $mailto= $whose{$ENV{'REDIRECT_URL'}} || $ENSEMBL_ERRORS_TO;
	
	my $mail_subj="Ensembl Automailed Error :$ENSEMBL_SERVER : $scriptname : $error";
	open(MAILER, "| /usr/ucb/Mail -s '$mail_subj' $mailto");
	print MAILER "Date: $date\n";
	print MAILER "Error: $error\n";
	print MAILER "Exception: $exception\n";
	print MAILER "Server: $err_server\n";
	print MAILER "URL: ".$ENV{'REDIRECT_URL'}."\n";
	print MAILER "HTTP Status: ".$ENV{'REDIRECT_STATUS'}."\n";
	print MAILER "Request: ".$ENV{'REDIRECT_REQUEST_METHOD'}."\n";
	print MAILER "Query String: ".$ENV{'REDIRECT_QUERY_STRING'}."\n";
	print MAILER "IP: ".$ENV{'REDIRECT_REMOTE_ADDR'}."\n";
	print MAILER "Referred by: $whence\n";
	close(MAILER);
    }
    else {
	print STDERR "$error: \n$exception\n";
    }

    #######################
    # Report error to user
    #######################
    my $admin = $r->server->server_admin;
    $r->print (
    
	h1('Gramene EnsEMBL Server Error'),
	p("Sorry, an error occurred while the Ensembl server was processing
	    your request."),
	p("Please email a report , quoting any additional information given
	    below, along with the URL, to $admin."),

	p(b("The error was:")),
	p(
	    blockquote({-class=> "error"},
	    strong(pre($error)),
	    )
	),
		
	end_html
	);
	    
    my $footer = "";
    &Apache::EnsEMBL::Footer::make_ensembl_footer(\$r, \$footer);
    $r->print($footer);

    return OK;
}

1;

__END__

