package Apache::EnsEMBL::Header;
use Apache;
use GramenePage;
       
use strict;
use SiteDefs qw/:DEFAULT :URL $ENSEMBL_SERVERADMIN/;
use vars qw/@ISA @EXPORT @EXPORT_OK/;

#############################################################
# Construct the standard EnsEMBL page header
#############################################################
sub make_ensembl_header {

    my ($req_ref, $header_ref, $args) = @_;

    my %tmphash = %{$args} if $args;

    my $stylesheet = qq(/EnsEMBL.css);
    $stylesheet = qq(/EnsEMBL-mac.css) if($$req_ref->header_in('User-Agent') =~ /Mac/);

    $tmphash{'Title'} 	    ||= "Gramene EnsEMBL Server";
    $tmphash{'Author'}      ||= "webmaster\@gruyere.cshl.org";
    $tmphash{'Keywords'}    ||= "Ensembl, genome, automated annotation, Rice Genome Project, Grass genetics, DNA sequencing";
    $tmphash{'Description'} ||= "Ensembl is a joint project between EMBL-EBI and the Sanger Centre to develop a software system which produces and maintains automatic annotation on eukaryotic genomes.  Gramene applies Ensembl to Rice as a basis for comparative grass genomics.";

my $gramene= $ENSEMBL_EXTERNAL_URLS->{'GRAMENE_HOME'};
    $$header_ref= qq(
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<HTML>
 <HEAD>
  <TITLE>$tmphash{'Title'}</TITLE>
  <LINK REL="stylesheet" HREF="$stylesheet">
  <meta name="keywords" content="$tmphash{'Keywords'}">
  <meta name="description" content="$tmphash{'Description'}">
  <meta name="author" content="$tmphash{'Author'}">
 </HEAD>
);
# <BODY TEXT="#000000" BGCOLOR="#FFFFFF" topmargin="2" marginheight="2">
# 
# <!-- begin header -->
# <table width="100%" border="0" >
#   <tr valign="bottom">
#     <td width="150" align="center"><table border="0" cellspacing="0" cellpadding="0">
#         <tr>
#             <td align="left"><A HREF="http://www.ensembl.org"><IMG SRC="/gramene/images/icons/e_with.png" BORDER="0" alt="Ensembl"></A></td>
#         </tr>
#     </table></td>
#     <td align="left"><A HREF="$gramene/index.html"><IMG SRC="/gramene/images/icons/gramene_banner.gif" BORDER="0" alt=Gramene></a>
#   </tr>
# </table>
# <!-- end header -->
#<table width="100%" border="0" cellspacing="0" cellpadding="0">
#  <tr valign="bottom">
#    <td align="left"><A HREF="http://www.gramene.org"><IMG SRC="/gramene/images/icons/gramene_banner.gif" BORDER="0" alt=Gramene></a>
#    <td><table border="0" cellspacing="0" cellpadding="0">
#	<tr>
#	    <td align="left"><font size=6 color=#FF0000><i><strong>Built with</strong></i></font>
#	</tr>
#	<tr>
#	    <td align="left"><A HREF="http://www.ensembl.org"><IMG SRC="/gfx/ensembl-header1.gif" BORDER="0" width="286" height="40" alt="Ensembl"></A></td>
#	</tr>
#    </table></td>
#  </tr>
#</table>

my $r           = Apache->request();
my $grpg=GramenePage->new($r);
$$header_ref .= $grpg->start_body(  -ensembl=>1);

    return;

} # end of sub"
######################### This is the list of exported subroutines #######################

@EXPORT = qw(make_ensembl_header);

##########################################################################

1;
__END__

#
# EnsEMBL module for Apache::EnsEMBL::Header
#
# Cared for by Tony Cox <avc@sanger.ac.uk>
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs after the code

=head1 NAME

Apache::EnsEMBL::Header - Apache Mod_perl module to generate a standard EnsEMBL
HTML page header

=head1 SYNOPSIS

=head2 General

This mod_perl module is used to generate a standard EnsEMBL
HTML page header


=head1 RELATED MODULES

See also: Apache::EnsEMBL::SendPage, Apache::EnsEMBL::Footer

=head1 FEED_BACK

=head2 Mailing Lists

User feedback is an integral part of the evolution of this and other
EnsEMBL modules. Send your comments and suggestions to one of the
EnsEMBL mailing lists.  Your participation is much appreciated.

  http://ensembl.ebi.ac.uk/?     - About the mailing lists

=head2 Reporting Bugs

Report bugs to the EnsEMBL bug tracking system to help us keep track
the bugs and their resolution.  Bug reports can be submitted via
email or the web:

  ?@ensembl.ebi.ac.uk
  http://ensembl.ebi.ac.uk/?

=head1 AUTHOR - Tony Cox

Email - avc@sanger.ac.uk


=cut
