package Apache::EnsEMBL::Footer;
       
use strict;
use SiteDefs qw/:DEFAULT $ENSEMBL_SERVERADMIN/;
use Apache;
use GramenePage;
use vars qw/@ISA @EXPORT @EXPORT_OK/;

#############################################################
# Construct the standard EnsEMBL page header
#############################################################

sub make_ensembl_footer {


    my ($req_ref, $footer_ref, $args) = @_;
    my $modtime = localtime ((stat $$req_ref->finfo())[9]);

    if(!$modtime ) {
        $modtime = qq();
    } else {
        $modtime = qq(last modified : $modtime);
    }
    
    my %tmphash = %$args if $args;

    #$tmphash{'Author'} ||= $ENSEMBL_SERVERADMIN;   #"webmaster\@ensembl.org";

    $$footer_ref=<<EOS;

<!-- begin footer -->

<TABLE BORDER="0" WIDTH="100%" cellpadding="0" cellspacing="0">
  <TR bgcolor="#f5f5ff" valign="center">
    <TD>
      &nbsp;<I><small>$modtime</small></I>
    </TD>
    <td><img src="/gfx/blank.gif" width="20" height="22"></td>
    <TD ALIGN="RIGHT">
        <I>
	<address><a href="mailto:$ENSEMBL_SERVERADMIN">$ENSEMBL_SERVERADMIN</a></address>
	</I>&nbsp;
    </TD>
  </TR>
</TABLE>
<br>
<!-- end footer -->

</BODY>
</HTML>
EOS
my $r           = Apache->request();
my $grpg=GramenePage->new($r);
$$footer_ref .= $grpg->end_body;
	#<A HREF="/feedback.html"><small>$tmphash{'Author'}</small></A>
	#<address><a href="mailto:gramene@gramene.org">gramene@gramene.org</a></address>

    return;

} # end of sub"

######################### This is the list of exported subroutines #######################

@EXPORT = qw(make_ensembl_footer);

##########################################################################

1;
__END__

#
# EnsEMBL module for Apache::EnsEMBL::Footer
#
# Cared for by Tony Cox <avc@sanger.ac.uk>
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs after the code

=head1 NAME

Apache::EnsEMBL::Footer - Apache Mod_perl module to generate a standard EnsEMBL
HTML page footer

=head1 SYNOPSIS

=head2 General

This mod_perl module is used to take a standard EnsEMBL
HTML page footer


=head1 RELATED MODULES

See also: Apache::EnsEMBL::SendPage, Apache::EnsEMBL::Header

=head1 FEED_BACK

=head2 Mailing Lists

User feedback is an integral part of the evolution of this and other
EnsEMBL modules. Send your comments and suggestions to one of the
EnsEMBL mailing lists.  Your participation is much appreciated.

  http://ensembl.ebi.ac.uk/?     - About the mailing lists

=head2 Reporting Bugs

Report bugs to the EnsEMBL bug tracking system to help us keep track
the bugs and their resolution.  Bug reports can be submitted via
email or the web:

  ?@ensembl.ebi.ac.uk
  http://ensembl.ebi.ac.uk/?

=head1 AUTHOR - Tony Cox

Email - avc@sanger.ac.uk


=cut
