CREATE TABLE mutant
(
	mutant_id		number(11) not null		CONSTRAINT pk_mutant PRIMARY KEY,
	mutant_name		varchar2(128) not null,
	mutant_description 	varchar2(4000) not null,
	UNIQUE(mutant_name)
);
--- UNIQUE(mutant_name, mutant_description)

CREATE TABLE image
(
	image_id		number(11) 	not null		CONSTRAINT pk_image PRIMARY KEY,
	path			varchar2(128)	not null,
	UNIQUE(path)
);

CREATE TABLE object_to_image
(
	object_to_image_id	number(11) not null		CONSTRAINT pk_object_to__image PRIMARY KEY,
	image_id		number(11) not null		REFERENCES image,
	parent_name		varchar2(128) not null,
	parent_id		number(11) not null,
	UNIQUE(parent_name, parent_id, image_id)
);
COMMENT ON TABLE object_to_image is
'parent_id is the same as row_id';

CREATE TABLE mutagenesis_type
(
	mutagenesis_type_id	number(11) not null		CONSTRAINT pk_mutagenesis_type PRIMARY KEY,
	mutagenesis_type_name	varchar(128) not null,
	UNIQUE(mutagenesis_type_name)
);

CREATE TABLE mutagenesis
(
	mutagenesis_id		number(11) not null		CONSTRAINT pk_mutagenesis PRIMARY KEY,
	mutagenesis_type	number(11) not null		REFERENCES mutagenesis_type(mutagenesis_type_id),
	mutagenesis_description	varchar2(1024)
);

CREATE TABLE mutant_to_mutagen
(
	mutant_to_mutagen_id	number(11) not null		CONSTRAINT pk_mutant_to_mutagen PRIMARY KEY,
	mutant_id	number(11) not null			REFERENCES mutant,
	mutagenesis_id	number(11) not null			REFERENCES mutagenesis,
	UNIQUE (mutant_id, mutagenesis_id)
);
COMMENT ON TABLE mutant_to_mutagen is
'should have evidence';

CREATE TABLE geographical_location
(
	geographical_location_id	number(11) not null	CONSTRAINT pk_geographical_location PRIMARY KEY,
	location_name			varchar2(128) not null,
	latitude_degree			number(2) not null,
	latitude_minute			number(2) not null,
	is_north			number(1) not null	CHECK(is_north = 0 OR is_north = 1),
	longitude_degree		number(2) not null,
	longitude_minute		number(2) not null,
	is_west				number(1) not null	CHECK(is_west = 0 OR is_west = 1),
	UNIQUE(location_name, latitude_degree,latitude_minute, is_north, longitude_degree, longitude_minute, is_west) 	
);

CREATE TABLE season
(
	season_id	number(11) not null		CONSTRAINT pk_season_id PRIMARY KEY,
	season_definition	varchar2(128) not null,
	UNIQUE(season_id, season_definition)
);

CREATE TABLE developmental_stage
(
	developmental_stage_id	number(11) not null	CONSTRAINT pk_developmental_stage PRIMARY KEY,
	boolean_stages		varchar2(16) not null,
	UNIQUE(boolean_stages)
);
COMMENT on column developmental_stage.boolean_stages is
'developmental_stage is a number with 9 digits.  Each digit records the boolean of each stage.';

--- CREATE OR REPLACE VIEW local_map
--- as
--- select map_id, map_name
--- from cmap.map;
--- grant references on map to ...

CREATE TABLE mutant_map_info
(
	mutant_map_info_id	number(11) not null 	CONSTRAINT pk_mutant_map_info PRIMARY KEY,
	mutant_id		number(11) not null	REFERENCES mutant,
	map_id			number(11) 		REFERENCES cmap.map,
	clone_accession		varchar2(128),		
	start_position		number(11),
	end_position		number(11),
	description		varchar2(1024),
	curator_id		number(11) not null	REFERENCES contributor(contributor_id),
	curator_comment		varchar2(4000)	
);
--- comment on table mutant_map_info is
--- 'Use this when the mutant is a locus on a map';
--- clone_accession references gene_product
--- curator_comment, for example, tells how to get start_position and end_position for JRGP maps

CREATE TABLE candidate_gene
(
	candidate_gene_id	number(11) not null		PRIMARY KEY,
	mutant_id		number(11) not null		REFERENCES mutant,
	phenotype_synonym	varchar2(128),
	gene_product_id	  	number(11) not null	  	REFERENCES gene_product,
	UNIQUE (mutant_id, phenotype_synonym, gene_product_id)
);
COMMENT on TABLE candidate_gene is
'one row for each piece of evidence associating the mutant and the gene';

CREATE TABLE mutant_study
(
    	mutant_study_id	number(11) not null 		CONSTRAINT pk_mutant_study PRIMARY KEY,
	mutant_id	number(11) not null		REFERENCES mutant,
	study_type	number(11) not null		CHECK(study_type = 1 OR study_type = 2 OR study_type =3),
	geographical_location_id	number(11) not null	REFERENCES geographical_location,
	year		number(11),
	season_id	number(11) 			REFERENCES season,
	temperature 	varchar2(128),
	light_regime	varchar2(128),
	humidity	varchar2(128),
	developmental_stage_id	number(11)		REFERENCES developmental_stage,
	UNIQUE(mutant_id, study_type, geographical_location_id, year, season_id, temperature, light_regime, humidity, developmental_stage_id)
);
COMMENT on TABLE mutant_study is
'no evidence - connect with reference using REFERENCE_TO_OBJECT table';
COMMENT on column mutant_study.study_type is
'field study or greenhouse or chamber';

CREATE TABLE germplasm_info
(
	germplasm_info_id number(11) not null		CONSTRAINT pk_germplasm_info PRIMARY KEY,
	mutant_id	number(11) not null		REFERENCES mutant,
	name		varchar(128) not null,
	accession	varchar(128),
	germplasm_db_type	varchar(128),
	wild_type	varchar(128),
	genus		varchar(128),
	species_id	number(11)			REFERENCES species,
	subspecies_id	number(11)			REFERENCES subspecies,
	UNIQUE(mutant_id, name, accession, germplasm_db_type, wild_type, genus, species_id, subspecies_id)
);

select * from tab;