#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;

use lib map { $ENV{'GrameneCodeDir'}."/$_" } qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use DBI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;
use Getopt::Std;

use vars qw/ $opt_d /;

getopts('d:') or die("-d only\n");

my $database=$opt_d;
$database=~ /^\d+$/ or die 'database id must be a number';



    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";


while(<>) {
    tr/\r//d;
    chomp; 
    next if /^#/;
                                                                    

    my($translation,$name,$accession)=split /[\t;]/;


    my $sth;
    $db->do( "insert into xref (externaldbid,dbprimary_id,display_id)
		    values($database,?,?)",undef,$accession,$accession)    #Could, alternatively, put $name in display_id
			    or die "insert xref:".$db->errstr;

    # Hey, what did we just do?  :
    ($sth=$db->prepare("select max(xrefid) from xref")) and $sth->execute 
						or die "xrefid:".$db->errstr;
    my ($xrefid)=$sth->fetchrow_array or die "xrefid:".$db->errstr;

    $db->do( "insert into objectxref (ensembl_object_type,ensembl_id,xrefid)
		    values( 'Translation',?,?)",undef, $translation, $xrefid ) 
			or die "insert objectxref:".$db->errstr;


}
 
