#!/usr/local/bin/perl 

#to be run in the gramene_ensembl directory

use strict;
use warnings;

use lib qw ( bioperl-live modules ensembl/modules ensembl-external/modules lib/perl );

use DBI;
use CSHL::Config;
use Bio::EnsEMBL::DBLoader;
use Bio::EnsEMBL::DBSQL::SQL::StatementHandle;
use Getopt::Std;

use vars qw/ $opt_a $opt_s /;

getopts('a:') or die("-a [-s] only\n");

my $analysis=$opt_a;
$analysis=~ /^\d+$/ or die 'analysis must be a number';

my $score=$opt_s || 110;
$score=~ /^\d+$/ or die 'score must be a number';


    my $db=Bio::EnsEMBL::DBLoader->new( EnsemblLocator ) or die "connect: $DBI::errstr";

my $feature_id;
{
my $sth;
($sth=$db->prepare("select max(id) from feature")) and $sth->execute 
					    or die "feature id:".$db->errstr;
($feature_id)=$sth->fetchrow_array or die "feature id:".$db->errstr;
$feature_id ||=0;
}
my $db_fset_id;

my $ff_rank=1;	#don't know what it does
my $last_fset=-1;	#better not be a real one!

$|=1;

while(<>) {
    tr/\r//d;
    chomp; 
    next if /^#/;
                                                                    

    my($fset_id,$feature_acc,$feature_start,$feature_stop
      ,$bac_accession,$version,$bac_start,$bac_stop
      ,$perc)=split /\t/;

    $bac_stop =~/\d/ && $bac_start =~/\d/ or print STDERR "?:$_\n" and next;

    if($fset_id != $last_fset) {
	$last_fset=$fset_id;
	$ff_rank=1;
	add_fset();
    }


    my $our_version;
    eval {
        $our_version= $db->get_Clone($bac_accession)->version;
    };
    $@ and print "$@\n" and next;
    print "BAC version should be $our_version:$_\n" and next if $our_version ne $version;

    #These are all offsets, so change to start=1:
    $bac_start++; $bac_stop++; $feature_start++; $feature_stop++;

    #Make sure they are start, end wrt BAC:
    ($bac_start,$bac_stop,$feature_start,$feature_stop)=
    ($bac_stop,$bac_start,$feature_stop,$feature_start) if($bac_start>$bac_stop);

    my($contig1,$ctgpos1,$ctglen1, $contig2,$ctgpos2,$ctglen2);
    eval {
	($contig1,$ctgpos1,$ctglen1)=$db->clone_to_contig($bac_accession,$bac_start);
	($contig2,$ctgpos2,$ctglen2)=$db->clone_to_contig($bac_accession,$bac_stop);
    };
    $@ and print "$@\n" and next;
    #print "$bac_accession: $bac_start -> $contig1,$ctgpos1;  $bac_stop -> $contig2,$ctgpos2\n";
    if(!$contig1 && ! $contig2) {
	print "$feature_acc, $bac_accession, $bac_start -> nowhere, $bac_stop -> nowhere\n";
    } elsif($contig1 && ! $contig2) {
	print "$feature_acc, $bac_accession, $bac_start -> $contig1,$ctgpos1, $bac_stop -> nowhere\n";
        add($contig1,$ctgpos1,$ctglen1
	   ,$feature_acc,$bac_start
	   ,($bac_start<$bac_stop)?($bac_start+$ctglen1-$ctgpos1)
				 :($bac_start-$ctglen1+$ctgpos1)
	   ,$perc);
    } elsif($contig2 && ! $contig1) {
	print "$feature_acc, $bac_accession, $bac_start -> nowhere, $bac_stop -> $contig2,$ctgpos2\n";
        add($contig2,1,$ctgpos2
	   ,$feature_acc
	   ,($bac_start<$bac_stop)?($bac_stop+1-$ctgpos2)
				 :($bac_stop-1+$ctgpos2)
	   ,$bac_stop
	   ,$perc);
    } elsif($contig1==$contig2) {
        add($contig1,$ctgpos1,$ctgpos2,
	    ,$feature_acc,$feature_start,$feature_stop
	    ,$perc);
    } else {  #yes this assumes the feature does not include a whole contig
	print "$feature_acc, $bac_accession, $bac_start -> $contig1,$ctgpos1, $bac_stop -> $contig2,$ctgpos2\n";
        add($contig1,$ctgpos1,$ctglen1
	   ,$feature_acc,$bac_start
	   ,($bac_start<$bac_stop)?($bac_start+$ctglen1-$ctgpos1)
				 :($bac_start-$ctglen1+$ctgpos1)
	   ,$perc);
        add($contig2,1,$ctgpos2
	   ,$feature_acc
	   ,($bac_start<$bac_stop)?($bac_stop+1-$ctgpos2)
				 :($bac_stop-1+$ctgpos2)
	   ,$bac_stop
	   ,$perc);
    }
}
 

sub add {
my($contig,$ctgstart,$ctgstop,
	    ,$feature_acc,$feature_start,$feature_stop
	    ,$perc)=@_;
    $db->do(
        "insert into feature (id,contig,seq_start,seq_end,score,strand
	                     ,analysis,name,hstart,hend,hid,perc_id)
			values (?,?,?,?,$score,1
			      ,$analysis,?,?,?,?,?)"
		       
	,undef,  ++$feature_id,$contig,$ctgstart,$ctgstop,
		 ,$feature_acc,$feature_start,$feature_stop,$feature_acc
		 ,$perc
	)
		or die "insert feature".$db->errstr;
    print STDERR "$db_fset_id:$feature_id\n";
    $db->do(
        "insert into fset_feature (feature,fset,rank)
			values (?,?,?)"
	,undef,  $feature_id,$db_fset_id,$ff_rank)
		or die "insert fset_feature".$db->errstr;
}

sub add_fset
{
my $sth;
    $db->do(
        "insert into fset (score)
			values ($score)"
	,undef)
		or die "insert fset".$db->errstr;

($sth=$db->prepare("select max(id) from fset")) and $sth->execute 
					    or die "fset id:".$db->errstr;
($db_fset_id)=$sth->fetchrow_array or die "fset id:".$db->errstr;
$db_fset_id ||=0;
}
